/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStructureUtil;
import com.liferay.portlet.dynamicdatamapping.service.persistence.DDMTemplateUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DDMPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "ddm";
    private static PortletDataHandlerBoolean _structures = new PortletDataHandlerBoolean("ddm", "structures", true, true);
    private static PortletDataHandlerBoolean _templates = new PortletDataHandlerBoolean("ddm", "templates");

    public static void exportStructure(PortletDataContext portletDataContext, Element structuresElement, DDMStructure structure) throws Exception {
        String path = DDMPortletDataHandlerImpl.getStructurePath(portletDataContext, structure);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element structureElement = structuresElement.addElement("structure");
        portletDataContext.addClassedModel(structureElement, path, (ClassedModel)structure, _NAMESPACE);
    }

    public static void importStructure(PortletDataContext portletDataContext, Element structureElement) throws Exception {
        String path = structureElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        DDMStructure structure = (DDMStructure)portletDataContext.getZipEntryAsObject(path);
        long userId = portletDataContext.getUserId(structure.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext(structureElement, (ClassedModel)structure, _NAMESPACE);
        DDMStructure importedStructure = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DDMStructure existingStructure = DDMStructureUtil.fetchByUUID_G((String)structure.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingStructure == null) {
                serviceContext.setUuid(structure.getUuid());
                importedStructure = DDMStructureLocalServiceUtil.addStructure((long)userId, (long)portletDataContext.getScopeGroupId(), (long)structure.getClassNameId(), (String)structure.getStructureKey(), (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (String)structure.getStorageType(), (int)structure.getType(), (ServiceContext)serviceContext);
            } else {
                importedStructure = DDMStructureLocalServiceUtil.updateStructure((long)existingStructure.getStructureId(), (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (ServiceContext)serviceContext);
            }
        } else {
            importedStructure = DDMStructureLocalServiceUtil.addStructure((long)userId, (long)portletDataContext.getScopeGroupId(), (long)structure.getClassNameId(), (String)structure.getStructureKey(), (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (String)structure.getStorageType(), (int)structure.getType(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)structure, (ClassedModel)importedStructure, _NAMESPACE);
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_structures, _templates};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_structures, _templates};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    protected static void exportTemplate(PortletDataContext portletDataContext, Element templatesElement, DDMTemplate template) throws Exception {
        String path = DDMPortletDataHandlerImpl.getTemplatePath(portletDataContext, template);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element templateElement = templatesElement.addElement("template");
        portletDataContext.addClassedModel(templateElement, path, (ClassedModel)template, _NAMESPACE);
    }

    protected static String getStructurePath(PortletDataContext portletDataContext, DDMStructure structure) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("166"));
        sb.append("/structures/");
        sb.append(structure.getStructureId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getTemplatePath(PortletDataContext portletDataContext, DDMTemplate template) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("166"));
        sb.append("/templates/");
        sb.append(template.getTemplateId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static void importTemplate(PortletDataContext portletDataContext, Element templateElement) throws Exception {
        String path = templateElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        DDMTemplate template = (DDMTemplate)portletDataContext.getZipEntryAsObject(path);
        long userId = portletDataContext.getUserId(template.getUserUuid());
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long structureId = MapUtil.getLong((Map)structureIds, (long)template.getStructureId(), (long)template.getStructureId());
        ServiceContext serviceContext = portletDataContext.createServiceContext(templateElement, (ClassedModel)template, _NAMESPACE);
        DDMTemplate importedTemplate = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DDMTemplate existingTemplate = DDMTemplateUtil.fetchByUUID_G((String)template.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingTemplate == null) {
                serviceContext.setUuid(template.getUuid());
                importedTemplate = DDMTemplateLocalServiceUtil.addTemplate((long)userId, (long)portletDataContext.getScopeGroupId(), (long)structureId, (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getType(), (String)template.getMode(), (String)template.getLanguage(), (String)template.getScript(), (ServiceContext)serviceContext);
            } else {
                importedTemplate = DDMTemplateLocalServiceUtil.updateTemplate((long)existingTemplate.getTemplateId(), (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getType(), (String)template.getMode(), (String)template.getLanguage(), (String)template.getScript(), (ServiceContext)serviceContext);
            }
        } else {
            importedTemplate = DDMTemplateLocalServiceUtil.addTemplate((long)userId, (long)portletDataContext.getScopeGroupId(), (long)structureId, (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getType(), (String)template.getMode(), (String)template.getLanguage(), (String)template.getScript(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)template, (ClassedModel)importedTemplate, _NAMESPACE);
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (!portletDataContext.addPrimaryKey(DDMPortletDataHandlerImpl.class, "deleteData")) {
            DDMTemplateLocalServiceUtil.deleteTemplates((long)portletDataContext.getScopeGroupId());
            DDMStructureLocalServiceUtil.deleteStructures((long)portletDataContext.getScopeGroupId());
        }
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.dynamicdatamapping", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("ddm-data");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        Element structuresElement = rootElement.addElement("structures");
        List ddmStructures = DDMStructureUtil.findByGroupId((long)portletDataContext.getScopeGroupId());
        for (DDMStructure structure : ddmStructures) {
            if (!portletDataContext.isWithinDateRange(structure.getModifiedDate())) continue;
            DDMPortletDataHandlerImpl.exportStructure(portletDataContext, structuresElement, structure);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "templates")) {
            Element templatesElement = rootElement.addElement("templates");
            List templates = DDMTemplateUtil.findByGroupId((long)portletDataContext.getScopeGroupId());
            for (DDMTemplate template : templates) {
                if (!portletDataContext.isWithinDateRange(template.getModifiedDate())) continue;
                DDMPortletDataHandlerImpl.exportTemplate(portletDataContext, templatesElement, template);
            }
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.dynamicdatamapping", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element structuresElement = rootElement.element("structures");
        List structureElements = structuresElement.elements("structure");
        for (Element structureElement : structureElements) {
            DDMPortletDataHandlerImpl.importStructure(portletDataContext, structureElement);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "templates")) {
            Element templatesElement = rootElement.element("templates");
            List templateElements = templatesElement.elements("template");
            for (Element templateElement : templateElements) {
                DDMPortletDataHandlerImpl.importTemplate(portletDataContext, templateElement);
            }
        }
        return portletPreferences;
    }
}

