/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.TemplateNameException;
import com.liferay.portlet.dynamicdatamapping.TemplateScriptException;
import com.liferay.portlet.dynamicdatamapping.action.ActionUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateServiceUtil;
import com.liferay.util.JS;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditTemplateAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        DDMTemplate template = null;
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                template = this.updateTemplate(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteTemplate(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                boolean saveAndContinue;
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                if (template != null && (saveAndContinue = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"saveAndContinue"))) {
                    redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, template, redirect);
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchTemplateException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.dynamic_data_mapping.error");
            }
            if (e instanceof TemplateNameException || e instanceof TemplateScriptException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getStructure((PortletRequest)renderRequest);
            ActionUtil.getTemplate((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchTemplateException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.dynamic_data_mapping.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.dynamic_data_mapping.edit_template"));
    }

    protected void deleteTemplate(ActionRequest actionRequest) throws Exception {
        long templateId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"templateId");
        if (templateId > 0L) {
            DDMTemplateServiceUtil.deleteTemplate((long)templateId);
        }
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, DDMTemplate template, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long structureId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"structureId");
        String availableFields = ParamUtil.getString((PortletRequest)actionRequest, (String)"availableFields");
        String saveCallback = ParamUtil.getString((PortletRequest)actionRequest, (String)"saveCallback");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setWindowState(actionRequest.getWindowState());
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("struts_action", "/dynamic_data_mapping/edit_template");
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("templateId", String.valueOf(template.getTemplateId()), false);
        portletURL.setParameter("groupId", String.valueOf(template.getGroupId()), false);
        portletURL.setParameter("structureId", String.valueOf(structureId), false);
        portletURL.setParameter("type", template.getType(), false);
        portletURL.setParameter("availableFields", availableFields, false);
        portletURL.setParameter("saveCallback", saveCallback, false);
        return portletURL.toString();
    }

    protected DDMTemplate updateTemplate(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        long templateId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"templateId");
        long groupId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"groupId");
        long structureId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"structureId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        String type = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"type");
        String mode = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"mode");
        String language = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"language", (String)"vm");
        String script = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"script");
        String scriptContent = JS.decodeURIComponent((String)ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"scriptContent"));
        if (Validator.isNull((String)script)) {
            script = scriptContent;
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMTemplate.class.getName(), (PortletRequest)actionRequest);
        DDMTemplate template = null;
        if (templateId <= 0L) {
            DDMStructure structure = DDMStructureLocalServiceUtil.getStructure((long)structureId);
            template = DDMTemplateServiceUtil.addTemplate((long)groupId, (long)structure.getStructureId(), (Map)nameMap, (Map)descriptionMap, (String)type, (String)mode, (String)language, (String)script, (ServiceContext)serviceContext);
        } else {
            template = DDMTemplateServiceUtil.updateTemplate((long)templateId, (Map)nameMap, (Map)descriptionMap, (String)type, (String)mode, (String)language, (String)script, (ServiceContext)serviceContext);
        }
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        if (Validator.isNotNull((String)portletResource)) {
            PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
            if (type.equals("detail")) {
                preferences.setValue("detailDDMTemplateId", String.valueOf(template.getTemplateId()));
            } else {
                preferences.setValue("listDDMTemplateId", String.valueOf(template.getTemplateId()));
            }
            preferences.store();
        }
        return template;
    }
}

