/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.dynamicdatamapping.NoSuchStructureException;
import com.liferay.portlet.dynamicdatamapping.RequiredStructureException;
import com.liferay.portlet.dynamicdatamapping.StructureDuplicateElementException;
import com.liferay.portlet.dynamicdatamapping.StructureNameException;
import com.liferay.portlet.dynamicdatamapping.StructureXsdException;
import com.liferay.portlet.dynamicdatamapping.action.ActionUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureServiceUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditStructureAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        DDMStructure structure = null;
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                structure = this.updateStructure(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteStructure(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                boolean saveAndContinue;
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                if (structure != null && (saveAndContinue = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"saveAndContinue"))) {
                    redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, structure, redirect);
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchStructureException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.dynamic_data_mapping.error");
            }
            if (e instanceof RequiredStructureException || e instanceof StructureDuplicateElementException || e instanceof StructureNameException || e instanceof StructureXsdException) {
                String redirect;
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
                if (e instanceof RequiredStructureException && Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))))) {
                    actionResponse.sendRedirect(redirect);
                }
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((PortletRequest)renderRequest, (String)"cmd");
            if (!cmd.equals("add")) {
                ActionUtil.getStructure((PortletRequest)renderRequest);
            }
        }
        catch (NoSuchStructureException noSuchStructureException) {
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.dynamic_data_mapping.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.dynamic_data_mapping.edit_structure"));
    }

    protected void deleteStructure(ActionRequest actionRequest) throws Exception {
        long structureId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"structureId");
        DDMStructureServiceUtil.deleteStructure((long)structureId);
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, DDMStructure structure, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String availableFields = ParamUtil.getString((PortletRequest)actionRequest, (String)"availableFields");
        String saveCallback = ParamUtil.getString((PortletRequest)actionRequest, (String)"saveCallback");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setWindowState(actionRequest.getWindowState());
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("struts_action", "/dynamic_data_mapping/edit_structure");
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("groupId", String.valueOf(structure.getGroupId()), false);
        portletURL.setParameter("structureId", String.valueOf(structure.getStructureId()), false);
        portletURL.setParameter("availableFields", availableFields, false);
        portletURL.setParameter("saveCallback", saveCallback, false);
        return portletURL.toString();
    }

    protected DDMStructure updateStructure(ActionRequest actionRequest) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long structureId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"structureId");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long classNameId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classNameId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        String xsd = ParamUtil.getString((PortletRequest)actionRequest, (String)"xsd");
        String storageType = ParamUtil.getString((PortletRequest)actionRequest, (String)"storageType");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMStructure.class.getName(), (PortletRequest)actionRequest);
        DDMStructure structure = null;
        if (cmd.equals("add")) {
            structure = DDMStructureServiceUtil.addStructure((long)groupId, (long)classNameId, null, (Map)nameMap, (Map)descriptionMap, (String)xsd, (String)storageType, (int)0, (ServiceContext)serviceContext);
        } else if (cmd.equals("update")) {
            structure = DDMStructureServiceUtil.updateStructure((long)structureId, (Map)nameMap, (Map)descriptionMap, (String)xsd, (ServiceContext)serviceContext);
        }
        return structure;
    }
}

