/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.util;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetServiceUtil;
import com.liferay.portlet.dynamicdatalists.util.BaseDDLExporter;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DDLXMLExporter
extends BaseDDLExporter {
    protected byte[] doExport(long recordSetId, int status, int start, int end, OrderByComparator orderByComparator) throws Exception {
        DDLRecordSet recordSet = DDLRecordSetServiceUtil.getRecordSet((long)recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Map fieldsMap = ddmStructure.getFieldsMap();
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        List records = DDLRecordLocalServiceUtil.getRecords((long)recordSetId, (int)status, (int)start, (int)end, (OrderByComparator)orderByComparator);
        for (DDLRecord record : records) {
            Element fieldsElement = rootElement.addElement("fields");
            Fields fields = record.getFields();
            for (Map fieldMap : fieldsMap.values()) {
                String label = (String)fieldMap.get("label");
                String name = (String)fieldMap.get("name");
                Field field = fields.get(name);
                Serializable value = field.getValue();
                this.addFieldElement(fieldsElement, label, value);
            }
        }
        String xml = document.asXML();
        return xml.getBytes();
    }

    protected void addFieldElement(Element fieldsElement, String label, Serializable value) {
        Element fieldElement = fieldsElement.addElement("field");
        Element labelElement = fieldElement.addElement("label");
        labelElement.addText(label);
        Element valueElement = fieldElement.addElement("value");
        valueElement.addText(String.valueOf(value));
    }
}

