/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.templateparser.Transformer;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.documentlibrary.DuplicateDirectoryException;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.util.DDL;
import com.liferay.portlet.dynamicdatalists.util.DDLTransformer;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.FieldConstants;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.util.portlet.PortletRequestUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLImpl
implements DDL {
    private Transformer _transformer = new DDLTransformer();

    public void addAllReservedEls(Element rootElement, Map<String, String> tokens, DDLRecordSet recordSet) {
        JournalUtil.addReservedEl(rootElement, tokens, "reserved_record_set_id", String.valueOf(recordSet.getRecordSetId()));
        JournalUtil.addReservedEl(rootElement, tokens, "reserved_record_set_name", recordSet.getName());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved_record_set_description", recordSet.getDescription());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved_ddm_structure_id", String.valueOf(recordSet.getDDMStructureId()));
    }

    public Fields getFields(UploadPortletRequest uploadPortletRequest, long ddmStructureId) throws PortalException, SystemException {
        return this.getFields(uploadPortletRequest, ddmStructureId, 0L);
    }

    public Fields getFields(UploadPortletRequest uploadPortletRequest, long ddmStructureId, long ddmTemplateId) throws PortalException, SystemException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        try {
            DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)ddmTemplateId);
            ddmStructure.setXsd(ddmTemplate.getScript());
        }
        catch (NoSuchTemplateException noSuchTemplateException) {}
        Set fieldNames = ddmStructure.getFieldNames();
        Fields fields = new Fields();
        for (String fieldName : fieldNames) {
            Field field = new Field();
            field.setName(fieldName);
            String fieldDataType = ddmStructure.getFieldDataType(fieldName);
            String fieldType = ddmStructure.getFieldType(fieldName);
            String fieldValue = uploadPortletRequest.getParameter(fieldName);
            if (fieldDataType.equals("file-upload")) continue;
            if (fieldType.equals("radio") || fieldType.equals("select")) {
                String[] fieldValues = ParamUtil.getParameterValues((HttpServletRequest)uploadPortletRequest, (String)fieldName);
                fieldValue = JSONFactoryUtil.serialize((Object)fieldValues);
            }
            if (fieldValue == null) continue;
            Serializable fieldValueSerializable = FieldConstants.getSerializable((String)fieldDataType, (String)GetterUtil.getString((String)fieldValue));
            field.setValue(fieldValueSerializable);
            fields.put(field);
        }
        return fields;
    }

    public String getRecordFileUploadPath(DDLRecord record) {
        return "ddl_records/" + record.getRecordId();
    }

    public JSONObject getRecordJSONObject(DDLRecord record) throws Exception {
        return this.getRecordJSONObject(record, false);
    }

    public JSONObject getRecordJSONObject(DDLRecord record, boolean latestRecordVersion) throws Exception {
        DDLRecordSet recordSet = record.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        for (String fieldName : ddmStructure.getFieldNames()) {
            jsonObject.put(fieldName, "");
        }
        jsonObject.put("displayIndex", record.getDisplayIndex());
        jsonObject.put("recordId", record.getRecordId());
        DDLRecordVersion recordVersion = record.getRecordVersion();
        if (latestRecordVersion) {
            recordVersion = record.getLatestRecordVersion();
        }
        Fields fields = StorageEngineUtil.getFields((long)recordVersion.getDDMStorageId());
        for (Field field : fields) {
            String fieldName = field.getName();
            String fieldType = field.getType();
            Serializable fieldValue = field.getValue();
            if (fieldValue instanceof Date) {
                jsonObject.put(fieldName, ((Date)fieldValue).getTime());
                continue;
            }
            if ((fieldType.equals("radio") || fieldType.equals("select")) && Validator.isNotNull((Object)fieldValue)) {
                fieldValue = JSONFactoryUtil.createJSONArray((String)String.valueOf(fieldValue));
                jsonObject.put(fieldName, (JSONArray)fieldValue);
                continue;
            }
            jsonObject.put(fieldName, String.valueOf(fieldValue));
        }
        return jsonObject;
    }

    public JSONArray getRecordSetJSONArray(DDLRecordSet recordSet) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Map fieldsMap = ddmStructure.getFieldsMap();
        for (Map fields : fieldsMap.values()) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            String dataType = (String)fields.get("dataType");
            jsonObject.put("dataType", dataType);
            boolean editable = GetterUtil.getBoolean((String)((String)fields.get("editable")), (boolean)true);
            jsonObject.put("editable", editable);
            String label = (String)fields.get("label");
            jsonObject.put("label", label);
            String name = (String)fields.get("name");
            jsonObject.put("name", name);
            boolean required = GetterUtil.getBoolean((String)((String)fields.get("required")));
            jsonObject.put("required", required);
            boolean sortable = GetterUtil.getBoolean((String)((String)fields.get("sortable")), (boolean)true);
            jsonObject.put("sortable", sortable);
            String type = (String)fields.get("type");
            jsonObject.put("type", type);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public JSONArray getRecordsJSONArray(DDLRecordSet recordSet) throws Exception {
        return this.getRecordsJSONArray(recordSet.getRecords(), false);
    }

    public JSONArray getRecordsJSONArray(List<DDLRecord> records) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (DDLRecord record : records) {
            JSONObject jsonObject = this.getRecordJSONObject(record);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public JSONArray getRecordsJSONArray(List<DDLRecord> records, boolean latestRecordVersion) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (DDLRecord record : records) {
            JSONObject jsonObject = this.getRecordJSONObject(record, latestRecordVersion);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public String getTemplateContent(long ddmTemplateId, DDLRecordSet recordSet, ThemeDisplay themeDisplay, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        String viewMode = ParamUtil.getString((PortletRequest)renderRequest, (String)"viewMode");
        String languageId = LanguageUtil.getLanguageId((PortletRequest)renderRequest);
        String xmlRequest = PortletRequestUtil.toXML((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        if (Validator.isNull((String)xmlRequest)) {
            xmlRequest = "<request />";
        }
        Map<String, String> tokens = JournalUtil.getTokens(recordSet.getGroupId(), themeDisplay, xmlRequest);
        String xml = "";
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        Document requestDocument = SAXReaderUtil.read((String)xmlRequest);
        rootElement.add(requestDocument.getRootElement().createCopy());
        this.addAllReservedEls(rootElement, tokens, recordSet);
        xml = DDMXMLUtil.formatXML((Document)document);
        DDMTemplate template = DDMTemplateLocalServiceUtil.getTemplate((long)ddmTemplateId);
        return this._transformer.transform(themeDisplay, tokens, viewMode, languageId, xml, template.getScript(), template.getLanguage());
    }

    public void sendRecordFileUpload(HttpServletRequest request, HttpServletResponse response, DDLRecord record, String fieldName) throws Exception {
        Serializable fieldValue = record.getFieldValue(fieldName);
        JSONObject fileJSONObject = JSONFactoryUtil.createJSONObject((String)String.valueOf(fieldValue));
        String fileName = fileJSONObject.getString("name");
        String filePath = fileJSONObject.getString("path");
        InputStream is = DLStoreUtil.getFileAsStream((long)record.getCompanyId(), (long)0L, (String)filePath);
        long contentLength = DLStoreUtil.getFileSize((long)record.getCompanyId(), (long)0L, (String)filePath);
        String contentType = MimeTypesUtil.getContentType((String)fileName);
        ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)is, (long)contentLength, (String)contentType);
    }

    public void sendRecordFileUpload(HttpServletRequest request, HttpServletResponse response, long recordId, String fieldName) throws Exception {
        DDLRecord record = DDLRecordServiceUtil.getRecord((long)recordId);
        this.sendRecordFileUpload(request, response, record, fieldName);
    }

    public String storeRecordFieldFile(DDLRecord record, String fieldName, InputStream inputStream) throws Exception {
        DDLRecordVersion recordVersion = record.getLatestRecordVersion();
        String dirName = String.valueOf(this.getRecordFileUploadPath(record)) + "/" + recordVersion.getVersion();
        try {
            DLStoreUtil.addDirectory((long)record.getCompanyId(), (long)0L, (String)dirName);
        }
        catch (DuplicateDirectoryException duplicateDirectoryException) {}
        String fileName = String.valueOf(dirName) + "/" + fieldName;
        try {
            DLStoreUtil.addFile((long)record.getCompanyId(), (long)0L, (String)fileName, (InputStream)inputStream);
        }
        catch (DuplicateFileException duplicateFileException) {}
        return fileName;
    }

    public DDLRecord updateRecord(UploadPortletRequest uploadPortletRequest, long recordId, long recordSetId, boolean mergeFields) throws Exception {
        return this.updateRecord(uploadPortletRequest, recordId, recordSetId, mergeFields, true);
    }

    public DDLRecord updateRecord(UploadPortletRequest uploadPortletRequest, long recordId, long recordSetId, boolean mergeFields, boolean checkPermission) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("THEME_DISPLAY");
        boolean majorVersion = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"majorVersion");
        DDLRecord record = DDLRecordLocalServiceUtil.fetchRecord((long)recordId);
        DDLRecordSet recordSet = DDLRecordSetLocalServiceUtil.getDDLRecordSet((long)recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = this.getFields(uploadPortletRequest, ddmStructure.getStructureId());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)uploadPortletRequest);
        record = record != null ? (checkPermission ? DDLRecordServiceUtil.updateRecord((long)recordId, (boolean)majorVersion, (int)0, (Fields)fields, (boolean)mergeFields, (ServiceContext)serviceContext) : DDLRecordLocalServiceUtil.updateRecord((long)themeDisplay.getUserId(), (long)recordId, (boolean)majorVersion, (int)0, (Fields)fields, (boolean)mergeFields, (ServiceContext)serviceContext)) : (checkPermission ? DDLRecordServiceUtil.addRecord((long)themeDisplay.getScopeGroupId(), (long)recordSetId, (int)0, (Fields)fields, (ServiceContext)serviceContext) : DDLRecordLocalServiceUtil.addRecord((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId(), (long)recordSetId, (int)0, (Fields)fields, (ServiceContext)serviceContext));
        this.uploadRecordFieldFiles(record, uploadPortletRequest, serviceContext);
        return record;
    }

    public void uploadRecordFieldFile(DDLRecord record, String fieldName, UploadPortletRequest uploadPortletRequest, ServiceContext serviceContext) throws Exception {
        Fields fields = new Fields();
        String fileName = uploadPortletRequest.getFileName(fieldName);
        Field field = record.getField(fieldName);
        String fieldValue = "";
        if (field != null) {
            fieldValue = String.valueOf(field.getValue());
        }
        InputStream inputStream = null;
        try {
            inputStream = uploadPortletRequest.getFileAsStream(fieldName, true);
            if (inputStream != null) {
                String filePath = this.storeRecordFieldFile(record, fieldName, inputStream);
                JSONObject recordFileJSONObject = JSONFactoryUtil.createJSONObject();
                recordFileJSONObject.put("name", fileName);
                recordFileJSONObject.put("path", filePath);
                recordFileJSONObject.put("recordId", record.getRecordId());
                fieldValue = recordFileJSONObject.toString();
            }
            DDLRecordSet recordSet = record.getRecordSet();
            DDMStructure ddmStructure = recordSet.getDDMStructure();
            field = new Field(ddmStructure.getStructureId(), fieldName, (Serializable)((Object)fieldValue));
            fields.put(field);
            DDLRecordVersion recordVersion = record.getLatestRecordVersion();
            StorageEngineUtil.update((long)recordVersion.getDDMStorageId(), (Fields)fields, (boolean)true, (ServiceContext)serviceContext);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(inputStream);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)inputStream);
    }

    public void uploadRecordFieldFiles(DDLRecord record, UploadPortletRequest uploadPortletRequest, ServiceContext serviceContext) throws Exception {
        DDLRecordSet recordSet = record.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        for (String fieldName : ddmStructure.getFieldNames()) {
            String fieldDataType = ddmStructure.getFieldDataType(fieldName);
            if (!fieldDataType.equals("file-upload")) continue;
            this.uploadRecordFieldFile(record, fieldName, uploadPortletRequest, serviceContext);
        }
    }
}

