/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.util;

import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetServiceUtil;
import com.liferay.portlet.dynamicdatalists.util.BaseDDLExporter;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DDLCSVExporter
extends BaseDDLExporter {
    protected byte[] doExport(long recordSetId, int status, int start, int end, OrderByComparator orderByComparator) throws Exception {
        DDLRecordSet recordSet = DDLRecordSetServiceUtil.getRecordSet((long)recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Map fieldsMap = ddmStructure.getFieldsMap();
        StringBundler sb = new StringBundler();
        for (Map fieldMap : fieldsMap.values()) {
            String label = (String)fieldMap.get("label");
            sb.append(label);
            sb.append(',');
        }
        sb.setIndex(sb.index() - 1);
        sb.append("\n");
        List records = DDLRecordLocalServiceUtil.getRecords((long)recordSetId, (int)status, (int)start, (int)end, (OrderByComparator)orderByComparator);
        for (DDLRecord record : records) {
            Fields fields = record.getFields();
            for (Map fieldMap : fieldsMap.values()) {
                String name = (String)fieldMap.get("name");
                Field field = fields.get(name);
                Serializable value = field.getValue();
                sb.append(CSVUtil.encode((Object)value));
                sb.append(',');
            }
            sb.setIndex(sb.index() - 1);
            sb.append("\n");
        }
        String csv = sb.toString();
        return csv.getBytes();
    }
}

