/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.asset;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.permission.DDLRecordSetPermission;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class DDLRecordAssetRenderer
extends BaseAssetRenderer {
    private static Log _log = LogFactoryUtil.getLog(DDLRecordAssetRenderer.class);
    private DDLRecord _record;
    private DDLRecordSet _recordSet;
    private DDLRecordVersion _recordVersion;

    public DDLRecordAssetRenderer(DDLRecord record, DDLRecordVersion recordVersion) {
        block2: {
            this._record = record;
            this._recordVersion = recordVersion;
            try {
                this._recordSet = record.getRecordSet();
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    public long getClassPK() {
        return this._record.getRecordId();
    }

    public long getGroupId() {
        return this._record.getGroupId();
    }

    public String getSummary(Locale locale) {
        return "";
    }

    public String getTitle(Locale locale) {
        String name = this._recordSet.getName(locale);
        return LanguageUtil.format((Locale)locale, (String)"new-record-for-list-x", (Object)name);
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "167", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/dynamic_data_lists/edit_record");
        portletURL.setParameter("recordId", String.valueOf(this._record.getRecordId()));
        return portletURL;
    }

    public long getUserId() {
        return this._record.getUserId();
    }

    public String getUuid() {
        return this._record.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        return DDLRecordSetPermission.contains(permissionChecker, this._recordSet, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return DDLRecordSetPermission.contains(permissionChecker, this._recordSet, "VIEW");
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("DYNAMIC_DATA_LISTS_RECORD", (Object)this._record);
            renderRequest.setAttribute("DYNAMIC_DATA_LISTS_RECORD_VERSION", (Object)this._recordVersion);
            String path = "/html/portlet/dynamic_data_lists/asset/full_content.jsp";
            return path;
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/history.png";
    }
}

