/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.webdav;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.InvalidLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.Status;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.Lock;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.webdav.LockException;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.webdav.DLFileEntryResourceImpl;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    private static Log _log = LogFactoryUtil.getLog(DLWebDAVStorageImpl.class);

    public int copyCollectionResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite, long depth) throws WebDAVException {
        String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
        long companyId = webDavRequest.getCompanyId();
        long parentFolderId = 0L;
        try {
            parentFolderId = this.getParentFolderId(companyId, destinationArray);
        }
        catch (NoSuchFolderException noSuchFolderException) {
            return 409;
        }
        try {
            Folder folder = (Folder)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((long)companyId, (String)destination);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = folder.getDescription();
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(this.isAddGroupPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name, webDavRequest.getLockUuid())) {
                status = 204;
            }
            if (depth == 0L) {
                DLAppServiceUtil.addFolder((long)groupId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            } else {
                DLAppServiceUtil.copyFolder((long)groupId, (long)folder.getFolderId(), (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            }
            return status;
        }
        catch (DuplicateFolderNameException duplicateFolderNameException) {
            return 412;
        }
        catch (PrincipalException principalException) {
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int copySimpleResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        int n;
        File file = null;
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            long companyId = webDavRequest.getCompanyId();
            long parentFolderId = 0L;
            try {
                parentFolderId = this.getParentFolderId(companyId, destinationArray);
            }
            catch (NoSuchFolderException noSuchFolderException) {
                FileUtil.delete(file);
                return 409;
            }
            FileEntry fileEntry = (FileEntry)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((long)companyId, (String)destination);
            String mimeType = fileEntry.getMimeType();
            String title = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = fileEntry.getDescription();
            String changeLog = "";
            InputStream is = fileEntry.getContentStream();
            file = FileUtil.createTempFile((InputStream)is);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(this.isAddGroupPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, title, webDavRequest.getLockUuid())) {
                status = 204;
            }
            DLAppServiceUtil.addFileEntry((long)groupId, (long)parentFolderId, (String)title, (String)mimeType, (String)title, (String)description, (String)changeLog, (File)file, (ServiceContext)serviceContext);
            n = status;
            FileUtil.delete((File)file);
        }
        catch (DuplicateFileException duplicateFileException) {
            return 412;
        }
        catch (DuplicateFolderNameException duplicateFolderNameException) {
            return 412;
        }
        catch (LockException lockException) {
            return 423;
        }
        catch (PrincipalException principalException) {
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
        finally {
            FileUtil.delete(file);
        }
        return n;
    }

    public int deleteResource(WebDAVRequest webDavRequest) throws WebDAVException {
        block8: {
            FileEntry fileEntry;
            block9: {
                Resource resource;
                block7: {
                    resource = this.getResource(webDavRequest);
                    if (resource != null) break block7;
                    if (webDavRequest.isAppleDoubleRequest()) {
                        return 204;
                    }
                    return 404;
                }
                Object model = resource.getModel();
                if (model instanceof Folder) {
                    Folder folder = (Folder)model;
                    DLAppServiceUtil.deleteFolder((long)folder.getFolderId());
                    break block8;
                }
                fileEntry = (FileEntry)model;
                if (this.hasLock(fileEntry, webDavRequest.getLockUuid()) || fileEntry.getLock() == null) break block9;
                return 423;
            }
            try {
                DLAppServiceUtil.deleteFileEntry((long)fileEntry.getFileEntryId());
            }
            catch (PrincipalException principalException) {
                return 403;
            }
            catch (Exception e) {
                throw new WebDAVException((Throwable)e);
            }
        }
        return 204;
    }

    public Resource getResource(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            String[] pathArray = webDavRequest.getPathArray();
            long companyId = webDavRequest.getCompanyId();
            long parentFolderId = this.getParentFolderId(companyId, pathArray);
            String name = WebDAVUtil.getResourceName((String[])pathArray);
            if (Validator.isNull((String)name)) {
                String path = String.valueOf(this.getRootPath()) + webDavRequest.getPath();
                return new BaseResourceImpl(path, "", this.getToken());
            }
            try {
                Folder folder = DLAppServiceUtil.getFolder((long)webDavRequest.getGroupId(), (long)parentFolderId, (String)name);
                if (folder.getParentFolderId() != parentFolderId || webDavRequest.getGroupId() != folder.getRepositoryId()) {
                    throw new NoSuchFolderException();
                }
                return this.toResource(webDavRequest, folder, false);
            }
            catch (NoSuchFolderException noSuchFolderException) {
                try {
                    String titleWithExtension = name;
                    FileEntry fileEntry = DLAppServiceUtil.getFileEntry((long)webDavRequest.getGroupId(), (long)parentFolderId, (String)titleWithExtension);
                    return this.toResource(webDavRequest, fileEntry, false);
                }
                catch (NoSuchFileEntryException noSuchFileEntryException) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public List<Resource> getResources(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            long folderId = this.getFolderId(webDavRequest.getCompanyId(), webDavRequest.getPathArray());
            List<Resource> folders = this.getFolders(webDavRequest, folderId);
            List<Resource> fileEntries = this.getFileEntries(webDavRequest, folderId);
            ArrayList<Resource> resources = new ArrayList<Resource>(folders.size() + fileEntries.size());
            resources.addAll(folders);
            resources.addAll(fileEntries);
            return resources;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public boolean isSupportsClassTwo() {
        return true;
    }

    public Status lockResource(WebDAVRequest webDavRequest, String owner, long timeout) throws WebDAVException {
        Resource resource = this.getResource(webDavRequest);
        Lock lock = null;
        int status = 200;
        try {
            if (resource == null) {
                status = 201;
                HttpServletRequest request = webDavRequest.getHttpServletRequest();
                String[] pathArray = webDavRequest.getPathArray();
                long companyId = webDavRequest.getCompanyId();
                long groupId = webDavRequest.getGroupId();
                long parentFolderId = this.getParentFolderId(companyId, pathArray);
                String title = WebDAVUtil.getResourceName((String[])pathArray);
                String contentType = GetterUtil.get((String)request.getHeader("Content-Type"), (String)"application/octet-stream");
                if (contentType.equals("application/octet-stream")) {
                    contentType = MimeTypesUtil.getContentType((InputStream)request.getInputStream(), (String)title);
                }
                String description = "";
                String changeLog = "";
                File file = FileUtil.createTempFile((String)FileUtil.getExtension((String)title));
                file.createNewFile();
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(this.isAddGroupPermissions(groupId));
                serviceContext.setAddGuestPermissions(true);
                FileEntry fileEntry = DLAppServiceUtil.addFileEntry((long)groupId, (long)parentFolderId, (String)title, (String)contentType, (String)title, (String)description, (String)changeLog, (File)file, (ServiceContext)serviceContext);
                resource = this.toResource(webDavRequest, fileEntry, false);
            }
            if (resource instanceof DLFileEntryResourceImpl) {
                FileEntry fileEntry = (FileEntry)resource.getModel();
                lock = DLAppServiceUtil.lockFileEntry((long)fileEntry.getFileEntryId(), (String)owner, (long)timeout);
            } else {
                boolean inheritable = false;
                long depth = WebDAVUtil.getDepth((HttpServletRequest)webDavRequest.getHttpServletRequest());
                if (depth != 0L) {
                    inheritable = true;
                }
                Folder folder = (Folder)resource.getModel();
                lock = DLAppServiceUtil.lockFolder((long)folder.getRepositoryId(), (long)folder.getFolderId(), (String)owner, (boolean)inheritable, (long)timeout);
            }
        }
        catch (Exception e) {
            if (!(e instanceof DuplicateLockException)) {
                throw new WebDAVException((Throwable)e);
            }
            status = 423;
        }
        return new Status(lock, status);
    }

    public Status makeCollection(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            HttpServletRequest request = webDavRequest.getHttpServletRequest();
            if (request.getContentLength() > 0) {
                return new Status(415);
            }
            Object[] pathArray = webDavRequest.getPathArray();
            long companyId = webDavRequest.getCompanyId();
            long groupId = webDavRequest.getGroupId();
            long parentFolderId = this.getParentFolderId(companyId, (String[])pathArray);
            String name = WebDAVUtil.getResourceName((String[])pathArray);
            String description = "";
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(this.isAddGroupPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            DLAppServiceUtil.addFolder((long)groupId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            String location = StringUtil.merge((Object[])pathArray, (String)"/");
            return new Status((Object)location, 201);
        }
        catch (DuplicateFolderNameException duplicateFolderNameException) {
            return new Status(405);
        }
        catch (DuplicateFileException duplicateFileException) {
            return new Status(405);
        }
        catch (NoSuchFolderException noSuchFolderException) {
            return new Status(409);
        }
        catch (PrincipalException principalException) {
            return new Status(403);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int moveCollectionResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            Folder folder = (Folder)resource.getModel();
            long companyId = webDavRequest.getCompanyId();
            long groupId = WebDAVUtil.getGroupId((long)companyId, (String[])destinationArray);
            long folderId = folder.getFolderId();
            long parentFolderId = this.getParentFolderId(companyId, destinationArray);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = folder.getDescription();
            ServiceContext serviceContext = new ServiceContext();
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name, webDavRequest.getLockUuid())) {
                status = 204;
            }
            if (parentFolderId != folder.getParentFolderId()) {
                DLAppServiceUtil.moveFolder((long)folderId, (long)parentFolderId, (ServiceContext)serviceContext);
            }
            if (!name.equals(folder.getName())) {
                DLAppServiceUtil.updateFolder((long)folderId, (String)name, (String)description, (ServiceContext)serviceContext);
            }
            return status;
        }
        catch (PrincipalException principalException) {
            return 403;
        }
        catch (DuplicateFolderNameException duplicateFolderNameException) {
            return 412;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public int moveSimpleResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int putResource(WebDAVRequest webDavRequest) throws WebDAVException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Lock refreshResourceLock(WebDAVRequest webDavRequest, String uuid, long timeout) throws WebDAVException {
        Resource resource = this.getResource(webDavRequest);
        Lock lock = null;
        try {
            lock = resource instanceof DLFileEntryResourceImpl ? DLAppServiceUtil.refreshFileEntryLock((String)uuid, (long)timeout) : DLAppServiceUtil.refreshFolderLock((String)uuid, (long)timeout);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
        return lock;
    }

    public boolean unlockResource(WebDAVRequest webDavRequest, String token) throws WebDAVException {
        Resource resource = this.getResource(webDavRequest);
        try {
            if (resource instanceof DLFileEntryResourceImpl) {
                FileEntry fileEntry = (FileEntry)resource.getModel();
                DLAppServiceUtil.unlockFileEntry((long)fileEntry.getFileEntryId(), (String)token);
                if (webDavRequest.isAppleDoubleRequest()) {
                    DLAppServiceUtil.deleteFileEntry((long)fileEntry.getFileEntryId());
                }
            } else {
                Folder folder = (Folder)resource.getModel();
                DLAppServiceUtil.unlockFolder((long)folder.getRepositoryId(), (long)folder.getParentFolderId(), (String)folder.getName(), (String)token);
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof InvalidLockException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e.getMessage());
                }
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to unlock file entry", (Throwable)e);
            }
            return false;
        }
    }

    protected boolean deleteResource(long groupId, long parentFolderId, String name, String lockUuid) throws Exception {
        try {
            Folder folder = DLAppServiceUtil.getFolder((long)groupId, (long)parentFolderId, (String)name);
            DLAppServiceUtil.deleteFolder((long)folder.getFolderId());
            return true;
        }
        catch (NoSuchFolderException noSuchFolderException) {
            try {
                FileEntry fileEntry = DLAppServiceUtil.getFileEntry((long)groupId, (long)parentFolderId, (String)name);
                if (!this.hasLock(fileEntry, lockUuid) && fileEntry.getLock() != null) {
                    throw new LockException();
                }
                DLAppServiceUtil.deleteFileEntryByTitle((long)groupId, (long)parentFolderId, (String)name);
                return true;
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
                return false;
            }
        }
    }

    protected List<Resource> getFileEntries(WebDAVRequest webDavRequest, long parentFolderId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List fileEntries = DLAppServiceUtil.getFileEntries((long)webDavRequest.getGroupId(), (long)parentFolderId);
        for (FileEntry fileEntry : fileEntries) {
            Resource resource = this.toResource(webDavRequest, fileEntry, true);
            resources.add(resource);
        }
        return resources;
    }

    protected long getFolderId(long companyId, String[] pathArray) throws Exception {
        return this.getFolderId(companyId, pathArray, false);
    }

    protected long getFolderId(long companyId, String[] pathArray, boolean parent) throws Exception {
        long folderId = 0L;
        if (pathArray.length <= 1) {
            return folderId;
        }
        long groupId = WebDAVUtil.getGroupId((long)companyId, (String[])pathArray);
        int x = pathArray.length;
        if (parent) {
            --x;
        }
        int i = 2;
        while (i < x) {
            String name = pathArray[i];
            Folder folder = DLAppServiceUtil.getFolder((long)groupId, (long)folderId, (String)name);
            if (groupId == folder.getRepositoryId()) {
                folderId = folder.getFolderId();
            }
            ++i;
        }
        return folderId;
    }

    protected List<Resource> getFolders(WebDAVRequest webDavRequest, long parentFolderId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        long groupId = webDavRequest.getGroupId();
        List folders = DLAppServiceUtil.getFolders((long)groupId, (long)parentFolderId, (boolean)false);
        for (Folder folder : folders) {
            Resource resource = this.toResource(webDavRequest, folder, true);
            resources.add(resource);
        }
        return resources;
    }

    protected long getParentFolderId(long companyId, String[] pathArray) throws Exception {
        return this.getFolderId(companyId, pathArray, true);
    }

    protected boolean hasLock(FileEntry fileEntry, String lockUuid) throws Exception {
        if (Validator.isNull((String)lockUuid)) {
            return fileEntry.hasLock();
        }
        try {
            return DLAppServiceUtil.verifyFileEntryLock((long)fileEntry.getRepositoryId(), (long)fileEntry.getFileEntryId(), (String)lockUuid);
        }
        catch (NoSuchLockException noSuchLockException) {
            return false;
        }
    }

    protected Resource toResource(WebDAVRequest webDavRequest, FileEntry fileEntry, boolean appendPath) {
        String parentPath = String.valueOf(this.getRootPath()) + webDavRequest.getPath();
        String name = "";
        if (appendPath) {
            name = fileEntry.getTitle();
        }
        return new DLFileEntryResourceImpl(webDavRequest, fileEntry, parentPath, name);
    }

    protected Resource toResource(WebDAVRequest webDavRequest, Folder folder, boolean appendPath) {
        String parentPath = String.valueOf(this.getRootPath()) + webDavRequest.getPath();
        String name = "";
        if (appendPath) {
            name = folder.getName();
        }
        BaseResourceImpl resource = new BaseResourceImpl(parentPath, name, folder.getName(), folder.getCreateDate(), folder.getModifiedDate());
        resource.setModel((Object)folder);
        resource.setClassName(Folder.class.getName());
        resource.setPrimaryKey(folder.getPrimaryKey());
        return resource;
    }
}

