/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DefaultPreviewableProcessor;
import com.liferay.portlet.documentlibrary.util.LiferayConverter;
import com.liferay.portlet.documentlibrary.util.LiferayVideoConverter;
import com.liferay.portlet.documentlibrary.util.LiferayVideoThumbnailConverter;
import com.liferay.portlet.documentlibrary.util.VideoProcessor;
import com.liferay.util.log4j.Log4JUtil;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoProcessorImpl
extends DefaultPreviewableProcessor
implements VideoProcessor {
    private static final String[] _PREVIEW_TYPES = PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_CONTAINERS;
    private static Log _log = LogFactoryUtil.getLog(VideoProcessorImpl.class);
    private static VideoProcessorImpl _instance = new VideoProcessorImpl();
    private Set<String> _videoMimeTypes = SetUtil.fromArray((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_MIME_TYPES);
    private List<Long> _fileVersionIds = new Vector<Long>();

    static {
        InstancePool.put((String)VideoProcessorImpl.class.getName(), (Object)((Object)_instance));
    }

    public static VideoProcessorImpl getInstance() {
        return _instance;
    }

    public void generateVideo(FileVersion fileVersion) throws Exception {
        _instance._generateVideo(fileVersion);
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion) throws Exception {
        return _instance.doGetPreviewAsStream(fileVersion);
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, String type) throws Exception {
        return _instance.doGetPreviewAsStream(fileVersion, type);
    }

    public long getPreviewFileSize(FileVersion fileVersion) throws Exception {
        return _instance.doGetPreviewFileSize(fileVersion);
    }

    public long getPreviewFileSize(FileVersion fileVersion, String type) throws Exception {
        return _instance.doGetPreviewFileSize(fileVersion, type);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int thumbnailIndex) throws Exception {
        return _instance.doGetThumbnailAsStream(fileVersion, thumbnailIndex);
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int thumbnailIndex) throws Exception {
        return _instance.doGetThumbnailFileSize(fileVersion, thumbnailIndex);
    }

    public Set<String> getVideoMimeTypes() {
        return VideoProcessorImpl._instance._videoMimeTypes;
    }

    public boolean hasVideo(FileVersion fileVersion) {
        boolean hasVideo = false;
        try {
            hasVideo = _instance._hasVideo(fileVersion);
            if (!hasVideo && _instance.isSupported(fileVersion)) {
                _instance._queueGeneration(fileVersion);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return hasVideo;
    }

    public boolean isVideoSupported(FileVersion fileVersion) {
        return _instance.isSupported(fileVersion);
    }

    public boolean isVideoSupported(String mimeType) {
        return _instance.isSupported(mimeType);
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        try {
            if (PrefsPropsUtil.getBoolean("xuggler.enabled", PropsValues.XUGGLER_ENABLED)) {
                return this._videoMimeTypes.contains(mimeType);
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public void trigger(FileVersion fileVersion) {
        _instance._queueGeneration(fileVersion);
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return _PREVIEW_TYPES[0];
    }

    protected String[] getPreviewTypes() {
        return _PREVIEW_TYPES;
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return "jpg";
    }

    protected void storeThumbnailImages(FileVersion fileVersion, File file) throws Exception {
        this.addFileToStore(fileVersion.getCompanyId(), "document_thumbnail/", this.getThumbnailFilePath(fileVersion, THUMBNAIL_INDEX_DEFAULT), file);
        if (this.isCustomThumbnailsEnabled(1) || this.isCustomThumbnailsEnabled(2)) {
            ImageBag imageBag = ImageToolUtil.read((File)file);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            this.storeThumbnailmage(fileVersion, renderedImage, THUMBNAIL_INDEX_CUSTOM_1);
            this.storeThumbnailmage(fileVersion, renderedImage, THUMBNAIL_INDEX_CUSTOM_2);
        }
    }

    private VideoProcessorImpl() {
        boolean valid = true;
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            valid = false;
        } else {
            String[] stringArray = _PREVIEW_TYPES;
            int n = _PREVIEW_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String previewType = stringArray[n2];
                if (!previewType.equals("mp4") && !previewType.equals("ogv")) {
                    valid = false;
                    break;
                }
                ++n2;
            }
        }
        if (!valid && _log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("Liferay is incorrectly configured to generate video ");
            sb.append("previews using video containers other than MP4 or ");
            sb.append("OGV. Please change the property ");
            sb.append("dl.file.entry.preview.video.containers");
            sb.append(" in portal-ext.properties.");
            _log.warn((Object)sb.toString());
        }
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
        FileUtil.mkdirs((String)THUMBNAIL_TMP_PATH);
    }

    private void _generateThumbnailXuggler(FileVersion fileVersion, File file, int height, int width) throws Exception {
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
        File thumbnailTempFile = this.getThumbnailTempFile(tempFileId);
        try {
            try {
                try {
                    if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED) {
                        LiferayVideoThumbnailProcessCallable processCallable = new LiferayVideoThumbnailProcessCallable(ServerDetector.getServerId(), PropsUtil.get("liferay.home"), Log4JUtil.getCustomLogSettings(), file.getCanonicalPath(), thumbnailTempFile, "jpg", height, width, PropsValues.DL_FILE_ENTRY_THUMBNAIL_VIDEO_FRAME_PERCENTAGE);
                        ProcessExecutor.execute((ProcessCallable)processCallable, (String)ClassPathUtil.getPortalClassPath());
                    } else {
                        LiferayVideoThumbnailConverter liferayConverter = new LiferayVideoThumbnailConverter(file.getCanonicalPath(), thumbnailTempFile, "jpg", height, width, PropsValues.DL_FILE_ENTRY_THUMBNAIL_VIDEO_FRAME_PERCENTAGE);
                        ((LiferayConverter)liferayConverter).convert();
                    }
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
                this.storeThumbnailImages(fileVersion, thumbnailTempFile);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Xuggler generated a thumbnail for " + fileVersion.getTitle() + " in " + stopWatch));
                }
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        finally {
            FileUtil.delete((File)thumbnailTempFile);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void _generateVideo(FileVersion fileVersion) throws Exception {
        block23: {
            block22: {
                block21: {
                    tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
                    videoTempFile = this._getVideoTempFile(tempFileId, fileVersion.getExtension());
                    previewTempFiles = new File[VideoProcessorImpl._PREVIEW_TYPES.length];
                    i = 0;
                    while (i < VideoProcessorImpl._PREVIEW_TYPES.length) {
                        previewTempFiles[i] = this.getPreviewTempFile(tempFileId, VideoProcessorImpl._PREVIEW_TYPES[i]);
                        ++i;
                    }
                    if (PrefsPropsUtil.getBoolean("xuggler.enabled", PropsValues.XUGGLER_ENABLED) && !this._hasVideo(fileVersion)) break block21;
                    this._fileVersionIds.remove(fileVersion.getFileVersionId());
                    i = 0;
                    while (i < previewTempFiles.length) {
                        FileUtil.delete((File)previewTempFiles[i]);
                        ++i;
                    }
                    FileUtil.delete((File)videoTempFile);
                    return;
                }
                try {
                    try {
                        file = null;
                        if (this._isGeneratePreview(fileVersion) || this._isGenerateThumbnail(fileVersion)) {
                            if (fileVersion instanceof LiferayFileVersion) {
                                try {
                                    liferayFileVersion = (LiferayFileVersion)fileVersion;
                                    file = liferayFileVersion.getFile(false);
                                }
                                catch (UnsupportedOperationException v0) {}
                            }
                            if (file == null) {
                                inputStream = fileVersion.getContentStream(false);
                                FileUtil.write((File)videoTempFile, (InputStream)inputStream);
                                file = videoTempFile;
                            }
                        }
                        if (this._isGeneratePreview(fileVersion)) {
                            try {
                                this._generateVideoXuggler(fileVersion, file, previewTempFiles, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_HEIGHT, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_WIDTH);
                            }
                            catch (Exception e) {
                                VideoProcessorImpl._log.error((Object)e, (Throwable)e);
                            }
                        }
                        if (this._isGenerateThumbnail(fileVersion)) {
                            try {
                                this._generateThumbnailXuggler(fileVersion, file, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_HEIGHT, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_WIDTH);
                            }
                            catch (Exception e) {
                                VideoProcessorImpl._log.error((Object)e, (Throwable)e);
                            }
                        }
                        break block22;
                    }
                    catch (NoSuchFileEntryException v1) {
                        this._fileVersionIds.remove(fileVersion.getFileVersionId());
                        i = 0;
                        ** while (i < previewTempFiles.length)
                    }
                }
                catch (Throwable var7_14) {
                    this._fileVersionIds.remove(fileVersion.getFileVersionId());
                    i = 0;
                    ** while (i < previewTempFiles.length)
                }
lbl-1000:
                // 1 sources

                {
                    FileUtil.delete((File)previewTempFiles[i]);
                    ++i;
                    continue;
                }
lbl59:
                // 1 sources

                FileUtil.delete((File)videoTempFile);
                break block23;
lbl-1000:
                // 1 sources

                {
                    FileUtil.delete((File)previewTempFiles[i]);
                    ++i;
                    continue;
                }
lbl71:
                // 1 sources

                FileUtil.delete((File)videoTempFile);
                throw var7_14;
            }
            this._fileVersionIds.remove(fileVersion.getFileVersionId());
            i = 0;
            while (i < previewTempFiles.length) {
                FileUtil.delete((File)previewTempFiles[i]);
                ++i;
            }
            FileUtil.delete((File)videoTempFile);
        }
    }

    private void _generateVideoXuggler(FileVersion fileVersion, File srcFile, File destFile, String containerType) throws Exception {
        if (!this._isGeneratePreview(fileVersion, containerType)) {
            return;
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED) {
            LiferayVideoProcessCallable processCallable = new LiferayVideoProcessCallable(ServerDetector.getServerId(), PropsUtil.get("liferay.home"), Log4JUtil.getCustomLogSettings(), srcFile.getCanonicalPath(), destFile.getCanonicalPath(), FileUtil.createTempFileName(), PropsUtil.getProperties("dl.file.entry.preview.video.", false), PropsUtil.getProperties("xuggler.ffpreset.", true));
            ProcessExecutor.execute((ProcessCallable)processCallable, (String)ClassPathUtil.getPortalClassPath());
        } else {
            LiferayVideoConverter liferayConverter = new LiferayVideoConverter(srcFile.getCanonicalPath(), destFile.getCanonicalPath(), FileUtil.createTempFileName(), PropsUtil.getProperties("dl.file.entry.preview.video.", false), PropsUtil.getProperties("xuggler.ffpreset.", true));
            ((LiferayConverter)liferayConverter).convert();
        }
        this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, containerType), destFile);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Xuggler generated a " + containerType + " preview video for " + fileVersion.getTitle() + " in " + stopWatch));
        }
    }

    private void _generateVideoXuggler(FileVersion fileVersion, File srcFile, File[] destFiles, int height, int width) {
        try {
            int i = 0;
            while (i < destFiles.length) {
                this._generateVideoXuggler(fileVersion, srcFile, destFiles[i], _PREVIEW_TYPES[i]);
                ++i;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private File _getVideoTempFile(String tempFileId, String targetExtension) {
        String videoTempFilePath = this._getVideoTempFilePath(tempFileId, targetExtension);
        return new File(videoTempFilePath);
    }

    private String _getVideoTempFilePath(String tempFileId, String targetExtension) {
        StringBundler sb = new StringBundler(5);
        sb.append(PREVIEW_TMP_PATH);
        sb.append(tempFileId);
        int i = 0;
        while (i < _PREVIEW_TYPES.length) {
            if (_PREVIEW_TYPES[i].equals(targetExtension)) {
                sb.append("_tmp");
                break;
            }
            ++i;
        }
        sb.append(".");
        sb.append(targetExtension);
        return sb.toString();
    }

    private boolean _hasVideo(FileVersion fileVersion) throws Exception {
        block9: {
            if (!this.isSupported(fileVersion)) {
                return false;
            }
            int previewsCount = 0;
            int i = 0;
            while (i < _PREVIEW_TYPES.length) {
                String previewFilePath = this.getPreviewFilePath(fileVersion, _PREVIEW_TYPES[i]);
                if (DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)previewFilePath)) {
                    ++previewsCount;
                }
                ++i;
            }
            if (previewsCount != _PREVIEW_TYPES.length) {
                return false;
            }
            if (PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED && !this.hasThumbnail(fileVersion, THUMBNAIL_INDEX_DEFAULT)) {
                return false;
            }
            if (!this.isCustomThumbnailsEnabled(1) || this.hasThumbnail(fileVersion, THUMBNAIL_INDEX_CUSTOM_1)) break block9;
            return false;
        }
        try {
            if (this.isCustomThumbnailsEnabled(2) && !this.hasThumbnail(fileVersion, THUMBNAIL_INDEX_CUSTOM_2)) {
                return false;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return true;
    }

    private boolean _isGeneratePreview(FileVersion fileVersion) throws Exception {
        int contPreviewsCreated = 0;
        int i = 0;
        while (i < _PREVIEW_TYPES.length) {
            if (!this._isGeneratePreview(fileVersion, _PREVIEW_TYPES[i])) {
                ++contPreviewsCreated;
            }
            ++i;
        }
        return contPreviewsCreated < _PREVIEW_TYPES.length;
    }

    private boolean _isGeneratePreview(FileVersion fileVersion, String previewType) throws Exception {
        String previewFilePath = this.getPreviewFilePath(fileVersion, previewType);
        return PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)previewFilePath);
    }

    private boolean _isGenerateThumbnail(FileVersion fileVersion) throws Exception {
        String thumbnailFilePath = this.getThumbnailFilePath(fileVersion, THUMBNAIL_INDEX_DEFAULT);
        return PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED && !DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)thumbnailFilePath);
    }

    private void _queueGeneration(FileVersion fileVersion) {
        if (this._fileVersionIds.contains(fileVersion.getFileVersionId()) || !this.isSupported(fileVersion)) {
            return;
        }
        this._fileVersionIds.add(fileVersion.getFileVersionId());
        if (PropsValues.DL_FILE_ENTRY_PROCESSORS_TRIGGER_SYNCHRONOUSLY) {
            try {
                MessageBusUtil.sendSynchronousMessage((String)"liferay/document_library_video_processor", (Object)fileVersion);
            }
            catch (MessageBusException mbe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)mbe, (Throwable)mbe);
                }
            }
        } else {
            MessageBusUtil.sendMessage((String)"liferay/document_library_video_processor", (Object)fileVersion);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LiferayVideoProcessCallable
    implements ProcessCallable<String> {
        private Map<String, String> _customLogSettings;
        private Properties _ffpresetProperties;
        private String _inputURL;
        private String _liferayHome;
        private String _outputURL;
        private String _serverId;
        private String _tempFileName;
        private Properties _videoProperties;

        public LiferayVideoProcessCallable(String serverId, String liferayHome, Map<String, String> customLogSettings, String inputURL, String outputURL, String tempFileName, Properties videoProperties, Properties ffpresetProperties) {
            this._serverId = serverId;
            this._liferayHome = liferayHome;
            this._customLogSettings = customLogSettings;
            this._inputURL = inputURL;
            this._outputURL = outputURL;
            this._tempFileName = tempFileName;
            this._videoProperties = videoProperties;
            this._ffpresetProperties = ffpresetProperties;
        }

        public String call() throws ProcessException {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Log4JUtil.initLog4J((String)this._serverId, (String)this._liferayHome, (ClassLoader)classLoader, (LogFactory)new Log4jLogFactoryImpl(), this._customLogSettings);
            try {
                LiferayVideoConverter liferayConverter = new LiferayVideoConverter(this._inputURL, this._outputURL, this._tempFileName, this._videoProperties, this._ffpresetProperties);
                ((LiferayConverter)liferayConverter).convert();
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LiferayVideoThumbnailProcessCallable
    implements ProcessCallable<String> {
        private Map<String, String> _customLogSettings;
        private String _extension;
        private int _height;
        private String _inputURL;
        private String _liferayHome;
        private File _outputFile;
        private int _percentage;
        private String _serverId;
        private int _width;

        public LiferayVideoThumbnailProcessCallable(String serverId, String liferayHome, Map<String, String> customLogSettings, String inputURL, File outputFile, String extension, int height, int width, int percentage) {
            this._serverId = serverId;
            this._liferayHome = liferayHome;
            this._customLogSettings = customLogSettings;
            this._inputURL = inputURL;
            this._outputFile = outputFile;
            this._extension = extension;
            this._height = height;
            this._width = width;
            this._percentage = percentage;
        }

        public String call() throws ProcessException {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Log4JUtil.initLog4J((String)this._serverId, (String)this._liferayHome, (ClassLoader)classLoader, (LogFactory)new Log4jLogFactoryImpl(), this._customLogSettings);
            try {
                LiferayVideoThumbnailConverter liferayConverter = new LiferayVideoThumbnailConverter(this._inputURL, this._outputFile, this._extension, this._height, this._width, this._percentage);
                ((LiferayConverter)liferayConverter).convert();
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            return "";
        }
    }
}

