/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DefaultPreviewableProcessor;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import com.liferay.portlet.documentlibrary.util.LiferayConvertCmd;
import com.liferay.portlet.documentlibrary.util.PDFProcessor;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.time.StopWatch;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;
import org.im4java.process.ProcessStarter;

public class PDFProcessorImpl
extends DefaultPreviewableProcessor
implements PDFProcessor {
    private static Log _log = LogFactoryUtil.getLog(PDFProcessorImpl.class);
    private static PDFProcessorImpl _instance = new PDFProcessorImpl();
    private ConvertCmd _convertCmd;
    private List<Long> _fileVersionIds = new Vector<Long>();
    private String _globalSearchPath;
    private boolean _warned;

    static {
        InstancePool.put((String)PDFProcessorImpl.class.getName(), (Object)((Object)_instance));
    }

    public static PDFProcessorImpl getInstance() {
        return _instance;
    }

    public void generateImages(FileVersion fileVersion) throws Exception {
        Initializer._initializedInstance._generateImages(fileVersion);
    }

    public String getGlobalSearchPath() throws Exception {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences();
        String globalSearchPath = preferences.getValue("imagemagick.global.search.path", null);
        if (Validator.isNotNull((String)globalSearchPath)) {
            return globalSearchPath;
        }
        String filterName = null;
        filterName = OSDetector.isApple() ? "apple" : (OSDetector.isWindows() ? "windows" : "unix");
        return PropsUtil.get("imagemagick.global.search.path", new Filter(filterName));
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, int index) throws Exception {
        return Initializer._initializedInstance.doGetPreviewAsStream(fileVersion, index);
    }

    public int getPreviewFileCount(FileVersion fileVersion) {
        try {
            return Initializer._initializedInstance.doGetPreviewFileCount(fileVersion);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return 0;
        }
    }

    public long getPreviewFileSize(FileVersion fileVersion, int index) throws Exception {
        return Initializer._initializedInstance.doGetPreviewFileSize(fileVersion, index);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int thumbnailIndex) throws Exception {
        return this.doGetThumbnailAsStream(fileVersion, thumbnailIndex);
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int thumbnailIndex) throws Exception {
        return this.doGetThumbnailFileSize(fileVersion, thumbnailIndex);
    }

    public boolean hasImages(FileVersion fileVersion) {
        boolean hasImages = false;
        try {
            hasImages = this._hasImages(fileVersion);
            if (!hasImages && this.isSupported(fileVersion)) {
                Initializer._initializedInstance._queueGeneration(fileVersion);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return hasImages;
    }

    public boolean isDocumentSupported(FileVersion fileVersion) {
        return Initializer._initializedInstance.isSupported(fileVersion);
    }

    public boolean isDocumentSupported(String mimeType) {
        return Initializer._initializedInstance.isSupported(mimeType);
    }

    public boolean isImageMagickEnabled() throws Exception {
        if (PrefsPropsUtil.getBoolean("imagemagick.enabled")) {
            return true;
        }
        if (!this._warned) {
            StringBundler sb = new StringBundler(5);
            sb.append("Liferay is not configured to use ImageMagick for ");
            sb.append("generating Document Library previews and will default ");
            sb.append("to PDFBox. For better quality previews, install ");
            sb.append("ImageMagick and enable it in portal-ext.properties.");
            _log.warn((Object)sb.toString());
            this._warned = true;
        }
        return false;
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        if (mimeType.equals("application/pdf") || mimeType.equals("application/x-pdf")) {
            return true;
        }
        if (DocumentConversionUtil.isEnabled()) {
            Set extensions = MimeTypesUtil.getExtensions((String)mimeType);
            for (String extension : extensions) {
                Object[] targetExtensions = DocumentConversionUtil.getConversions(extension = extension.substring(1));
                if (Arrays.binarySearch(targetExtensions, "pdf") < 0) continue;
                return true;
            }
        }
        return false;
    }

    public void reset() throws Exception {
        if (this.isImageMagickEnabled()) {
            this._globalSearchPath = this.getGlobalSearchPath();
            ProcessStarter.setGlobalSearchPath((String)this._globalSearchPath);
            this._convertCmd = new ConvertCmd();
        } else {
            this._convertCmd = null;
        }
    }

    public void trigger(FileVersion fileVersion) {
        Initializer._initializedInstance._queueGeneration(fileVersion);
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return "png";
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return "png";
    }

    protected void initialize() {
        try {
            FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
            FileUtil.mkdirs((String)THUMBNAIL_TMP_PATH);
            this.reset();
        }
        catch (Exception e) {
            _log.warn((Object)e, (Throwable)e);
        }
    }

    private PDFProcessorImpl() {
    }

    /*
     * Exception decompiling
     */
    private void _generateImages(FileVersion fileVersion) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _generateImages(FileVersion fileVersion, File file) throws Exception {
        if (this.isImageMagickEnabled()) {
            this._generateImagesIM(fileVersion, file);
        } else {
            this._generateImagesPB(fileVersion, file);
        }
    }

    private void _generateImages(FileVersion fileVersion, InputStream inputStream) throws Exception {
        if (this.isImageMagickEnabled()) {
            this._generateImagesIM(fileVersion, inputStream);
        } else {
            this._generateImagesPB(fileVersion, inputStream);
        }
    }

    private void _generateImagesIM(FileVersion fileVersion, File file) throws Exception {
        StopWatch stopWatch;
        if (this._isGeneratePreview(fileVersion)) {
            stopWatch = null;
            if (_log.isInfoEnabled()) {
                stopWatch = new StopWatch();
                stopWatch.start();
            }
            this._generateImagesIM(fileVersion, file, false);
            if (_log.isInfoEnabled()) {
                int previewFileCount = this.getPreviewFileCount(fileVersion);
                _log.info((Object)("ImageMagick generated " + previewFileCount + " preview pages for " + fileVersion.getTitle() + " in " + stopWatch));
            }
        }
        if (this._isGenerateThumbnail(fileVersion)) {
            stopWatch = null;
            if (_log.isInfoEnabled()) {
                stopWatch = new StopWatch();
                stopWatch.start();
            }
            this._generateImagesIM(fileVersion, file, true);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("ImageMagick generated a thumbnail for " + fileVersion.getTitle() + " in " + stopWatch));
            }
        }
    }

    private void _generateImagesIM(FileVersion fileVersion, File file, boolean thumbnail) throws Exception {
        String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
        IMOperation imOperation = new IMOperation();
        imOperation.alpha("off");
        imOperation.density(Integer.valueOf(PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI), Integer.valueOf(PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI));
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT != 0) {
            imOperation.adaptiveResize(Integer.valueOf(PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH), Integer.valueOf(PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT));
        } else {
            imOperation.adaptiveResize(Integer.valueOf(PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH));
        }
        imOperation.depth(Integer.valueOf(PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DEPTH));
        if (thumbnail) {
            imOperation.addImage(new String[]{String.valueOf(file.getPath()) + "[0]"});
            imOperation.addImage(new String[]{this.getThumbnailTempFilePath(tempFileId)});
        } else {
            imOperation.addImage(new String[]{file.getPath()});
            imOperation.addImage(new String[]{this.getPreviewTempFilePath(tempFileId, -1)});
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Excecuting command 'convert " + imOperation + "'"));
        }
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED) {
            ImageMagickProcessCallable processCallable = new ImageMagickProcessCallable(this._globalSearchPath, imOperation.getCmdArgs());
            ProcessExecutor.execute((ProcessCallable)processCallable, (String)ClassPathUtil.getPortalClassPath());
        } else {
            this._convertCmd.run((Operation)imOperation, new Object[0]);
        }
        if (thumbnail) {
            File thumbnailTempFile = this.getThumbnailTempFile(tempFileId);
            try {
                this.storeThumbnailImages(fileVersion, thumbnailTempFile);
            }
            finally {
                FileUtil.delete((File)thumbnailTempFile);
            }
        }
        File singlePagePreviewFile = this.getPreviewTempFile(tempFileId, -1);
        if (singlePagePreviewFile.exists()) {
            singlePagePreviewFile.renameTo(this.getPreviewTempFile(tempFileId, 1));
        }
        int total = this.getPreviewTempFileCount(fileVersion);
        int i = 0;
        while (i < total) {
            File previewTempFile = this.getPreviewTempFile(tempFileId, i + 1);
            try {
                this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, i + 1), previewTempFile);
            }
            finally {
                FileUtil.delete((File)previewTempFile);
            }
            ++i;
        }
    }

    private void _generateImagesIM(FileVersion fileVersion, InputStream inputStream) throws Exception {
        File file = FileUtil.createTempFile((InputStream)inputStream);
        try {
            this._generateImagesIM(fileVersion, file);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    private void _generateImagesPB(FileVersion fileVersion, File file) throws Exception {
        this._generateImagesPB(fileVersion, new FileInputStream(file));
    }

    private void _generateImagesPB(FileVersion fileVersion, InputStream inputStream) throws Exception {
        boolean generatePreview = this._isGeneratePreview(fileVersion);
        boolean generateThumbnail = this._isGenerateThumbnail(fileVersion);
        PDDocument pdDocument = null;
        try {
            pdDocument = PDDocument.load((InputStream)inputStream);
            PDDocumentCatalog pdDocumentCatalog = pdDocument.getDocumentCatalog();
            List pdPages = pdDocumentCatalog.getAllPages();
            int i = 0;
            while (i < pdPages.size()) {
                PDPage pdPage = (PDPage)pdPages.get(i);
                if (generateThumbnail && i == 0) {
                    this._generateImagesPB(fileVersion, pdPage, i);
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("PDFBox generated a thumbnail for " + fileVersion.getFileVersionId()));
                    }
                }
                if (!generatePreview) break;
                this._generateImagesPB(fileVersion, pdPage, i + 1);
                ++i;
            }
            if (_log.isInfoEnabled() && generatePreview) {
                _log.info((Object)("PDFBox generated " + this.getPreviewFileCount(fileVersion) + " preview pages for " + fileVersion.getFileVersionId()));
            }
        }
        finally {
            if (pdDocument != null) {
                pdDocument.close();
            }
        }
    }

    private void _generateImagesPB(FileVersion fileVersion, PDPage pdPage, int index) throws Exception {
        RenderedImage renderedImage = pdPage.convertToImage(1, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI);
        renderedImage = PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT != 0 ? ImageToolUtil.scale((RenderedImage)renderedImage, (int)PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH, (int)PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT) : ImageToolUtil.scale((RenderedImage)renderedImage, (int)PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH);
        if (index == 0) {
            this.storeThumbnailImages(fileVersion, renderedImage);
        } else {
            File tempFile = null;
            try {
                String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
                tempFile = this.getPreviewTempFile(tempFileId, index);
                tempFile.createNewFile();
                ImageIO.write(renderedImage, "png", new FileOutputStream(tempFile));
                this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, index), tempFile);
            }
            catch (Throwable throwable) {
                FileUtil.delete(tempFile);
                throw throwable;
            }
            FileUtil.delete((File)tempFile);
        }
    }

    private boolean _hasImages(FileVersion fileVersion) throws Exception {
        block6: {
            if (PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)this.getPreviewFilePath(fileVersion, 1))) {
                return false;
            }
            if (PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED && !this.hasThumbnail(fileVersion, THUMBNAIL_INDEX_DEFAULT)) {
                return false;
            }
            if (!this.isCustomThumbnailsEnabled(1) || this.hasThumbnail(fileVersion, THUMBNAIL_INDEX_CUSTOM_1)) break block6;
            return false;
        }
        try {
            if (this.isCustomThumbnailsEnabled(2) && !this.hasThumbnail(fileVersion, THUMBNAIL_INDEX_CUSTOM_2)) {
                return false;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return true;
    }

    private boolean _isGeneratePreview(FileVersion fileVersion) throws Exception {
        String previewFilePath = this.getPreviewFilePath(fileVersion, 1);
        return PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)previewFilePath);
    }

    private boolean _isGenerateThumbnail(FileVersion fileVersion) throws Exception {
        String thumbnailFilePath = this.getThumbnailFilePath(fileVersion, THUMBNAIL_INDEX_DEFAULT);
        return PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED && !DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)thumbnailFilePath);
    }

    private void _queueGeneration(FileVersion fileVersion) {
        if (this._fileVersionIds.contains(fileVersion.getFileVersionId())) {
            return;
        }
        boolean generateImages = false;
        String extension = fileVersion.getExtension();
        if (extension.equals("pdf")) {
            generateImages = true;
        } else if (DocumentConversionUtil.isEnabled()) {
            String[] conversions;
            String[] stringArray = conversions = DocumentConversionUtil.getConversions(extension);
            int n = conversions.length;
            int n2 = 0;
            while (n2 < n) {
                String conversion = stringArray[n2];
                if (conversion.equals("pdf")) {
                    generateImages = true;
                    break;
                }
                ++n2;
            }
        }
        if (generateImages) {
            this._fileVersionIds.add(fileVersion.getFileVersionId());
            if (PropsValues.DL_FILE_ENTRY_PROCESSORS_TRIGGER_SYNCHRONOUSLY) {
                try {
                    MessageBusUtil.sendSynchronousMessage((String)"liferay/document_library_pdf_processor", (Object)fileVersion);
                }
                catch (MessageBusException mbe) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)mbe, (Throwable)mbe);
                    }
                }
            } else {
                MessageBusUtil.sendMessage((String)"liferay/document_library_pdf_processor", (Object)fileVersion);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImageMagickProcessCallable
    implements ProcessCallable<String> {
        private LinkedList<String> _commandArguments;
        private String _globalSearchPath;

        public ImageMagickProcessCallable(String globalSearchPath, LinkedList<String> commandArguments) {
            this._globalSearchPath = globalSearchPath;
            this._commandArguments = commandArguments;
        }

        public String call() throws ProcessException {
            try {
                LiferayConvertCmd.run(this._globalSearchPath, this._commandArguments);
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            return "";
        }
    }

    private static class Initializer {
        private static PDFProcessorImpl _initializedInstance;

        static {
            _instance.initialize();
            _initializedInstance = _instance;
        }

        private Initializer() {
        }
    }
}

