/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.documentlibrary.util.JQTFastStart;
import com.liferay.portlet.documentlibrary.util.LiferayConverter;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.Configuration;
import com.xuggle.xuggler.IAudioResampler;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IConfigurable;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LiferayVideoConverter
extends LiferayConverter {
    private static final int _VIDEO_BIT_RATE_DEFAULT = 250000;
    private static final int _VIDEO_BIT_RATE_MAX = 1200000;
    private static Log _log = LogFactoryUtil.getLog(LiferayVideoConverter.class);
    private Properties _ffpresetProperties;
    private int _height = 240;
    private IContainer _inputIContainer;
    private String _inputURL;
    private IContainer _outputIContainer;
    private String _outputURL;
    private String _outputVideoFormat;
    private String[] _previewVideoContainers;
    private String _tempFileName;
    private Map<String, Integer> _videoBitRateMap;
    private Map<String, IRational> _videoFrameRateMap;
    private int _width = 320;

    public LiferayVideoConverter(String inputURL, String outputURL, String tempFileName, Properties videoProperties, Properties ffpresetProperties) {
        this._inputURL = inputURL;
        this._outputURL = outputURL;
        this._tempFileName = tempFileName;
        this._ffpresetProperties = ffpresetProperties;
        this._height = GetterUtil.getInteger((String)videoProperties.getProperty("dl.file.entry.preview.video.height"), (int)this._height);
        this._width = GetterUtil.getInteger((String)videoProperties.getProperty("dl.file.entry.preview.video.width"), (int)this._width);
        this._previewVideoContainers = StringUtil.split((String)videoProperties.getProperty("dl.file.entry.preview.video.containers"));
        this.initVideoBitRateMap(videoProperties);
        this.initVideoFrameRateMap(videoProperties);
    }

    public void convert() throws Exception {
        try {
            this.doConvert();
        }
        finally {
            if (this._inputIContainer.isOpened()) {
                this._inputIContainer.close();
            }
            if (this._outputIContainer.isOpened()) {
                this._outputIContainer.close();
            }
        }
        this.createMP4FastStart();
    }

    protected void createMP4FastStart() {
        File videoFile = new File(this._outputURL);
        if (this._outputVideoFormat.equals("mp4") && videoFile.exists()) {
            File tempFile = new File(this._tempFileName);
            try {
                try {
                    JQTFastStart.convert(videoFile, tempFile);
                    if (tempFile.exists() && tempFile.length() > 0L) {
                        videoFile.delete();
                        tempFile.renameTo(videoFile);
                    }
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)"Unable to move MOOV atom to front of MP4 file");
                    }
                    tempFile.delete();
                }
            }
            finally {
                tempFile.delete();
            }
        }
    }

    protected void doConvert() throws Exception {
        this._inputIContainer = IContainer.make();
        this._outputIContainer = IContainer.make();
        this.openContainer(this._inputIContainer, this._inputURL, false);
        this.openContainer(this._outputIContainer, this._outputURL, true);
        int inputStreamsCount = this._inputIContainer.getNumStreams();
        if (inputStreamsCount < 0) {
            throw new RuntimeException("Input URL does not have any streams");
        }
        IContainerFormat iContainerFormat = this._outputIContainer.getContainerFormat();
        this._outputVideoFormat = iContainerFormat.getOutputFormatShortName();
        IAudioResampler[] iAudioResamplers = new IAudioResampler[inputStreamsCount];
        IVideoResampler[] iVideoResamplers = new IVideoResampler[inputStreamsCount];
        IAudioSamples[] inputIAudioSamples = new IAudioSamples[inputStreamsCount];
        IAudioSamples[] outputIAudioSamples = new IAudioSamples[inputStreamsCount];
        IVideoPicture[] inputIVideoPictures = new IVideoPicture[inputStreamsCount];
        IVideoPicture[] outputIVideoPictures = new IVideoPicture[inputStreamsCount];
        IStream[] outputIStreams = new IStream[inputStreamsCount];
        IStreamCoder[] inputIStreamCoders = new IStreamCoder[inputStreamsCount];
        IStreamCoder[] outputIStreamCoders = new IStreamCoder[inputStreamsCount];
        int i = 0;
        while (i < inputStreamsCount) {
            IStreamCoder inputIStreamCoder;
            IStream inputIStream = this._inputIContainer.getStream((long)i);
            inputIStreamCoders[i] = inputIStreamCoder = inputIStream.getStreamCoder();
            ICodec.Type inputICodecType = inputIStreamCoder.getCodecType();
            if (inputICodecType == ICodec.Type.CODEC_TYPE_AUDIO) {
                this.prepareAudio(iAudioResamplers, inputIAudioSamples, outputIAudioSamples, inputIStreamCoder, outputIStreamCoders, this._outputIContainer, outputIStreams, inputICodecType, this._outputURL, i);
            } else if (inputICodecType == ICodec.Type.CODEC_TYPE_VIDEO) {
                this.prepareVideo(iVideoResamplers, inputIVideoPictures, outputIVideoPictures, inputIStreamCoder, outputIStreamCoders, this._outputIContainer, outputIStreams, inputICodecType, this._outputURL, i);
            }
            this.openStreamCoder(inputIStreamCoders[i]);
            this.openStreamCoder(outputIStreamCoders[i]);
            ++i;
        }
        if (this._outputIContainer.writeHeader() < 0) {
            throw new RuntimeException("Unable to write container header");
        }
        boolean keyPacketFound = false;
        int nonKeyAfterKeyCount = 0;
        boolean onlyDecodeKeyPackets = false;
        int previousPacketSize = -1;
        IPacket inputIPacket = IPacket.make();
        IPacket outputIPacket = IPacket.make();
        while (this._inputIContainer.readNextPacket(inputIPacket) == 0) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Current packet size " + inputIPacket.getSize()));
            }
            int streamIndex = inputIPacket.getStreamIndex();
            IStreamCoder inputIStreamCoder = inputIStreamCoders[streamIndex];
            IStreamCoder outputIStreamCoder = outputIStreamCoders[streamIndex];
            if (outputIStreamCoder == null) continue;
            IStream iStream = this._inputIContainer.getStream((long)streamIndex);
            long timeStampOffset = this.getStreamTimeStampOffset(iStream);
            if (inputIStreamCoder.getCodecType() == ICodec.Type.CODEC_TYPE_AUDIO) {
                this.decodeAudio(iAudioResamplers[streamIndex], inputIAudioSamples[streamIndex], outputIAudioSamples[streamIndex], inputIPacket, outputIPacket, inputIStreamCoder, outputIStreamCoder, this._outputIContainer, inputIPacket.getSize(), previousPacketSize, streamIndex, timeStampOffset);
            } else if (inputIStreamCoder.getCodecType() == ICodec.Type.CODEC_TYPE_VIDEO) {
                if (this.isStartDecoding(inputIPacket, inputIStreamCoder, keyPacketFound = this.isKeyPacketFound(inputIPacket, keyPacketFound), nonKeyAfterKeyCount = this.countNonKeyAfterKey(inputIPacket, keyPacketFound, nonKeyAfterKeyCount), onlyDecodeKeyPackets)) {
                    int value = this.decodeVideo(iVideoResamplers[streamIndex], inputIVideoPictures[streamIndex], outputIVideoPictures[streamIndex], inputIPacket, outputIPacket, inputIStreamCoder, outputIStreamCoder, this._outputIContainer, null, null, 0, 0, timeStampOffset);
                    if (value <= 0) {
                        if (inputIPacket.isKey()) {
                            throw new RuntimeException("Unable to decode video stream " + streamIndex);
                        }
                        onlyDecodeKeyPackets = true;
                        continue;
                    }
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Do not decode video stream " + streamIndex));
                }
            }
            previousPacketSize = inputIPacket.getSize();
        }
        this.flush(outputIStreamCoders, this._outputIContainer);
        if (this._outputIContainer.writeTrailer() < 0) {
            throw new RuntimeException("Unable to write trailer to output file");
        }
        this.cleanUp((RefCounted[])iAudioResamplers, (RefCounted[])iVideoResamplers);
        this.cleanUp((RefCounted[])inputIAudioSamples, (RefCounted[])outputIAudioSamples);
        this.cleanUp((RefCounted[])inputIVideoPictures, (RefCounted[])outputIVideoPictures);
        this.cleanUp(inputIStreamCoders, outputIStreamCoders);
        this.cleanUp(inputIPacket, outputIPacket);
    }

    protected int getAudioEncodingChannels(IContainer outputIContainer, int channels) {
        IContainerFormat iContainerFormat = outputIContainer.getContainerFormat();
        String outputFormat = iContainerFormat.getOutputFormatShortName();
        if (outputFormat.equals("ogg")) {
            return 2;
        }
        return super.getAudioEncodingChannels(outputIContainer, channels);
    }

    protected ICodec getAudioEncodingICodec(IContainer outputIContainer) {
        IContainerFormat iContainerFormat = outputIContainer.getContainerFormat();
        String outputFormat = iContainerFormat.getOutputFormatShortName();
        if (outputFormat.equals("ogg")) {
            return ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_VORBIS);
        }
        return super.getAudioEncodingICodec(outputIContainer);
    }

    protected IContainer getInputIContainer() {
        return this._inputIContainer;
    }

    protected void initVideoBitRateMap(Properties videoProperties) {
        this._videoBitRateMap = new HashMap<String, Integer>();
        String[] stringArray = this._previewVideoContainers;
        int n = this._previewVideoContainers.length;
        int n2 = 0;
        while (n2 < n) {
            String previewVideoContainer = stringArray[n2];
            int videoBitRate = GetterUtil.getInteger((String)videoProperties.getProperty("dl.file.entry.preview.video.bit.rate[" + previewVideoContainer + "]"));
            if (videoBitRate > 1200000) {
                videoBitRate = 1200000;
            }
            if (videoBitRate > 0) {
                this._videoBitRateMap.put(previewVideoContainer, videoBitRate);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Bit rate for " + previewVideoContainer + " set to " + videoBitRate));
                }
            }
            ++n2;
        }
    }

    protected void initVideoFrameRateMap(Properties videoProperties) {
        this._videoFrameRateMap = new HashMap<String, IRational>();
        String[] stringArray = this._previewVideoContainers;
        int n = this._previewVideoContainers.length;
        int n2 = 0;
        while (n2 < n) {
            String previewVideoContainer = stringArray[n2];
            int numerator = GetterUtil.getInteger((String)videoProperties.getProperty("dl.file.entry.preview.video.frame.rate.numerator[" + previewVideoContainer + "]"));
            int denominator = GetterUtil.getInteger((String)videoProperties.getProperty("dl.file.entry.preview.video.frame.rate.denominator[" + previewVideoContainer + "]"));
            if (numerator > 0 && denominator > 0) {
                IRational iRational = IRational.make((int)numerator, (int)denominator);
                this._videoFrameRateMap.put(previewVideoContainer, iRational);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Frame rate for " + previewVideoContainer + " set to " + iRational.getNumerator() + "/" + iRational.getDenominator()));
                }
            }
            ++n2;
        }
    }

    protected void prepareVideo(IVideoResampler[] iVideoResamplers, IVideoPicture[] inputIVideoPictures, IVideoPicture[] outputIVideoPictures, IStreamCoder inputIStreamCoder, IStreamCoder[] outputIStreamCoders, IContainer outputIContainer, IStream[] outputIStreams, ICodec.Type inputICodecType, String outputURL, int index) throws Exception {
        IStreamCoder outputIStreamCoder;
        IStream outputIStream;
        outputIStreams[index] = outputIStream = outputIContainer.addNewStream(index);
        outputIStreamCoders[index] = outputIStreamCoder = outputIStream.getStreamCoder();
        int bitRate = inputIStreamCoder.getBitRate();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Original video bitrate " + bitRate));
        }
        if (bitRate == 0) {
            bitRate = GetterUtil.getInteger((Object)this._videoBitRateMap.get(this._outputVideoFormat), (int)250000);
        } else if (bitRate > 1200000) {
            bitRate = 1200000;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Modified video bitrate " + bitRate));
        }
        outputIStreamCoder.setBitRate(bitRate);
        ICodec iCodec = ICodec.guessEncodingCodec(null, null, (String)outputURL, null, (ICodec.Type)inputICodecType);
        if (this._outputVideoFormat.equals("mp4")) {
            iCodec = ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_H264);
        }
        if (iCodec == null) {
            throw new RuntimeException("Unable to determine " + inputICodecType + " encoder for " + outputURL);
        }
        outputIStreamCoder.setCodec(iCodec);
        IRational iRational = inputIStreamCoder.getFrameRate();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Original frame rate " + iRational.getNumerator() + "/" + iRational.getDenominator()));
        }
        if (this._videoFrameRateMap.containsKey(this._outputVideoFormat)) {
            iRational = this._videoFrameRateMap.get(this._outputVideoFormat);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Modified frame rate " + iRational.getNumerator() + "/" + iRational.getDenominator()));
        }
        outputIStreamCoder.setFrameRate(iRational);
        if (inputIStreamCoder.getHeight() <= 0) {
            throw new RuntimeException("Unable to determine height for " + this._inputURL);
        }
        outputIStreamCoder.setHeight(this._height);
        outputIStreamCoder.setPixelType(IPixelFormat.Type.YUV420P);
        outputIStreamCoder.setTimeBase(IRational.make((int)iRational.getDenominator(), (int)iRational.getNumerator()));
        if (inputIStreamCoder.getWidth() <= 0) {
            throw new RuntimeException("Unable to determine width for " + this._inputURL);
        }
        outputIStreamCoder.setWidth(this._width);
        iVideoResamplers[index] = this.createIVideoResampler(inputIStreamCoder, outputIStreamCoder, this._height, this._width);
        inputIVideoPictures[index] = IVideoPicture.make((IPixelFormat.Type)inputIStreamCoder.getPixelType(), (int)inputIStreamCoder.getWidth(), (int)inputIStreamCoder.getHeight());
        outputIVideoPictures[index] = IVideoPicture.make((IPixelFormat.Type)outputIStreamCoder.getPixelType(), (int)outputIStreamCoder.getWidth(), (int)outputIStreamCoder.getHeight());
        ICodec.ID iCodecID = iCodec.getID();
        if (iCodecID.equals((Object)ICodec.ID.CODEC_ID_H264)) {
            Configuration.configure((Properties)this._ffpresetProperties, (IConfigurable)outputIStreamCoder);
        }
    }
}

