/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.util.DLPreviewableProcessor;
import com.liferay.portlet.documentlibrary.util.ImageProcessor;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageProcessorImpl
extends DLPreviewableProcessor
implements ImageProcessor {
    private static Log _log = LogFactoryUtil.getLog(ImageProcessorImpl.class);
    private static ImageProcessorImpl _instance = new ImageProcessorImpl();
    private List<Long> _fileVersionIds = new Vector<Long>();
    private Set<String> _imageMimeTypes = SetUtil.fromArray((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_IMAGE_MIME_TYPES);

    static {
        InstancePool.put((String)ImageProcessorImpl.class.getName(), (Object)((Object)_instance));
    }

    public static ImageProcessorImpl getInstance() {
        return _instance;
    }

    public void cleanUp(FileEntry fileEntry) {
        ImageProcessorImpl.deleteFiles((FileEntry)fileEntry, null);
    }

    public void cleanUp(FileVersion fileVersion) {
        String type = _instance.getThumbnailType(fileVersion);
        ImageProcessorImpl.deleteFiles((FileVersion)fileVersion, (String)type);
    }

    public void generateImages(FileVersion fileVersion) {
        _instance._generateImages(fileVersion);
    }

    public Set<String> getImageMimeTypes() {
        return ImageProcessorImpl._instance._imageMimeTypes;
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int thumbnailIndex) throws Exception {
        return _instance.doGetThumbnailAsStream(fileVersion, thumbnailIndex);
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int thumbnailIndex) throws Exception {
        return _instance.doGetThumbnailFileSize(fileVersion, thumbnailIndex);
    }

    public boolean hasImages(FileVersion fileVersion) {
        if (!PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED) {
            return false;
        }
        boolean hasImages = false;
        try {
            hasImages = _instance._hasImages(fileVersion);
            if (!hasImages && _instance.isSupported(fileVersion)) {
                _instance._queueGeneration(fileVersion);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return hasImages;
    }

    public boolean isImageSupported(FileVersion fileVersion) {
        return _instance.isSupported(fileVersion);
    }

    public boolean isImageSupported(String mimeType) {
        return _instance.isSupported(mimeType);
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        return this._imageMimeTypes.contains(mimeType);
    }

    public void storeThumbnail(long companyId, long groupId, long fileEntryId, long fileVersionId, long custom1ImageId, long custom2ImageId, InputStream is, String type) throws Exception {
        _instance._storeThumbnail(companyId, groupId, fileEntryId, fileVersionId, custom1ImageId, custom2ImageId, is, type);
    }

    public void trigger(FileVersion fileVersion) {
        _instance._queueGeneration(fileVersion);
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return null;
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        String type = fileVersion.getExtension();
        if (type.equals("jpeg")) {
            type = "jpg";
        }
        return type;
    }

    private ImageProcessorImpl() {
    }

    private void _generateImages(FileVersion fileVersion) {
        try {
            if (!PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED) {
                return;
            }
            InputStream inputStream = fileVersion.getContentStream(false);
            byte[] bytes = FileUtil.getBytes((InputStream)inputStream);
            ImageBag imageBag = ImageToolUtil.read((byte[])bytes);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            if (renderedImage == null) {
                return;
            }
            try {
                this.storeThumbnailImages(fileVersion, renderedImage);
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        finally {
            this._fileVersionIds.remove(fileVersion.getFileVersionId());
        }
    }

    private boolean _hasImages(FileVersion fileVersion) {
        block5: {
            if (PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED && !this.hasThumbnail(fileVersion, THUMBNAIL_INDEX_DEFAULT)) {
                return false;
            }
            if (!this.isCustomThumbnailsEnabled(1) || this.hasThumbnail(fileVersion, THUMBNAIL_INDEX_CUSTOM_1)) break block5;
            return false;
        }
        try {
            if (this.isCustomThumbnailsEnabled(2) && !this.hasThumbnail(fileVersion, THUMBNAIL_INDEX_CUSTOM_2)) {
                return false;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return true;
    }

    private void _queueGeneration(FileVersion fileVersion) {
        if (!this._fileVersionIds.contains(fileVersion.getFileVersionId()) && this.isSupported(fileVersion) && !this._hasImages(fileVersion)) {
            this._fileVersionIds.add(fileVersion.getFileVersionId());
            if (PropsValues.DL_FILE_ENTRY_PROCESSORS_TRIGGER_SYNCHRONOUSLY) {
                try {
                    MessageBusUtil.sendSynchronousMessage((String)"liferay/document_library_image_processor", (Object)fileVersion);
                }
                catch (MessageBusException mbe) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)mbe, (Throwable)mbe);
                    }
                }
            } else {
                MessageBusUtil.sendMessage((String)"liferay/document_library_image_processor", (Object)fileVersion);
            }
        }
    }

    private void _storeThumbnail(long companyId, long groupId, long fileEntryId, long fileVersionId, long custom1ImageId, long custom2ImageId, InputStream is, String type) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append(ImageProcessorImpl.getPathSegment((long)groupId, (long)fileEntryId, (long)fileVersionId, (boolean)false));
        if (custom1ImageId != 0L) {
            sb.append("-");
            sb.append(1);
        } else if (custom2ImageId != 0L) {
            sb.append("-");
            sb.append(2);
        }
        sb.append(".");
        sb.append(type);
        String filePath = sb.toString();
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)is);
            this.addFileToStore(companyId, "document_thumbnail/", filePath, file);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }
}

