/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.artofsolving.jodconverter.DefaultDocumentFormatRegistry;
import com.artofsolving.jodconverter.DocumentConverter;
import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import com.artofsolving.jodconverter.openoffice.converter.StreamOpenOfficeDocumentConverter;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DocumentConversionUtil {
    private static final String[] _COMPARABLE_FILE_EXTENSIONS = PropsValues.DL_COMPARABLE_FILE_EXTENSIONS;
    private static final String[] _DEFAULT_CONVERSIONS = new String[0];
    private static final String _LOCALHOST = "localhost";
    private static final String _LOCALHOST_IP = "127.0.0.1";
    private static Log _log = LogFactoryUtil.getLog(DocumentConversionUtil.class);
    private static DocumentConversionUtil _instance = new DocumentConversionUtil();
    private Map<String, String[]> _conversionsMap = new HashMap<String, String[]>();
    private DocumentConverter _documentConverter;
    private OpenOfficeConnection _openOfficeConnection;

    public static File convert(String id, InputStream inputStream, String sourceExtension, String targetExtension) throws IOException, SystemException {
        return _instance._convert(id, inputStream, sourceExtension, targetExtension);
    }

    public static void disconnect() {
        _instance._disconnect();
    }

    public static String[] getConversions(String extension) {
        return _instance._getConversions(extension);
    }

    public static String getFilePath(String id, String targetExtension) {
        StringBundler sb = new StringBundler(5);
        sb.append(SystemProperties.get((String)"java.io.tmpdir"));
        sb.append("/liferay/document_conversion/");
        sb.append(id);
        sb.append(".");
        sb.append(targetExtension);
        return sb.toString();
    }

    public static boolean isComparableVersion(String extension) {
        block7: {
            boolean enabled = false;
            String dotExtension = "." + extension;
            int i = 0;
            while (i < _COMPARABLE_FILE_EXTENSIONS.length) {
                if ("*".equals(_COMPARABLE_FILE_EXTENSIONS[i]) || dotExtension.equals(_COMPARABLE_FILE_EXTENSIONS[i])) {
                    enabled = true;
                    break;
                }
                ++i;
            }
            if (!enabled) {
                return false;
            }
            if (extension.equals("css") || extension.equals("js") || extension.equals("htm") || extension.equals("html") || extension.equals("txt") || extension.equals("xml")) {
                return true;
            }
            try {
                if (DocumentConversionUtil.isEnabled() && DocumentConversionUtil.isConvertBeforeCompare(extension)) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!_log.isErrorEnabled()) break block7;
                _log.error((Object)e, (Throwable)e);
            }
        }
        return false;
    }

    public static boolean isConvertBeforeCompare(String extension) {
        if (extension.equals("txt")) {
            return false;
        }
        String[] conversions = DocumentConversionUtil.getConversions(extension);
        int i = 0;
        while (i < conversions.length) {
            if (conversions[i].equals("txt")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEnabled() {
        try {
            return PrefsPropsUtil.getBoolean("openoffice.server.enabled", PropsValues.OPENOFFICE_SERVER_ENABLED);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private DocumentConversionUtil() {
        this._populateConversionsMap("drawing");
        this._populateConversionsMap("presentation");
        this._populateConversionsMap("spreadsheet");
        this._populateConversionsMap("text");
    }

    private File _convert(String id, InputStream inputStream, String sourceExtension, String targetExtension) throws IOException, SystemException {
        if (!DocumentConversionUtil.isEnabled()) {
            return null;
        }
        sourceExtension = this._fixExtension(sourceExtension);
        targetExtension = this._fixExtension(targetExtension);
        String fileName = DocumentConversionUtil.getFilePath(id, targetExtension);
        File file = new File(fileName);
        if (!PropsValues.OPENOFFICE_CACHE_ENABLED || !file.exists()) {
            DefaultDocumentFormatRegistry documentFormatRegistry = new DefaultDocumentFormatRegistry();
            DocumentFormat inputDocumentFormat = documentFormatRegistry.getFormatByFileExtension(sourceExtension);
            DocumentFormat outputDocumentFormat = documentFormatRegistry.getFormatByFileExtension(targetExtension);
            if (!inputDocumentFormat.isImportable()) {
                throw new SystemException("Conversion is not supported from " + inputDocumentFormat.getName());
            }
            if (!inputDocumentFormat.isExportableTo(outputDocumentFormat)) {
                throw new SystemException("Conversion is not supported from " + inputDocumentFormat.getName() + " to " + outputDocumentFormat.getName());
            }
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            DocumentConverter documentConverter = this._getDocumentConverter();
            documentConverter.convert(inputStream, inputDocumentFormat, (OutputStream)unsyncByteArrayOutputStream, outputDocumentFormat);
            FileUtil.write((File)file, (byte[])unsyncByteArrayOutputStream.unsafeGetByteArray(), (int)0, (int)unsyncByteArrayOutputStream.size());
        }
        return file;
    }

    private void _disconnect() {
        if (this._openOfficeConnection != null) {
            this._openOfficeConnection.disconnect();
        }
    }

    private String _fixExtension(String extension) {
        if (extension.equals("htm")) {
            extension = "html";
        }
        return extension;
    }

    private String[] _getConversions(String extension) {
        Object[] conversions = this._conversionsMap.get(extension = this._fixExtension(extension));
        if (conversions == null) {
            conversions = _DEFAULT_CONVERSIONS;
        } else if (ArrayUtil.contains((Object[])conversions, (Object)extension)) {
            ArrayList<Object> conversionsList = new ArrayList<Object>();
            int i = 0;
            while (i < conversions.length) {
                Object conversion = conversions[i];
                if (!((String)conversion).equals(extension)) {
                    conversionsList.add(conversion);
                }
                ++i;
            }
            conversions = conversionsList.toArray(new String[conversionsList.size()]);
        }
        return conversions;
    }

    private DocumentConverter _getDocumentConverter() throws SystemException {
        if (this._openOfficeConnection != null && this._documentConverter != null) {
            return this._documentConverter;
        }
        String host = PrefsPropsUtil.getString("openoffice.server.host");
        int port = PrefsPropsUtil.getInteger("openoffice.server.port", PropsValues.OPENOFFICE_SERVER_PORT);
        if (this._isRemoteOpenOfficeHost(host)) {
            this._openOfficeConnection = new SocketOpenOfficeConnection(host, port);
            this._documentConverter = new StreamOpenOfficeDocumentConverter(this._openOfficeConnection);
        } else {
            this._openOfficeConnection = new SocketOpenOfficeConnection(port);
            this._documentConverter = new OpenOfficeDocumentConverter(this._openOfficeConnection);
        }
        return this._documentConverter;
    }

    private boolean _isRemoteOpenOfficeHost(String host) {
        return Validator.isNotNull((String)host) && !host.equals(_LOCALHOST_IP) && !host.startsWith(_LOCALHOST);
    }

    private void _populateConversionsMap(String documentFamily) {
        Filter filter = new Filter(documentFamily);
        DefaultDocumentFormatRegistry documentFormatRegistry = new DefaultDocumentFormatRegistry();
        String[] sourceExtensions = PropsUtil.getArray("openoffice.conversion.source.extensions", filter);
        String[] targetExtensions = PropsUtil.getArray("openoffice.conversion.target.extensions", filter);
        String[] stringArray = sourceExtensions;
        int n = sourceExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String sourceExtension = stringArray[n2];
            SortedArrayList conversions = new SortedArrayList();
            DocumentFormat sourceDocumentFormat = documentFormatRegistry.getFormatByFileExtension(sourceExtension);
            if (sourceDocumentFormat == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Invalid source extension " + sourceExtension));
                }
            } else {
                String[] stringArray2 = targetExtensions;
                int n3 = targetExtensions.length;
                int n4 = 0;
                while (n4 < n3) {
                    String targetExtension = stringArray2[n4];
                    DocumentFormat targetDocumentFormat = documentFormatRegistry.getFormatByFileExtension(targetExtension);
                    if (targetDocumentFormat == null) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Invalid target extension " + targetDocumentFormat));
                        }
                    } else if (sourceDocumentFormat.isExportableTo(targetDocumentFormat)) {
                        conversions.add(targetExtension);
                    }
                    ++n4;
                }
                if (conversions.isEmpty()) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("There are no conversions supported from " + sourceExtension));
                    }
                } else {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Conversions supported from " + sourceExtension + " to " + conversions));
                    }
                    this._conversionsMap.put(sourceExtension, conversions.toArray(new String[conversions.size()]));
                }
            }
            ++n2;
        }
    }
}

