/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.util.DLProcessor;
import com.liferay.portlet.documentlibrary.util.DLProcessorRegistry;
import com.liferay.portlet.documentlibrary.util.DLProcessorThreadLocal;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DLProcessorRegistryImpl
implements DLProcessorRegistry {
    private static Log _log = LogFactoryUtil.getLog(DLProcessorRegistryImpl.class);
    private static final String[] _DL_FILE_ENTRY_PROCESSORS = PropsUtil.getArray((String)"dl.file.entry.processors");
    private List<DLProcessor> _dlProcessors = new CopyOnWriteArrayList<DLProcessor>();

    public void cleanUp(FileEntry fileEntry) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        String[] stringArray = _DL_FILE_ENTRY_PROCESSORS;
        int n = _DL_FILE_ENTRY_PROCESSORS.length;
        int n2 = 0;
        while (n2 < n) {
            String dlProcessorClassName = stringArray[n2];
            DLProcessor dlProcessor = (DLProcessor)InstancePool.get((String)dlProcessorClassName);
            dlProcessor.cleanUp(fileEntry);
            ++n2;
        }
        for (DLProcessor dlProcessor : this._dlProcessors) {
            dlProcessor.cleanUp(fileEntry);
        }
    }

    public void cleanUp(FileVersion fileVersion) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        String[] stringArray = _DL_FILE_ENTRY_PROCESSORS;
        int n = _DL_FILE_ENTRY_PROCESSORS.length;
        int n2 = 0;
        while (n2 < n) {
            String dlProcessorClassName = stringArray[n2];
            DLProcessor dlProcessor = (DLProcessor)InstancePool.get((String)dlProcessorClassName);
            dlProcessor.cleanUp(fileVersion);
            ++n2;
        }
        for (DLProcessor dlProcessor : this._dlProcessors) {
            dlProcessor.cleanUp(fileVersion);
        }
    }

    public void register(DLProcessor dlProcessor) {
        this._dlProcessors.add(dlProcessor);
    }

    public void trigger(FileEntry fileEntry) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        if (fileEntry == null || fileEntry.getSize() == 0L) {
            return;
        }
        FileVersion latestFileVersion = null;
        try {
            if (fileEntry.getModel() instanceof DLFileEntry) {
                DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
                latestFileVersion = new LiferayFileVersion(dlFileEntry.getLatestFileVersion(false));
            } else {
                latestFileVersion = fileEntry.getLatestFileVersion();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return;
        }
        String[] stringArray = _DL_FILE_ENTRY_PROCESSORS;
        int n = _DL_FILE_ENTRY_PROCESSORS.length;
        int n2 = 0;
        while (n2 < n) {
            String dlProcessorClassName = stringArray[n2];
            DLProcessor dlProcessor = (DLProcessor)InstancePool.get((String)dlProcessorClassName);
            if (dlProcessor.isSupported(latestFileVersion)) {
                dlProcessor.trigger(latestFileVersion);
            }
            ++n2;
        }
        for (DLProcessor dlProcessor : this._dlProcessors) {
            if (!dlProcessor.isSupported(latestFileVersion)) continue;
            dlProcessor.trigger(latestFileVersion);
        }
    }

    public void unregister(DLProcessor dlProcessor) {
        this._dlProcessors.remove(dlProcessor);
    }
}

