/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMIndexerUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.portlet.PortletURL;
import javax.portlet.WindowStateException;

public class DLIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{DLFileEntry.class.getName()};
    public static final String PORTLET_ID = "20";
    private static final boolean _FILTER_SEARCH = true;
    private static final boolean _PERMISSION_AWARE = true;
    private static Log _log = LogFactoryUtil.getLog(DLIndexer.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long entryClassPK, String actionId) throws Exception {
        return DLFileEntryPermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public boolean isFilterSearch() {
        return true;
    }

    public boolean isPermissionAware() {
        return true;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] folderIds;
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        if (status != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
        if ((folderIds = searchContext.getFolderIds()) != null && folderIds.length > 0) {
            if (folderIds[0] == 0L) {
                return;
            }
            BooleanQuery folderIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            long[] lArray = folderIds;
            int n = folderIds.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    long folderId = lArray[n2];
                    try {
                        DLFolderServiceUtil.getFolder((long)folderId);
                    }
                    catch (Exception exception) {
                        break block6;
                    }
                    folderIdsQuery.addTerm("folderId", folderId);
                }
                ++n2;
            }
            contextQuery.add((Query)folderIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        Group group;
        DDMStructure tikaRawMetadataStructure;
        TreeSet<DDMStructure> ddmStructuresSet = new TreeSet<DDMStructure>();
        long[] groupIds = searchContext.getGroupIds();
        if (groupIds != null && groupIds.length > 0) {
            List dlFileEntryTypes = DLFileEntryTypeLocalServiceUtil.getFileEntryTypes((long[])groupIds);
            for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
                ddmStructuresSet.addAll(dlFileEntryType.getDDMStructures());
            }
        }
        if ((tikaRawMetadataStructure = DDMStructureLocalServiceUtil.fetchStructure((long)(group = GroupLocalServiceUtil.getCompanyGroup((long)searchContext.getCompanyId())).getGroupId(), (String)"TikaRawMetadata")) != null) {
            ddmStructuresSet.add(tikaRawMetadataStructure);
        }
        for (DDMStructure ddmStructure : ddmStructuresSet) {
            this.addSearchDDMStruture(searchQuery, searchContext, ddmStructure);
        }
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        this.addSearchTerm(searchQuery, searchContext, "extension", false);
        this.addSearchTerm(searchQuery, searchContext, "fileEntryTypeId", false);
        this.addSearchTerm(searchQuery, searchContext, "path", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void addFileEntryTypeAttributes(Document document, DLFileVersion dlFileVersion) throws PortalException, SystemException {
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)dlFileVersion.getFileEntryTypeId());
        List ddmStructures = dlFileEntryType.getDDMStructures();
        Group group = GroupLocalServiceUtil.getCompanyGroup((long)dlFileVersion.getCompanyId());
        DDMStructure tikaRawMetadataStructure = DDMStructureLocalServiceUtil.fetchStructure((long)group.getGroupId(), (String)"TikaRawMetadata");
        if (tikaRawMetadataStructure != null) {
            ddmStructures = ListUtil.copy((List)ddmStructures);
            ddmStructures.add(tikaRawMetadataStructure);
        }
        for (DDMStructure ddmStructure : ddmStructures) {
            Fields fields = null;
            try {
                DLFileEntryMetadata fileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.getFileEntryMetadata((long)ddmStructure.getStructureId(), (long)dlFileVersion.getFileVersionId());
                fields = StorageEngineUtil.getFields((long)fileEntryMetadata.getDDMStorageId());
            }
            catch (Exception exception) {}
            if (fields == null) continue;
            DDMIndexerUtil.addAttributes((Document)document, (DDMStructure)ddmStructure, fields);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        DLFileEntry dlFileEntry = (DLFileEntry)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, dlFileEntry.getFileEntryId());
        SearchEngineUtil.deleteDocument((long)dlFileEntry.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        DocumentImpl documentImpl;
        block21: {
            DLFileEntry dlFileEntry = (DLFileEntry)obj;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Indexing document " + dlFileEntry));
            }
            boolean indexContent = true;
            InputStream is = null;
            try {
                Object[] ignoreExtensions;
                if (PropsValues.DL_FILE_INDEXING_MAX_SIZE == 0L) {
                    indexContent = false;
                } else if (PropsValues.DL_FILE_INDEXING_MAX_SIZE != -1L && dlFileEntry.getSize() > PropsValues.DL_FILE_INDEXING_MAX_SIZE) {
                    indexContent = false;
                }
                if (indexContent && ArrayUtil.contains((Object[])(ignoreExtensions = PrefsPropsUtil.getStringArray("dl.file.indexing.ignore.extensions", ",")), (Object)("." + dlFileEntry.getExtension()))) {
                    indexContent = false;
                }
                if (indexContent) {
                    is = dlFileEntry.getFileVersion().getContentStream(false);
                }
            }
            catch (Exception exception) {}
            if (indexContent && is == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Document " + dlFileEntry + " does not have any content"));
                }
                return null;
            }
            try {
                DocumentImpl document = new DocumentImpl();
                long fileEntryId = dlFileEntry.getFileEntryId();
                document.addUID(PORTLET_ID, fileEntryId);
                List assetCategories = AssetCategoryLocalServiceUtil.getCategories((String)DLFileEntry.class.getName(), (long)fileEntryId);
                long[] assetCategoryIds = StringUtil.split((String)ListUtil.toString((List)assetCategories, (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR), (long)0L);
                document.addKeyword("assetCategoryIds", assetCategoryIds);
                String[] assetCategoryNames = StringUtil.split((String)ListUtil.toString((List)assetCategories, (Accessor)AssetCategory.NAME_ACCESSOR));
                document.addKeyword("assetCategoryNames", assetCategoryNames);
                String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)DLFileEntry.class.getName(), (long)fileEntryId);
                document.addKeyword("assetTagNames", assetTagNames);
                document.addKeyword("companyId", dlFileEntry.getCompanyId());
                if (indexContent) {
                    try {
                        document.addFile("content", is, dlFileEntry.getTitle());
                    }
                    catch (IOException iOException) {
                        throw new SearchException("Cannot extract text from file" + dlFileEntry);
                    }
                }
                document.addText("description", dlFileEntry.getDescription());
                document.addKeyword("entryClassName", DLFileEntry.class.getName());
                document.addKeyword("entryClassPK", fileEntryId);
                document.addKeyword("folderId", dlFileEntry.getFolderId());
                document.addKeyword("groupId", this.getParentGroupId(dlFileEntry.getGroupId()));
                document.addDate("modified", dlFileEntry.getModifiedDate());
                document.addKeyword("portletId", PORTLET_ID);
                document.addText("properties", dlFileEntry.getLuceneProperties());
                document.addKeyword("scopeGroupId", dlFileEntry.getGroupId());
                DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
                document.addKeyword("status", dlFileVersion.getStatus());
                document.addText("title", dlFileEntry.getTitle());
                long userId = dlFileEntry.getUserId();
                document.addKeyword("userId", userId);
                document.addKeyword("userName", PortalUtil.getUserName((long)userId, (String)dlFileEntry.getUserName()), true);
                document.addKeyword("dataRepositoryId", dlFileEntry.getDataRepositoryId());
                document.addKeyword("extension", dlFileEntry.getExtension());
                document.addKeyword("fileEntryTypeId", dlFileEntry.getFileEntryTypeId());
                document.addKeyword("path", dlFileEntry.getTitle());
                ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)dlFileEntry.getCompanyId(), (String)DLFileEntry.class.getName(), (long)dlFileVersion.getFileVersionId());
                ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
                this.addFileEntryTypeAttributes((Document)document, dlFileVersion);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Document " + dlFileEntry + " indexed successfully"));
                }
                documentImpl = document;
                if (is == null) break block21;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return documentImpl;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        liferayPortletURL.setLifecycle("ACTION_PHASE");
        try {
            liferayPortletURL.setWindowState(LiferayWindowState.EXCLUSIVE);
        }
        catch (WindowStateException windowStateException) {}
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        String fileEntryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/document_library/get_file");
        portletURL.setParameter("fileEntryId", fileEntryId);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        DLFileEntry dlFileEntry = (DLFileEntry)obj;
        DLFileVersion dlFileVersion = dlFileEntry.getLatestFileVersion(true);
        if (!dlFileVersion.isApproved()) {
            return;
        }
        Document document = this.getDocument(dlFileEntry);
        if (document != null) {
            SearchEngineUtil.updateDocument((long)dlFileEntry.getCompanyId(), (Document)document);
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)classPK);
        this.doReindex(dlFileEntry);
    }

    protected void doReindex(String[] ids) throws Exception {
        if (ids.length == 1) {
            long companyId = GetterUtil.getLong((String)ids[0]);
            this.reindexFolders(companyId);
            this.reindexRoot(companyId);
        } else {
            long companyId = GetterUtil.getLong((String)ids[0]);
            long groupId = GetterUtil.getLong((String)ids[2]);
            long dataRepositoryId = GetterUtil.getLong((String)ids[3]);
            this.reindexFileEntries(companyId, groupId, dataRepositoryId);
        }
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexFileEntries(long companyId, long groupId, long dataRepositoryId) throws Exception {
        long folderId = DLFolderConstants.getFolderId((long)groupId, (long)dataRepositoryId);
        int fileEntriesCount = DLFileEntryLocalServiceUtil.getFileEntriesCount((long)companyId, (long)folderId);
        int fileEntriesPages = fileEntriesCount / 1000;
        int i = 0;
        while (i <= fileEntriesPages) {
            int fileEntriesStart = i * 1000;
            int fileEntriesEnd = fileEntriesStart + 1000;
            this.reindexFileEntries(companyId, groupId, folderId, fileEntriesStart, fileEntriesEnd);
            ++i;
        }
    }

    protected void reindexFileEntries(long companyId, long groupId, long folderId, int fileEntriesStart, int fileEntriesEnd) throws Exception {
        ArrayList<Document> documents = new ArrayList<Document>();
        List dlFileEntries = DLFileEntryLocalServiceUtil.getFileEntries((long)groupId, (long)folderId, (int)fileEntriesStart, (int)fileEntriesEnd, null);
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            Document document = this.getDocument(dlFileEntry);
            if (document == null) continue;
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }

    protected void reindexFolders(long companyId) throws Exception {
        int folderCount = DLFolderLocalServiceUtil.getCompanyFoldersCount((long)companyId);
        int folderPages = folderCount / 1000;
        int i = 0;
        while (i <= folderPages) {
            int folderStart = i * 1000;
            int folderEnd = folderStart + 1000;
            this.reindexFolders(companyId, folderStart, folderEnd);
            ++i;
        }
    }

    protected void reindexFolders(long companyId, int folderStart, int folderEnd) throws Exception {
        List dlFolders = DLFolderLocalServiceUtil.getCompanyFolders((long)companyId, (int)folderStart, (int)folderEnd);
        for (DLFolder dlFolder : dlFolders) {
            String portletId = PORTLET_ID;
            long groupId = dlFolder.getGroupId();
            long folderId = dlFolder.getFolderId();
            String[] newIds = new String[]{String.valueOf(companyId), portletId, String.valueOf(groupId), String.valueOf(folderId)};
            this.reindex(newIds);
        }
    }

    protected void reindexRoot(long companyId) throws Exception {
        int groupCount = GroupLocalServiceUtil.getCompanyGroupsCount((long)companyId);
        int groupPages = groupCount / 1000;
        int i = 0;
        while (i <= groupPages) {
            int groupStart = i * 1000;
            int groupEnd = groupStart + 1000;
            this.reindexRoot(companyId, groupStart, groupEnd);
            ++i;
        }
    }

    protected void reindexRoot(long companyId, int groupStart, int groupEnd) throws Exception {
        List groups = GroupLocalServiceUtil.getCompanyGroups((long)companyId, (int)groupStart, (int)groupEnd);
        for (Group group : groups) {
            long groupId;
            String portletId = PORTLET_ID;
            long folderId = groupId = group.getGroupId();
            String[] newIds = new String[]{String.valueOf(companyId), portletId, String.valueOf(groupId), String.valueOf(folderId)};
            this.reindex(newIds);
        }
    }
}

