/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.AudioProcessor;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DefaultPreviewableProcessor;
import com.liferay.portlet.documentlibrary.util.LiferayAudioConverter;
import com.liferay.portlet.documentlibrary.util.LiferayConverter;
import com.liferay.util.log4j.Log4JUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioProcessorImpl
extends DefaultPreviewableProcessor
implements AudioProcessor {
    private static Log _log = LogFactoryUtil.getLog(AudioProcessorImpl.class);
    private static AudioProcessorImpl _instance = new AudioProcessorImpl();
    private Set<String> _audioMimeTypes = SetUtil.fromArray((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_AUDIO_MIME_TYPES);
    private List<Long> _fileVersionIds = new Vector<Long>();

    static {
        InstancePool.put((String)AudioProcessorImpl.class.getName(), (Object)((Object)_instance));
    }

    public static AudioProcessorImpl getInstance() {
        return _instance;
    }

    public void generateAudio(FileVersion fileVersion) throws Exception {
        _instance._generateAudio(fileVersion);
    }

    public Set<String> getAudioMimeTypes() {
        return AudioProcessorImpl._instance._audioMimeTypes;
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion) throws Exception {
        return _instance.doGetPreviewAsStream(fileVersion);
    }

    public long getPreviewFileSize(FileVersion fileVersion) throws Exception {
        return _instance.doGetPreviewFileSize(fileVersion);
    }

    public boolean hasAudio(FileVersion fileVersion) {
        boolean hasAudio = false;
        try {
            hasAudio = _instance._hasAudio(fileVersion);
            if (!hasAudio && _instance.isSupported(fileVersion)) {
                _instance._queueGeneration(fileVersion);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return hasAudio;
    }

    public boolean isAudioSupported(FileVersion fileVersion) {
        return _instance.isSupported(fileVersion);
    }

    public boolean isAudioSupported(String mimeType) {
        return _instance.isSupported(mimeType);
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        try {
            if (PrefsPropsUtil.getBoolean("xuggler.enabled", PropsValues.XUGGLER_ENABLED)) {
                return this._audioMimeTypes.contains(mimeType);
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public void trigger(FileVersion fileVersion) {
        _instance._queueGeneration(fileVersion);
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return "mp3";
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return null;
    }

    private AudioProcessorImpl() {
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
    }

    private void _generateAudio(FileVersion fileVersion) throws Exception {
        block13: {
            String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
            File audioTempFile = this._getAudioTempFile(tempFileId, fileVersion.getExtension());
            File previewTempFile = this.getPreviewTempFile(tempFileId);
            try {
                if (!PrefsPropsUtil.getBoolean("xuggler.enabled", PropsValues.XUGGLER_ENABLED) || this._hasAudio(fileVersion)) {
                    return;
                }
                try {
                    if (!this._isGeneratePreview(fileVersion)) break block13;
                    File file = null;
                    if (fileVersion instanceof LiferayFileVersion) {
                        try {
                            LiferayFileVersion liferayFileVersion = (LiferayFileVersion)fileVersion;
                            file = liferayFileVersion.getFile(false);
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {}
                    }
                    if (file == null) {
                        InputStream inputStream = fileVersion.getContentStream(false);
                        FileUtil.write((File)audioTempFile, (InputStream)inputStream);
                        file = audioTempFile;
                    }
                    try {
                        this._generateAudioXuggler(fileVersion, file, previewTempFile);
                    }
                    catch (Exception e) {
                        _log.error((Object)e, (Throwable)e);
                    }
                }
                catch (NoSuchFileEntryException noSuchFileEntryException) {}
            }
            finally {
                this._fileVersionIds.remove(fileVersion.getFileVersionId());
                FileUtil.delete((File)audioTempFile);
                FileUtil.delete((File)previewTempFile);
            }
        }
    }

    private void _generateAudioXuggler(FileVersion fileVersion, File srcFile, File destFile) throws Exception {
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        try {
            if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED) {
                LiferayAudioProcessCallable processCallable = new LiferayAudioProcessCallable(ServerDetector.getServerId(), PropsUtil.get("liferay.home"), Log4JUtil.getCustomLogSettings(), srcFile.getCanonicalPath(), destFile.getCanonicalPath());
                ProcessExecutor.execute((ProcessCallable)processCallable, (String)ClassPathUtil.getPortalClassPath());
            } else {
                LiferayAudioConverter liferayConverter = new LiferayAudioConverter(srcFile.getCanonicalPath(), destFile.getCanonicalPath());
                ((LiferayConverter)liferayConverter).convert();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion), destFile);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Xuggler generated a preview audio for " + fileVersion.getTitle() + " in " + stopWatch));
        }
    }

    private File _getAudioTempFile(String tempFileId, String targetExtension) {
        String audioTempFilePath = this._getAudioTempFilePath(tempFileId, targetExtension);
        return new File(audioTempFilePath);
    }

    private String _getAudioTempFilePath(String tempFileId, String targetExtension) {
        StringBundler sb = new StringBundler(5);
        sb.append(PREVIEW_TMP_PATH);
        sb.append(tempFileId);
        if ("mp3".equals(targetExtension)) {
            sb.append("_tmp");
        }
        sb.append(".");
        sb.append(targetExtension);
        return sb.toString();
    }

    private boolean _hasAudio(FileVersion fileVersion) throws Exception {
        if (!this.isSupported(fileVersion)) {
            return false;
        }
        boolean previewExists = DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)this.getPreviewFilePath(fileVersion));
        return PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && previewExists;
    }

    private boolean _isGeneratePreview(FileVersion fileVersion) throws Exception {
        String previewFilePath = this.getPreviewFilePath(fileVersion);
        return PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)previewFilePath);
    }

    private void _queueGeneration(FileVersion fileVersion) {
        if (this._fileVersionIds.contains(fileVersion.getFileVersionId()) || !this.isSupported(fileVersion)) {
            return;
        }
        this._fileVersionIds.add(fileVersion.getFileVersionId());
        if (PropsValues.DL_FILE_ENTRY_PROCESSORS_TRIGGER_SYNCHRONOUSLY) {
            try {
                MessageBusUtil.sendSynchronousMessage((String)"liferay/document_library_audio_processor", (Object)fileVersion);
            }
            catch (MessageBusException mbe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)mbe, (Throwable)mbe);
                }
            }
        } else {
            MessageBusUtil.sendMessage((String)"liferay/document_library_audio_processor", (Object)fileVersion);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LiferayAudioProcessCallable
    implements ProcessCallable<String> {
        private Map<String, String> _customLogSettings;
        private String _inputURL;
        private String _liferayHome;
        private String _outputURL;
        private String _serverId;

        public LiferayAudioProcessCallable(String serverId, String liferayHome, Map<String, String> customLogSettings, String inputURL, String outputURL) {
            this._serverId = serverId;
            this._liferayHome = liferayHome;
            this._customLogSettings = customLogSettings;
            this._inputURL = inputURL;
            this._outputURL = outputURL;
        }

        public String call() throws ProcessException {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Log4JUtil.initLog4J((String)this._serverId, (String)this._liferayHome, (ClassLoader)classLoader, (LogFactory)new Log4jLogFactoryImpl(), this._customLogSettings);
            try {
                LiferayAudioConverter liferayConverter = new LiferayAudioConverter(this._inputURL, this._outputURL);
                ((LiferayConverter)liferayConverter).convert();
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            return "";
        }
    }
}

