/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.store.BaseStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;

public class S3Store
extends BaseStore {
    private static final String _ACCESS_KEY = PropsUtil.get("dl.store.s3.access.key");
    private static final String _BUCKET_NAME = PropsUtil.get("dl.store.s3.bucket.name");
    private static final String _SECRET_KEY = PropsUtil.get("dl.store.s3.secret.key");
    private static Log _log = LogFactoryUtil.getLog(S3Store.class);
    private S3Bucket _s3Bucket;
    private S3Service _s3Service;

    public S3Store() {
        try {
            this._s3Service = this.getS3Service();
            this._s3Bucket = this.getS3Bucket();
        }
        catch (S3ServiceException s3se) {
            _log.error((Object)s3se.getMessage());
        }
    }

    public void addDirectory(long companyId, long repositoryId, String dirName) {
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream is) throws SystemException {
        try {
            S3Object s3Object = new S3Object(this._s3Bucket, this.getKey(companyId, repositoryId, fileName, "1.0"));
            s3Object.setDataInputStream(is);
            this._s3Service.putObject(this._s3Bucket, s3Object);
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public void checkRoot(long companyId) {
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) throws SystemException {
        try {
            S3Object[] s3Objects = this._s3Service.listObjects(this._s3Bucket, this.getKey(companyId, repositoryId, dirName), null);
            int i = 0;
            while (i < s3Objects.length) {
                S3Object s3Object = s3Objects[i];
                this._s3Service.deleteObject(this._s3Bucket, s3Object.getKey());
                ++i;
            }
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) throws SystemException {
        try {
            S3Object[] s3Objects = this._s3Service.listObjects(this._s3Bucket, this.getKey(companyId, repositoryId, fileName), null);
            int i = 0;
            while (i < s3Objects.length) {
                S3Object s3Object = s3Objects[i];
                this._s3Service.deleteObject(this._s3Bucket, s3Object.getKey());
                ++i;
            }
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws SystemException {
        try {
            this._s3Service.deleteObject(this._s3Bucket, this.getKey(companyId, repositoryId, fileName, versionLabel));
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        try {
            if (Validator.isNull((String)versionLabel)) {
                versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
            }
            S3Object s3Object = this._s3Service.getObject(this._s3Bucket, this.getKey(companyId, repositoryId, fileName, versionLabel));
            return s3Object.getDataInputStream();
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public String[] getFileNames(long companyId, long repositoryId) throws SystemException {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            S3Object[] searchObjects = this._s3Service.listObjects(this._s3Bucket, this.getKey(companyId, repositoryId), null);
            int i = 0;
            while (i < searchObjects.length) {
                S3Object currentObject = searchObjects[i];
                String fileName = this.getFileName(currentObject.getKey());
                fileNames.add(fileName);
                ++i;
            }
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
        return fileNames.toArray(new String[0]);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws SystemException {
        try {
            ArrayList<String> list = new ArrayList<String>();
            S3Object[] s3Objects = this._s3Service.listObjects(this._s3Bucket, this.getKey(companyId, repositoryId, dirName), null);
            int i = 0;
            while (i < s3Objects.length) {
                S3Object s3Object = s3Objects[i];
                String key = s3Object.getKey();
                int x = key.indexOf(47);
                x = key.indexOf(47, x + 1);
                int y = key.lastIndexOf(47);
                list.add(key.substring(x, y));
                ++i;
            }
            return list.toArray(new String[list.size()]);
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        try {
            String versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
            S3Object objectDetails = this._s3Service.getObjectDetails(this._s3Bucket, this.getKey(companyId, repositoryId, fileName, versionLabel));
            return objectDetails.getContentLength();
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public boolean hasDirectory(long companyId, long repositoryId, String dirName) {
        return true;
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) throws SystemException {
        try {
            S3Object[] s3Objects = this._s3Service.listObjects(this._s3Bucket, this.getKey(companyId, repositoryId, fileName, versionLabel), null);
            return s3Objects.length != 0;
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public void move(String srcDir, String destDir) {
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws SystemException {
        try {
            S3Object[] s3Objects = this._s3Service.listObjects(this._s3Bucket, this.getKey(companyId, repositoryId, fileName), null);
            int i = 0;
            while (i < s3Objects.length) {
                S3Object oldS3Object = s3Objects[i];
                String oldKey = oldS3Object.getKey();
                oldS3Object = this._s3Service.getObject(this._s3Bucket, oldKey);
                File tempFile = new File(String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + File.separator + PortalUUIDUtil.generate());
                FileUtil.write((File)tempFile, (InputStream)oldS3Object.getDataInputStream());
                FileInputStream is = new FileInputStream(tempFile);
                String newPrefix = this.getKey(companyId, newRepositoryId);
                int x = oldKey.indexOf(47);
                x = oldKey.indexOf(47, x + 1);
                String newKey = String.valueOf(newPrefix) + oldKey.substring(x + 1, oldKey.length());
                S3Object newS3Object = new S3Object(this._s3Bucket, newKey);
                newS3Object.setDataInputStream((InputStream)is);
                this._s3Service.putObject(this._s3Bucket, newS3Object);
                this._s3Service.deleteObject(this._s3Bucket, oldKey);
                FileUtil.delete((File)tempFile);
                ++i;
            }
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String newFileName) throws SystemException {
        try {
            S3Object[] s3Objects = this._s3Service.listObjects(this._s3Bucket, this.getKey(companyId, repositoryId, fileName), null);
            int i = 0;
            while (i < s3Objects.length) {
                S3Object oldS3Object = s3Objects[i];
                String oldKey = oldS3Object.getKey();
                oldS3Object = this._s3Service.getObject(this._s3Bucket, oldKey);
                File tempFile = new File(String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + File.separator + PortalUUIDUtil.generate());
                FileUtil.write((File)tempFile, (InputStream)oldS3Object.getDataInputStream());
                FileInputStream is = new FileInputStream(tempFile);
                String newPrefix = this.getKey(companyId, repositoryId, newFileName);
                int x = oldKey.indexOf("/");
                x = oldKey.indexOf(47, x + 1);
                x = oldKey.indexOf(47, x + 1);
                String newKey = String.valueOf(newPrefix) + oldKey.substring(x + 1, oldKey.length());
                S3Object newS3Object = new S3Object(this._s3Bucket, newKey);
                newS3Object.setDataInputStream((InputStream)is);
                this._s3Service.putObject(this._s3Bucket, newS3Object);
                this._s3Service.deleteObject(this._s3Bucket, oldKey);
                FileUtil.delete((File)tempFile);
                ++i;
            }
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream is) throws SystemException {
        try {
            S3Object s3Object = new S3Object(this._s3Bucket, this.getKey(companyId, repositoryId, fileName, versionLabel));
            s3Object.setDataInputStream(is);
            this._s3Service.putObject(this._s3Bucket, s3Object);
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    protected AWSCredentials getAWSCredentials() throws S3ServiceException {
        if (Validator.isNull((String)_ACCESS_KEY) || Validator.isNull((String)_SECRET_KEY)) {
            throw new S3ServiceException("S3 access and secret keys are not set");
        }
        return new AWSCredentials(_ACCESS_KEY, _SECRET_KEY);
    }

    protected String getFileName(String key) {
        int x = key.indexOf(47);
        x = key.indexOf(47, x + 1);
        int y = key.lastIndexOf(47);
        return key.substring(x + 1, y);
    }

    protected String getHeadVersionLabel(long companyId, long repositoryId, String fileName) throws PortalException, S3ServiceException {
        S3Object[] s3Objects = this._s3Service.listObjects(this._s3Bucket, this.getKey(companyId, repositoryId, fileName), null);
        Object[] keys = new String[s3Objects.length];
        int i = 0;
        while (i < s3Objects.length) {
            S3Object s3Object = s3Objects[i];
            keys[i] = s3Object.getKey();
            ++i;
        }
        if (keys.length > 0) {
            Arrays.sort(keys);
            Object headKey = keys[keys.length - 1];
            int x = ((String)headKey).lastIndexOf(47);
            return ((String)headKey).substring(x + 1, ((String)headKey).length());
        }
        throw new NoSuchFileException(fileName);
    }

    protected String getKey(long companyId, long repositoryId) {
        StringBundler sb = new StringBundler(4);
        sb.append(companyId);
        sb.append("/");
        sb.append(repositoryId);
        sb.append("/");
        return sb.toString();
    }

    protected String getKey(long companyId, long repositoryId, String fileName) {
        StringBundler sb = new StringBundler(6);
        sb.append(companyId);
        sb.append("/");
        sb.append(repositoryId);
        sb.append("/");
        sb.append(fileName);
        sb.append("/");
        return sb.toString();
    }

    protected String getKey(long companyId, long repositoryId, String fileName, String versionLabel) {
        StringBundler sb = new StringBundler(7);
        sb.append(companyId);
        sb.append("/");
        sb.append(repositoryId);
        sb.append("/");
        sb.append(fileName);
        sb.append("/");
        sb.append(versionLabel);
        return sb.toString();
    }

    protected S3Bucket getS3Bucket() throws S3ServiceException {
        if (Validator.isNull((String)_BUCKET_NAME)) {
            throw new S3ServiceException("S3 bucket name is not set");
        }
        return this.getS3Service().createBucket(_BUCKET_NAME);
    }

    protected S3Service getS3Service() throws S3ServiceException {
        AWSCredentials credentials = this.getAWSCredentials();
        return new RestS3Service(credentials);
    }
}

