/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.model.DLContent;
import com.liferay.portlet.documentlibrary.service.DLContentLocalServiceUtil;
import com.liferay.portlet.documentlibrary.store.BaseStore;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.List;

public class DBStore
extends BaseStore {
    private static Log _log = LogFactoryUtil.getLog(DBStore.class);

    public void addDirectory(long companyId, long repositoryId, String dirName) {
    }

    public void addFile(long companyId, long repositoryId, String fileName, byte[] bytes) throws PortalException, SystemException {
        this.updateFile(companyId, repositoryId, fileName, "1.0", bytes);
    }

    public void addFile(long companyId, long repositoryId, String fileName, File file) throws PortalException, SystemException {
        this.updateFile(companyId, repositoryId, fileName, "1.0", file);
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream inputStream) throws PortalException, SystemException {
        this.updateFile(companyId, repositoryId, fileName, "1.0", inputStream);
    }

    public void checkRoot(long companyId) {
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) throws SystemException {
        DLContentLocalServiceUtil.deleteContentsByDirectory((long)companyId, (long)repositoryId, (String)dirName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) throws SystemException {
        DLContentLocalServiceUtil.deleteContents((long)companyId, (long)repositoryId, (String)fileName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        DLContentLocalServiceUtil.deleteContent((long)companyId, (long)repositoryId, (String)fileName, (String)versionLabel);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        DLContent dlContent = DLContentLocalServiceUtil.getContent((long)companyId, (long)repositoryId, (String)fileName);
        dlContent.resetOriginalValues();
        Blob blobData = dlContent.getData();
        if (blobData == null) {
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(9);
                sb.append("No blob data found for file {companyId=");
                sb.append(companyId);
                sb.append(", repositoryId=");
                sb.append(repositoryId);
                sb.append(", fileName=");
                sb.append(fileName);
                sb.append("}");
                _log.warn((Object)sb.toString());
            }
            return null;
        }
        try {
            return blobData.getBinaryStream();
        }
        catch (SQLException sqle) {
            StringBundler sb = new StringBundler(7);
            sb.append("Unable to load data binary stream for file {companyId=");
            sb.append(companyId);
            sb.append(", repositoryId=");
            sb.append(repositoryId);
            sb.append(", fileName=");
            sb.append(fileName);
            sb.append("}");
            throw new SystemException(sb.toString(), (Throwable)sqle);
        }
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        DLContent dlContent = DLContentLocalServiceUtil.getContent((long)companyId, (long)repositoryId, (String)fileName, (String)versionLabel);
        Blob blobData = dlContent.getData();
        if (blobData == null) {
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(9);
                sb.append("No blob data found for file {companyId=");
                sb.append(companyId);
                sb.append(", repositoryId=");
                sb.append(repositoryId);
                sb.append(", fileName=");
                sb.append(fileName);
                sb.append(", versionLabel=");
                sb.append(versionLabel);
                sb.append("}");
                _log.warn((Object)sb.toString());
            }
            return null;
        }
        try {
            return blobData.getBinaryStream();
        }
        catch (SQLException sqle) {
            StringBundler sb = new StringBundler(9);
            sb.append("Unable to load data binary stream for file {companyId=");
            sb.append(companyId);
            sb.append(", repositoryId=");
            sb.append(repositoryId);
            sb.append(", fileName=");
            sb.append(fileName);
            sb.append(", versionLabel=");
            sb.append(versionLabel);
            sb.append("}");
            throw new SystemException(sb.toString(), (Throwable)sqle);
        }
    }

    public String[] getFileNames(long companyId, long repositoryId) throws SystemException {
        List dlContents = DLContentLocalServiceUtil.getContents((long)companyId, (long)repositoryId);
        String[] fileNames = new String[dlContents.size()];
        int i = 0;
        while (i < dlContents.size()) {
            DLContent dlContent = (DLContent)dlContents.get(i);
            fileNames[i] = dlContent.getPath();
            ++i;
        }
        return fileNames;
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws SystemException {
        List dlContents = DLContentLocalServiceUtil.getContentsByDirectory((long)companyId, (long)repositoryId, (String)dirName);
        String[] fileNames = new String[dlContents.size()];
        int i = 0;
        while (i < dlContents.size()) {
            DLContent dlContent = (DLContent)dlContents.get(i);
            fileNames[i] = dlContent.getPath();
            ++i;
        }
        return fileNames;
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        DLContent dlContent = DLContentLocalServiceUtil.getContent((long)companyId, (long)repositoryId, (String)fileName);
        return dlContent.getSize();
    }

    public boolean hasDirectory(long companyId, long repositoryId, String dirName) {
        return true;
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) throws SystemException {
        return DLContentLocalServiceUtil.hasContent((long)companyId, (long)repositoryId, (String)fileName, (String)versionLabel);
    }

    public void move(String srcDir, String destDir) {
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws SystemException {
        DLContentLocalServiceUtil.updateDLContent((long)companyId, (long)repositoryId, (long)newRepositoryId, (String)fileName, (String)fileName);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String newFileName) throws SystemException {
        DLContentLocalServiceUtil.updateDLContent((long)companyId, (long)repositoryId, (long)repositoryId, (String)fileName, (String)newFileName);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, byte[] bytes) throws PortalException, SystemException {
        if (DLContentLocalServiceUtil.hasContent((long)companyId, (long)repositoryId, (String)fileName, (String)versionLabel)) {
            throw new DuplicateFileException(fileName);
        }
        DLContentLocalServiceUtil.addContent((long)companyId, (long)repositoryId, (String)fileName, (String)versionLabel, (byte[])bytes);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, File file) throws PortalException, SystemException {
        if (DLContentLocalServiceUtil.hasContent((long)companyId, (long)repositoryId, (String)fileName, (String)versionLabel)) {
            throw new DuplicateFileException(fileName);
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new SystemException((Throwable)fnfe);
        }
        DLContentLocalServiceUtil.addContent((long)companyId, (long)repositoryId, (String)fileName, (String)versionLabel, (InputStream)inputStream, (long)file.length());
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream inputStream) throws PortalException, SystemException {
        if (DLContentLocalServiceUtil.hasContent((long)companyId, (long)repositoryId, (String)fileName, (String)versionLabel)) {
            throw new DuplicateFileException(fileName);
        }
        long length = -1L;
        if (inputStream instanceof ByteArrayInputStream) {
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)inputStream;
            length = byteArrayInputStream.available();
        } else if (inputStream instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)inputStream;
            FileChannel fileChannel = fileInputStream.getChannel();
            try {
                length = fileChannel.size();
            }
            catch (IOException ioe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to detect file size from file channel", (Throwable)ioe);
                }
            }
        } else if (inputStream instanceof UnsyncByteArrayInputStream) {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = (UnsyncByteArrayInputStream)inputStream;
            length = unsyncByteArrayInputStream.available();
        }
        if (length >= 0L) {
            DLContentLocalServiceUtil.addContent((long)companyId, (long)repositoryId, (String)fileName, (String)versionLabel, (InputStream)inputStream, (long)length);
        } else {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to detect length from input stream. Reading entire input stream into memory as a last resort.");
            }
            byte[] bytes = null;
            try {
                bytes = FileUtil.getBytes((InputStream)inputStream);
            }
            catch (IOException ioe) {
                throw new SystemException((Throwable)ioe);
            }
            DLContentLocalServiceUtil.addContent((long)companyId, (long)repositoryId, (String)fileName, (String)versionLabel, (byte[])bytes);
        }
    }
}

