/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryFinder;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderFinderImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileEntryFinderImpl
extends BasePersistenceImpl<DLFileEntry>
implements DLFileEntryFinder {
    public static String COUNT_BY_EXTRA_SETTINGS = String.valueOf(DLFileEntryFinder.class.getName()) + ".countByExtraSettings";
    public static String COUNT_BY_G_F = String.valueOf(DLFileEntryFinder.class.getName()) + ".countByG_F";
    public static String COUNT_BY_G_U_F = String.valueOf(DLFileEntryFinder.class.getName()) + ".countByG_U_F";
    public static String COUNT_BY_G_F_S = String.valueOf(DLFileEntryFinder.class.getName()) + ".countByG_F_S";
    public static String COUNT_BY_G_U_F_S = String.valueOf(DLFileEntryFinder.class.getName()) + ".countByG_U_F_S";
    public static String FIND_BY_ANY_IMAGE_ID = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByAnyImageId";
    public static String FIND_BY_EXTRA_SETTINGS = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByExtraSettings";
    public static String FIND_BY_NO_ASSETS = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByNoAssets";
    public static String FIND_BY_ORPHANED_FILE_ENTRIES = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByOrphanedFileEntries";
    public static String FIND_BY_G_F = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByG_F";
    public static String FIND_BY_G_U_F = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByG_U_F";
    public static String FIND_BY_G_F_S = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByG_F_S";
    public static String FIND_BY_G_U_F_S = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByG_U_F_S";

    public int countByExtraSettings() throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_EXTRA_SETTINGS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_F_S(long groupId, List<Long> folderIds, int status) throws SystemException {
        return this.doCountByG_F_S(groupId, folderIds, status, false);
    }

    public int countByG_U_F_M_S(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, int status) throws SystemException {
        Session session = null;
        String table = "DLFileVersion";
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_U_F_S);
            if (userId <= 0L) {
                if (status == -1) {
                    table = "DLFileEntry";
                    sql = CustomSQLUtil.get((String)COUNT_BY_G_F);
                } else {
                    sql = CustomSQLUtil.get((String)COUNT_BY_G_F_S);
                    sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)"");
                }
            } else if (status == -1) {
                table = "DLFileEntry";
                sql = CustomSQLUtil.get((String)COUNT_BY_G_U_F);
            }
            StringBundler sb = new StringBundler();
            if (folderIds.size() > 0) {
                sb.append("(");
                sb.append(this.getFolderIds(folderIds, table));
                sb.append(")");
            }
            if (mimeTypes != null && mimeTypes.length > 0) {
                sb.append(" AND ");
                sb.append("(");
                sb.append(this.getMimeTypes(mimeTypes, table));
                sb.append(")");
            }
            sql = StringUtil.replace((String)sql, (String)"[$FOLDER_ID$]", (String)sb.toString());
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (userId > 0L) {
                qPos.add(userId);
            }
            if (status != -1) {
                qPos.add(status);
            }
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public DLFileEntry fetchByAnyImageId(long imageId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ANY_IMAGE_ID);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFileEntry", DLFileEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(imageId);
            qPos.add(imageId);
            qPos.add(imageId);
            qPos.add(imageId);
            List dlFileEntries = q.list();
            if (!dlFileEntries.isEmpty()) {
                DLFileEntry dLFileEntry = (DLFileEntry)dlFileEntries.get(0);
                return dLFileEntry;
            }
            return null;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int filterCountByG_F_S(long groupId, List<Long> folderIds, int status) throws SystemException {
        return this.doCountByG_F_S(groupId, folderIds, status, true);
    }

    public DLFileEntry findByAnyImageId(long imageId) throws NoSuchFileEntryException, SystemException {
        DLFileEntry dlFileEntry = this.fetchByAnyImageId(imageId);
        if (dlFileEntry != null) {
            return dlFileEntry;
        }
        throw new NoSuchFileEntryException("No DLFileEntry exists with the imageId " + imageId);
    }

    public List<DLFileEntry> findByExtraSettings(int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_EXTRA_SETTINGS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFileEntry", DLFileEntryImpl.class);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByNoAssets() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFileEntry", DLFileEntryImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByOrphanedFileEntries() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ORPHANED_FILE_ENTRIES);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFileEntry", DLFileEntryImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByG_U_F_M_S(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, int status, int start, int end, OrderByComparator obc) throws SystemException {
        Session session = null;
        String table = "DLFileVersion";
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_U_F_S);
            if (userId <= 0L) {
                if (status == -1) {
                    table = "DLFileEntry";
                    sql = CustomSQLUtil.get((String)FIND_BY_G_F);
                } else {
                    sql = CustomSQLUtil.get((String)FIND_BY_G_F_S);
                }
            } else if (status == -1) {
                table = "DLFileEntry";
                sql = CustomSQLUtil.get((String)FIND_BY_G_U_F);
            }
            StringBundler sb = new StringBundler();
            if (folderIds.size() > 0) {
                sb.append("(");
                sb.append(this.getFolderIds(folderIds, table));
                sb.append(")");
            }
            if (mimeTypes != null && mimeTypes.length > 0) {
                sb.append(" AND ");
                sb.append("(");
                sb.append(this.getMimeTypes(mimeTypes, table));
                sb.append(")");
            }
            sql = StringUtil.replace((String)sql, (String)"[$FOLDER_ID$]", (String)sb.toString());
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFileEntry", DLFileEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (userId > 0L) {
                qPos.add(userId);
            }
            if (status != -1) {
                qPos.add(status);
            }
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_F_S(long groupId, List<Long> folderIds, int status, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = null;
            String table = "DLFileEntry";
            if (status == -1) {
                sql = CustomSQLUtil.get((String)COUNT_BY_G_F);
            } else {
                sql = CustomSQLUtil.get((String)COUNT_BY_G_F_S);
                if (inlineSQLHelper && InlineSQLHelperUtil.isEnabled()) {
                    sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)CustomSQLUtil.get((String)DLFolderFinderImpl.JOIN_FV_BY_DL_FILE_ENTRY));
                } else {
                    table = "DLFileVersion";
                    sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)"");
                }
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)DLFileEntry.class.getName(), (String)"DLFileEntry.fileEntryId", (long)groupId);
            }
            sql = StringUtil.replace((String)sql, (String)"[$FOLDER_ID$]", (String)this.getFolderIds(folderIds, table));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (status != -1) {
                qPos.add(status);
            }
            int i = 0;
            while (i < folderIds.size()) {
                Long folderId = folderIds.get(i);
                qPos.add(folderId);
                ++i;
            }
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getFolderIds(List<Long> folderIds, String table) {
        if (folderIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(folderIds.size() * 2 - 1);
        int i = 0;
        while (i < folderIds.size()) {
            sb.append(table);
            sb.append(".folderId = ? ");
            if (i + 1 != folderIds.size()) {
                sb.append(" OR ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected String getMimeTypes(String[] mimeTypes, String table) {
        if (mimeTypes.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(mimeTypes.length * 2 - 1);
        int i = 0;
        while (i < mimeTypes.length) {
            sb.append(table);
            sb.append(".mimeType = '");
            sb.append(mimeTypes[i]);
            sb.append("'");
            if (i + 1 != mimeTypes.length) {
                sb.append(" OR ");
            }
            ++i;
        }
        return sb.toString();
    }
}

