/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.delta.ByteChannelReader;
import com.liferay.portal.kernel.io.delta.ByteChannelWriter;
import com.liferay.portal.kernel.io.delta.DeltaUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.model.DLSyncUpdate;
import com.liferay.portlet.documentlibrary.service.base.DLSyncServiceBaseImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Date;
import java.util.List;

public class DLSyncServiceImpl
extends DLSyncServiceBaseImpl {
    public DLSyncUpdate getDLSyncUpdate(long companyId, long repositoryId, Date lastAccessDate) throws SystemException {
        Date now = new Date();
        List dlSyncs = null;
        if (lastAccessDate != null) {
            dlSyncs = this.dlSyncPersistence.findByC_M_R(companyId, lastAccessDate, repositoryId);
        }
        DLSyncUpdate dlSyncUpdate = new DLSyncUpdate(dlSyncs, now);
        return dlSyncUpdate;
    }

    public InputStream getFileDeltaAsStream(long fileEntryId, String sourceVersion, String destinationVersion) throws PortalException, SystemException {
        FileInputStream deltaInputStream = null;
        FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
        InputStream sourceInputStream = null;
        File sourceFile = FileUtil.createTempFile();
        FileInputStream sourceFileInputStream = null;
        FileChannel sourceFileChannel = null;
        File checksumsFile = FileUtil.createTempFile();
        FileOutputStream checksumsOutputStream = null;
        WritableByteChannel checksumsWritableByteChannel = null;
        try {
            try {
                sourceInputStream = fileEntry.getContentStream(sourceVersion);
                FileUtil.write((File)sourceFile, (InputStream)sourceInputStream);
                sourceFileInputStream = new FileInputStream(sourceFile);
                sourceFileChannel = sourceFileInputStream.getChannel();
                checksumsOutputStream = new FileOutputStream(checksumsFile);
                checksumsWritableByteChannel = Channels.newChannel(checksumsOutputStream);
                ByteChannelWriter checksumsByteChannelWriter = new ByteChannelWriter(checksumsWritableByteChannel);
                DeltaUtil.checksums((FileChannel)sourceFileChannel, (ByteChannelWriter)checksumsByteChannelWriter);
                checksumsByteChannelWriter.finish();
            }
            catch (Exception e) {
                throw new PortalException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(sourceFileInputStream);
            StreamUtil.cleanUp(sourceFileChannel);
            StreamUtil.cleanUp(checksumsOutputStream);
            StreamUtil.cleanUp(checksumsWritableByteChannel);
            FileUtil.delete((File)sourceFile);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)sourceFileInputStream);
        StreamUtil.cleanUp((Channel)sourceFileChannel);
        StreamUtil.cleanUp((OutputStream)checksumsOutputStream);
        StreamUtil.cleanUp((Channel)checksumsWritableByteChannel);
        FileUtil.delete((File)sourceFile);
        InputStream destinationInputStream = null;
        ReadableByteChannel destinationReadableByteChannel = null;
        FileInputStream checksumsInputStream = null;
        ReadableByteChannel checksumsReadableByteChannel = null;
        FileOutputStream deltaOutputStream = null;
        WritableByteChannel deltaOutputStreamWritableByteChannel = null;
        try {
            try {
                destinationInputStream = fileEntry.getContentStream(destinationVersion);
                destinationReadableByteChannel = Channels.newChannel(destinationInputStream);
                checksumsInputStream = new FileInputStream(checksumsFile);
                checksumsReadableByteChannel = Channels.newChannel(checksumsInputStream);
                ByteChannelReader checksumsByteChannelReader = new ByteChannelReader(checksumsReadableByteChannel);
                File deltaFile = FileUtil.createTempFile();
                deltaOutputStream = new FileOutputStream(deltaFile);
                deltaOutputStreamWritableByteChannel = Channels.newChannel(deltaOutputStream);
                ByteChannelWriter deltaByteChannelWriter = new ByteChannelWriter(deltaOutputStreamWritableByteChannel);
                DeltaUtil.delta((ReadableByteChannel)destinationReadableByteChannel, (ByteChannelReader)checksumsByteChannelReader, (ByteChannelWriter)deltaByteChannelWriter);
                deltaByteChannelWriter.finish();
                deltaInputStream = new FileInputStream(deltaFile);
            }
            catch (Exception e) {
                throw new PortalException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(destinationInputStream);
            StreamUtil.cleanUp(destinationReadableByteChannel);
            StreamUtil.cleanUp(checksumsInputStream);
            StreamUtil.cleanUp(checksumsReadableByteChannel);
            StreamUtil.cleanUp(deltaOutputStream);
            StreamUtil.cleanUp(deltaOutputStreamWritableByteChannel);
            FileUtil.delete((File)checksumsFile);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)destinationInputStream);
        StreamUtil.cleanUp((Channel)destinationReadableByteChannel);
        StreamUtil.cleanUp((InputStream)checksumsInputStream);
        StreamUtil.cleanUp((Channel)checksumsReadableByteChannel);
        StreamUtil.cleanUp((OutputStream)deltaOutputStream);
        StreamUtil.cleanUp((Channel)deltaOutputStreamWritableByteChannel);
        FileUtil.delete((File)checksumsFile);
        return deltaInputStream;
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream deltaInputStream, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        FileEntry fileEntry;
        FileEntry fileEntry2 = this.dlAppLocalService.getFileEntry(fileEntryId);
        InputStream originalInputStream = null;
        File patchedFile = null;
        FileInputStream patchedInputStream = null;
        try {
            originalInputStream = fileEntry2.getContentStream();
            patchedFile = FileUtil.createTempFile();
            this.patchFile(originalInputStream, deltaInputStream, patchedFile);
            patchedInputStream = new FileInputStream(patchedFile);
            fileEntry = this.dlAppService.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, (InputStream)patchedInputStream, size, serviceContext);
        }
        catch (Exception e) {
            try {
                throw new PortalException((Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((InputStream)originalInputStream);
                StreamUtil.cleanUp(patchedInputStream);
                FileUtil.delete((File)patchedFile);
                throw throwable;
            }
        }
        StreamUtil.cleanUp((InputStream)originalInputStream);
        StreamUtil.cleanUp((InputStream)patchedInputStream);
        FileUtil.delete((File)patchedFile);
        return fileEntry;
    }

    protected void patchFile(InputStream originalInputStream, InputStream deltaInputStream, File patchedFile) throws PortalException {
        File originalFile = null;
        FileInputStream originalFileInputStream = null;
        FileChannel originalFileChannel = null;
        FileOutputStream patchedFileOutputStream = null;
        WritableByteChannel patchedWritableByteChannel = null;
        ReadableByteChannel deltaReadableByteChannel = null;
        try {
            try {
                originalFile = FileUtil.createTempFile();
                FileUtil.write((File)originalFile, (InputStream)originalInputStream);
                originalFileInputStream = new FileInputStream(originalFile);
                originalFileChannel = originalFileInputStream.getChannel();
                patchedFileOutputStream = new FileOutputStream(patchedFile);
                patchedWritableByteChannel = Channels.newChannel(patchedFileOutputStream);
                deltaReadableByteChannel = Channels.newChannel(deltaInputStream);
                ByteChannelReader deltaByteChannelReader = new ByteChannelReader(deltaReadableByteChannel);
                DeltaUtil.patch((FileChannel)originalFileChannel, (WritableByteChannel)patchedWritableByteChannel, (ByteChannelReader)deltaByteChannelReader);
            }
            catch (Exception e) {
                throw new PortalException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(originalFileInputStream);
            StreamUtil.cleanUp(originalFileChannel);
            StreamUtil.cleanUp(patchedFileOutputStream);
            StreamUtil.cleanUp(patchedWritableByteChannel);
            StreamUtil.cleanUp(deltaReadableByteChannel);
            FileUtil.delete((File)originalFile);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)originalFileInputStream);
        StreamUtil.cleanUp((Channel)originalFileChannel);
        StreamUtil.cleanUp((OutputStream)patchedFileOutputStream);
        StreamUtil.cleanUp((Channel)patchedWritableByteChannel);
        StreamUtil.cleanUp((Channel)deltaReadableByteChannel);
        FileUtil.delete((File)originalFile);
    }
}

