/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portlet.documentlibrary.model.DLSync;
import com.liferay.portlet.documentlibrary.service.base.DLSyncLocalServiceBaseImpl;
import java.util.Date;

public class DLSyncLocalServiceImpl
extends DLSyncLocalServiceBaseImpl {
    public DLSync addSync(long fileId, String fileUuid, long companyId, long repositoryId, long parentFolderId, String name, String type, String version) throws SystemException {
        Date now = new Date();
        long syncId = this.counterLocalService.increment();
        DLSync dlSync = this.dlSyncPersistence.create(syncId);
        dlSync.setCompanyId(companyId);
        dlSync.setCreateDate(now);
        dlSync.setModifiedDate(now);
        dlSync.setFileId(fileId);
        dlSync.setFileUuid(fileUuid);
        dlSync.setRepositoryId(repositoryId);
        dlSync.setParentFolderId(parentFolderId);
        dlSync.setEvent("add");
        dlSync.setType(type);
        dlSync.setName(name);
        dlSync.setVersion(version);
        this.dlSyncPersistence.update((BaseModel)dlSync, false);
        return dlSync;
    }

    public DLSync updateSync(long fileId, long parentFolderId, String name, String event, String version) throws PortalException, SystemException {
        DLSync dlSync = null;
        if (event == "delete") {
            dlSync = this.dlSyncPersistence.fetchByFileId(fileId);
            if (dlSync == null) {
                return null;
            }
        } else {
            dlSync = this.dlSyncPersistence.findByFileId(fileId);
        }
        dlSync.setModifiedDate(new Date());
        dlSync.setParentFolderId(parentFolderId);
        dlSync.setEvent(event);
        dlSync.setName(name);
        dlSync.setVersion(version);
        this.dlSyncPersistence.update((BaseModel)dlSync, false);
        return dlSync;
    }
}

