/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.ExpiredLockException;
import com.liferay.portal.InvalidLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFolderServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFolderServiceImpl
extends DLFolderServiceBaseImpl {
    public DLFolder addFolder(long groupId, long repositoryId, boolean mountPoint, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, parentFolderId, "ADD_FOLDER");
        return this.dlFolderLocalService.addFolder(this.getUserId(), groupId, repositoryId, mountPoint, parentFolderId, name, description, serviceContext);
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), dlFolder, "DELETE");
        boolean hasLock = this.hasFolderLock(folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.doLockFolder(folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
        }
        try {
            this.dlFolderLocalService.deleteFolder(folderId);
        }
        finally {
            if (!hasLock) {
                this.doUnlockFolder(dlFolder.getGroupId(), folderId, lock.getUuid());
            }
        }
    }

    public void deleteFolder(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        DLFolder dlFolder = this.getFolder(groupId, parentFolderId, name);
        this.deleteFolder(dlFolder.getFolderId());
    }

    public List<Object> getFileEntriesAndFileShortcuts(long groupId, long folderId, int status, int start, int end) throws SystemException {
        return this.dlFolderFinder.filterFindFE_FS_ByG_F_S(groupId, folderId, status, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status) throws SystemException {
        int fileEntriesCount = 0;
        fileEntriesCount = status == -1 && !InlineSQLHelperUtil.isEnabled((long)groupId) ? this.dlFileEntryPersistence.countByG_F(groupId, folderId) : this.dlFolderFinder.filterCountFE_ByG_F_S(groupId, folderId, status);
        int fileShortcutsCount = this.dlFileShortcutPersistence.filterCountByG_F_S(groupId, folderId, 0);
        return fileEntriesCount + fileShortcutsCount;
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, String[] mimeTypes) throws SystemException {
        return this.dlFolderFinder.filterCountFE_FS_ByG_F_S_M(groupId, folderId, status, mimeTypes);
    }

    public DLFolder getFolder(long folderId) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), dlFolder, "VIEW");
        return dlFolder;
    }

    public DLFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(groupId, parentFolderId, name);
        DLFolderPermission.check(this.getPermissionChecker(), dlFolder, "VIEW");
        return dlFolder;
    }

    public long[] getFolderIds(long groupId, long folderId) throws SystemException {
        List<Long> folderIds = this.getSubfolderIds(groupId, folderId, true);
        folderIds.add(0, folderId);
        return ArrayUtil.toArray((Long[])folderIds.toArray(new Long[folderIds.size()]));
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, boolean includeMountfolders, int start, int end, OrderByComparator obc) throws SystemException {
        if (includeMountfolders) {
            return this.dlFolderPersistence.filterFindByG_P(groupId, parentFolderId, start, end, obc);
        }
        return this.dlFolderPersistence.filterFindByG_P_M(groupId, parentFolderId, false, start, end, obc);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.getFolders(groupId, parentFolderId, true, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFolderFinder.filterFindF_FE_FS_ByG_F_S_M_M(groupId, folderId, status, null, includeMountFolders, start, end, obc);
    }

    public int getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws SystemException {
        return this.dlFolderFinder.filterCountF_FE_FS_ByG_F_S_M_M(groupId, folderId, status, mimeTypes, includeMountFolders);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFolderFinder.filterFindF_FE_FS_ByG_F_S_M_M(groupId, folderId, status, mimeTypes, includeMountFolders, start, end, obc);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, boolean includeMountFolders) throws SystemException {
        return this.dlFolderFinder.filterCountF_FE_FS_ByG_F_S_M_M(groupId, folderId, status, null, includeMountFolders);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws SystemException {
        return this.dlFolderFinder.filterCountF_FE_FS_ByG_F_S_M_M(groupId, folderId, status, mimeTypes, includeMountFolders);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.getFoldersCount(groupId, parentFolderId, true);
    }

    public int getFoldersCount(long groupId, long parentFolderId, boolean includeMountfolders) throws SystemException {
        if (includeMountfolders) {
            return this.dlFolderPersistence.filterCountByG_P(groupId, parentFolderId);
        }
        return this.dlFolderPersistence.filterCountByG_P_M(groupId, parentFolderId, false);
    }

    public List<DLFolder> getMountFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFolderPersistence.filterFindByG_P_M(groupId, parentFolderId, true, start, end, obc);
    }

    public int getMountFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.dlFolderPersistence.filterCountByG_P_M(groupId, parentFolderId, true);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List dlFolders = this.dlFolderPersistence.filterFindByG_P(groupId, folderId);
        for (DLFolder dlFolder : dlFolders) {
            folderIds.add(dlFolder.getFolderId());
            this.getSubfolderIds(folderIds, dlFolder.getGroupId(), dlFolder.getFolderId());
        }
    }

    public List<Long> getSubfolderIds(long groupId, long folderId, boolean recurse) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        this.getSubfolderIds(folderIds, groupId, folderId);
        return folderIds;
    }

    public boolean hasFolderLock(long folderId) throws PortalException, SystemException {
        return this.lockLocalService.hasLock(this.getUserId(), DLFolder.class.getName(), folderId);
    }

    public boolean hasInheritableLock(long folderId) throws PortalException, SystemException {
        boolean inheritable = false;
        try {
            Lock lock = this.lockLocalService.getLock(DLFolder.class.getName(), folderId);
            inheritable = lock.isInheritable();
        }
        catch (ExpiredLockException expiredLockException) {
        }
        catch (NoSuchLockException noSuchLockException) {}
        return inheritable;
    }

    public boolean isFolderLocked(long folderId) throws SystemException {
        return this.lockLocalService.isLocked(DLFolder.class.getName(), folderId);
    }

    public Lock lockFolder(long folderId) throws PortalException, SystemException {
        return this.lockFolder(folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
    }

    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), dlFolder, "UPDATE");
        return this.doLockFolder(folderId, owner, inheritable, expirationTime);
    }

    public DLFolder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), dlFolder, "UPDATE");
        boolean hasLock = this.lockLocalService.hasLock(this.getUserId(), DLFolder.class.getName(), folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(folderId);
        }
        try {
            DLFolder dLFolder = this.dlFolderLocalService.moveFolder(folderId, parentFolderId, serviceContext);
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(dlFolder.getGroupId(), folderId, lock.getUuid());
            }
        }
    }

    public Lock refreshFolderLock(String lockUuid, long expirationTime) throws PortalException, SystemException {
        return this.lockLocalService.refresh(lockUuid, expirationTime);
    }

    public void unlockFolder(long groupId, long folderId, String lockUuid) throws PortalException, SystemException {
        try {
            DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
            DLFolderPermission.check(this.getPermissionChecker(), dlFolder, "UPDATE");
        }
        catch (NoSuchFolderException noSuchFolderException) {}
        this.doUnlockFolder(groupId, folderId, lockUuid);
    }

    public void unlockFolder(long groupId, long parentFolderId, String name, String lockUuid) throws PortalException, SystemException {
        DLFolder dlFolder = this.getFolder(groupId, parentFolderId, name);
        this.unlockFolder(groupId, dlFolder.getFolderId(), lockUuid);
    }

    public DLFolder updateFolder(long folderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), folderId, "UPDATE");
        boolean hasLock = this.lockLocalService.hasLock(this.getUserId(), DLFolder.class.getName(), folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.doLockFolder(folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
        }
        try {
            DLFolder dLFolder = this.dlFolderLocalService.updateFolder(folderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, overrideFileEntryTypes, serviceContext);
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(serviceContext.getScopeGroupId(), folderId, lock.getUuid());
            }
        }
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException, SystemException {
        boolean verified = false;
        try {
            Lock lock = this.lockLocalService.getLock(DLFolder.class.getName(), folderId);
            if (!lock.isInheritable()) {
                throw new NoSuchLockException();
            }
            if (lock.getUuid().equals(lockUuid)) {
                verified = true;
            }
        }
        catch (ExpiredLockException ele) {
            throw new NoSuchLockException((Throwable)ele);
        }
        return verified;
    }

    protected Lock doLockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException, SystemException {
        if (expirationTime <= 0L || expirationTime > DLFolderImpl.LOCK_EXPIRATION_TIME) {
            expirationTime = DLFolderImpl.LOCK_EXPIRATION_TIME;
        }
        return this.lockLocalService.lock(this.getUserId(), DLFolder.class.getName(), folderId, owner, inheritable, expirationTime);
    }

    protected void doUnlockFolder(long groupId, long folderId, String lockUuid) throws PortalException, SystemException {
        block4: {
            if (Validator.isNotNull((String)lockUuid)) {
                try {
                    Lock lock = this.lockLocalService.getLock(DLFolder.class.getName(), folderId);
                    if (!lockUuid.equals(lock.getUuid())) {
                        throw new InvalidLockException("UUIDs do not match");
                    }
                }
                catch (PortalException pe) {
                    if (pe instanceof ExpiredLockException || pe instanceof NoSuchLockException) break block4;
                    throw pe;
                }
            }
        }
        this.lockLocalService.unlock(DLFolder.class.getName(), folderId);
    }
}

