/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileEntryTypeException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.NoSuchMetadataSetException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryTypeLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.StructureXsdException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileEntryTypeLocalServiceImpl
extends DLFileEntryTypeLocalServiceBaseImpl {
    public DLFileEntryType addFileEntryType(long userId, long groupId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long fileEntryTypeId = this.counterLocalService.increment();
        long dynamicStructureId = this.updateDynamicStructure(userId, fileEntryTypeId, groupId, name, description, serviceContext);
        if (dynamicStructureId > 0L) {
            ddmStructureIds = ArrayUtil.append((long[])ddmStructureIds, (long)dynamicStructureId);
        }
        Date now = new Date();
        this.validate(fileEntryTypeId, groupId, name, ddmStructureIds);
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.create(fileEntryTypeId);
        dlFileEntryType.setUuid(serviceContext.getUuid());
        dlFileEntryType.setGroupId(groupId);
        dlFileEntryType.setCompanyId(user.getCompanyId());
        dlFileEntryType.setUserId(user.getUserId());
        dlFileEntryType.setUserName(user.getFullName());
        dlFileEntryType.setCreateDate(serviceContext.getCreateDate(now));
        dlFileEntryType.setModifiedDate(serviceContext.getModifiedDate(now));
        dlFileEntryType.setName(name);
        dlFileEntryType.setDescription(description);
        this.dlFileEntryTypePersistence.update((BaseModel)dlFileEntryType, false);
        this.dlFileEntryTypePersistence.addDDMStructures(fileEntryTypeId, ddmStructureIds);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFileEntryTypeResources(dlFileEntryType, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addFileEntryTypeResources(dlFileEntryType, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return dlFileEntryType;
    }

    public void cascadeFileEntryTypes(long userId, DLFolder dlFolder) throws PortalException, SystemException {
        List<DLFileEntryType> dlFileEntryTypes = this.getFolderFileEntryTypes(new long[]{dlFolder.getGroupId()}, dlFolder.getFolderId(), true);
        List<Long> fileEntryTypeIds = this.getFileEntryTypeIds(dlFileEntryTypes);
        long defaultFileEntryTypeId = this.getDefaultFileEntryTypeId(dlFolder.getFolderId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(dlFolder.getCompanyId());
        serviceContext.setScopeGroupId(dlFolder.getGroupId());
        serviceContext.setUserId(userId);
        this.cascadeFileEntryTypes(dlFolder.getGroupId(), dlFolder.getFolderId(), defaultFileEntryTypeId, fileEntryTypeIds, serviceContext);
    }

    public void deleteFileEntryType(DLFileEntryType dlFileEntryType) throws PortalException, SystemException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(dlFileEntryType.getGroupId(), "auto_" + dlFileEntryType.getFileEntryTypeId());
        if (ddmStructure != null) {
            this.ddmStructureLocalService.deleteStructure(ddmStructure.getStructureId());
        }
        this.dlFileEntryTypePersistence.remove((BaseModel)dlFileEntryType);
    }

    public void deleteFileEntryType(long fileEntryTypeId) throws PortalException, SystemException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.findByPrimaryKey(fileEntryTypeId);
        this.deleteFileEntryType(dlFileEntryType);
    }

    public void deleteFileEntryTypes(long groupId) throws PortalException, SystemException {
        List dlFileEntryTypes = this.dlFileEntryTypePersistence.findByGroupId(groupId);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            this.deleteFileEntryType(dlFileEntryType);
        }
    }

    public DLFileEntryType fetchFileEntryType(long fileEntryTypeId) throws SystemException {
        return this.dlFileEntryTypePersistence.fetchByPrimaryKey(fileEntryTypeId);
    }

    public long getDefaultFileEntryTypeId(long folderId) throws PortalException, SystemException {
        if ((folderId = this.getFileEntryTypesPrimaryFolderId(folderId)) != 0L) {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            return dlFolder.getDefaultFileEntryTypeId();
        }
        return 0L;
    }

    public DLFileEntryType getFileEntryType(long fileEntryTypeId) throws PortalException, SystemException {
        return this.dlFileEntryTypePersistence.findByPrimaryKey(fileEntryTypeId);
    }

    public DLFileEntryType getFileEntryType(long groupId, String name) throws PortalException, SystemException {
        return this.dlFileEntryTypePersistence.findByG_N(groupId, name);
    }

    public List<DLFileEntryType> getFileEntryTypes(long[] groupIds) throws SystemException {
        return this.dlFileEntryTypePersistence.findByGroupId(groupIds);
    }

    public List<DLFileEntryType> getFolderFileEntryTypes(long[] groupIds, long folderId, boolean inherited) throws PortalException, SystemException {
        if (!inherited) {
            return this.dlFolderPersistence.getDLFileEntryTypes(folderId);
        }
        ArrayList<DLFileEntryType> dlFileEntryTypes = null;
        if ((folderId = this.getFileEntryTypesPrimaryFolderId(folderId)) != 0L) {
            dlFileEntryTypes = this.dlFolderPersistence.getDLFileEntryTypes(folderId);
        }
        if (dlFileEntryTypes == null || dlFileEntryTypes.isEmpty()) {
            dlFileEntryTypes = new ArrayList<DLFileEntryType>(this.getFileEntryTypes(groupIds));
            DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.fetchByPrimaryKey(0L);
            dlFileEntryTypes.add(0, dlFileEntryType);
        }
        return dlFileEntryTypes;
    }

    public List<DLFileEntryType> search(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.dlFileEntryTypeFinder.findByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType) throws SystemException {
        return this.dlFileEntryTypeFinder.countByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType);
    }

    public void unsetFolderFileEntryTypes(long folderId) throws SystemException {
        List dlFileEntryTypes = this.dlFolderPersistence.getDLFileEntryTypes(folderId);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            this.dlFolderPersistence.removeDLFileEntryType(folderId, dlFileEntryType);
        }
    }

    public DLFileEntry updateFileEntryFileEntryType(DLFileEntry dlFileEntry, ServiceContext serviceContext) throws PortalException, SystemException {
        List<DLFileEntryType> dlFileEntryTypes;
        List<Long> fileEntryTypeIds;
        long groupId = serviceContext.getScopeGroupId();
        long folderId = 0L;
        DLFolder dlFolder = this.dlFolderPersistence.fetchByPrimaryKey(dlFileEntry.getFolderId());
        if (dlFolder != null) {
            groupId = dlFolder.getGroupId();
            folderId = dlFolder.getFolderId();
        }
        if ((fileEntryTypeIds = this.getFileEntryTypeIds(dlFileEntryTypes = this.getFolderFileEntryTypes(DLUtil.getGroupIds((long)groupId), folderId, true))).contains(dlFileEntry.getFileEntryTypeId())) {
            return dlFileEntry;
        }
        long defaultFileEntryTypeId = this.getDefaultFileEntryTypeId(folderId);
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(dlFileEntry.getFileEntryId(), true);
        if (dlFileVersion.isPending()) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(dlFileVersion.getCompanyId(), dlFileEntry.getGroupId(), DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
        }
        return this.dlFileEntryLocalService.updateFileEntry(serviceContext.getUserId(), dlFileEntry.getFileEntryId(), null, null, null, null, null, false, defaultFileEntryTypeId, null, null, null, 0L, serviceContext);
    }

    public void updateFileEntryType(long userId, long fileEntryTypeId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.findByPrimaryKey(fileEntryTypeId);
        long dynamicStructureId = this.updateDynamicStructure(userId, fileEntryTypeId, dlFileEntryType.getGroupId(), name, description, serviceContext);
        if (dynamicStructureId > 0L) {
            ddmStructureIds = ArrayUtil.append((long[])ddmStructureIds, (long)dynamicStructureId);
        }
        this.validate(fileEntryTypeId, dlFileEntryType.getGroupId(), name, ddmStructureIds);
        dlFileEntryType.setModifiedDate(serviceContext.getModifiedDate(null));
        dlFileEntryType.setName(name);
        dlFileEntryType.setDescription(description);
        this.dlFileEntryTypePersistence.update((BaseModel)dlFileEntryType, false);
        this.dlFileEntryTypePersistence.setDDMStructures(fileEntryTypeId, ddmStructureIds);
    }

    public void updateFolderFileEntryTypes(DLFolder dlFolder, List<Long> fileEntryTypeIds, long defaultFileEntryTypeId, ServiceContext serviceContext) throws PortalException, SystemException {
        List<Long> originalFileEntryTypeIds = this.getFileEntryTypeIds(this.dlFolderPersistence.getDLFileEntryTypes(dlFolder.getFolderId()));
        if (fileEntryTypeIds.equals(originalFileEntryTypeIds)) {
            return;
        }
        for (Long fileEntryTypeId : fileEntryTypeIds) {
            if (originalFileEntryTypeIds.contains(fileEntryTypeId)) continue;
            this.dlFolderPersistence.addDLFileEntryType(dlFolder.getFolderId(), fileEntryTypeId.longValue());
        }
        for (Long originalFileEntryTypeId : originalFileEntryTypeIds) {
            if (fileEntryTypeIds.contains(originalFileEntryTypeId)) continue;
            this.dlFolderPersistence.removeDLFileEntryType(dlFolder.getFolderId(), originalFileEntryTypeId.longValue());
            this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(dlFolder.getCompanyId(), dlFolder.getGroupId(), DLFolder.class.getName(), dlFolder.getFolderId(), originalFileEntryTypeId.longValue());
        }
    }

    protected void addFileEntryTypeResources(DLFileEntryType dlFileEntryType, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(dlFileEntryType.getCompanyId(), dlFileEntryType.getGroupId(), dlFileEntryType.getUserId(), DLFileEntryType.class.getName(), dlFileEntryType.getFileEntryTypeId(), false, addGroupPermissions, addGuestPermissions);
    }

    protected void addFileEntryTypeResources(DLFileEntryType dlFileEntryType, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(dlFileEntryType.getCompanyId(), dlFileEntryType.getGroupId(), dlFileEntryType.getUserId(), DLFileEntryType.class.getName(), dlFileEntryType.getFileEntryTypeId(), groupPermissions, guestPermissions);
    }

    protected void cascadeFileEntryTypes(long groupId, long folderId, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, ServiceContext serviceContext) throws PortalException, SystemException {
        List dlFileEntries = this.dlFileEntryPersistence.findByG_F(groupId, folderId);
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            Long fileEntryTypeId = dlFileEntry.getFileEntryTypeId();
            if (fileEntryTypeIds.contains(fileEntryTypeId)) continue;
            DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(dlFileEntry.getFileEntryId(), true);
            if (dlFileVersion.isPending()) {
                this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(dlFileVersion.getCompanyId(), groupId, DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
            }
            this.dlFileEntryService.updateFileEntry(dlFileEntry.getFileEntryId(), null, null, null, null, null, false, defaultFileEntryTypeId, null, null, null, 0L, serviceContext);
        }
        List subFolders = this.dlFolderPersistence.findByG_P_M(groupId, folderId, false);
        for (DLFolder subFolder : subFolders) {
            long subFolderId = subFolder.getFolderId();
            if (subFolder.isOverrideFileEntryTypes()) continue;
            this.cascadeFileEntryTypes(groupId, subFolderId, defaultFileEntryTypeId, fileEntryTypeIds, serviceContext);
        }
    }

    protected List<Long> getFileEntryTypeIds(List<DLFileEntryType> dlFileEntryTypes) {
        SortedArrayList fileEntryTypeIds = new SortedArrayList();
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            fileEntryTypeIds.add(dlFileEntryType.getFileEntryTypeId());
        }
        return fileEntryTypeIds;
    }

    protected long getFileEntryTypesPrimaryFolderId(long folderId) throws SystemException, NoSuchFolderException {
        while (folderId != 0L) {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            if (dlFolder.isOverrideFileEntryTypes()) break;
            folderId = dlFolder.getParentFolderId();
        }
        return folderId;
    }

    protected long updateDynamicStructure(long userId, long fileEntryTypeId, long groupId, String name, String description, ServiceContext serviceContext) throws SystemException, PortalException {
        String ddmStructureKey = "auto_" + fileEntryTypeId;
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        Locale locale = serviceContext.getLocale();
        nameMap.put(locale, name);
        Locale defaultLocale = LocaleUtil.getDefault();
        nameMap.put(defaultLocale, name);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, description);
        descriptionMap.put(defaultLocale, description);
        String xsd = ParamUtil.getString((ServiceContext)serviceContext, (String)"xsd");
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(groupId, ddmStructureKey);
        try {
            ddmStructure = ddmStructure == null ? this.ddmStructureLocalService.addStructure(userId, groupId, PortalUtil.getClassNameId(DLFileEntryMetadata.class), ddmStructureKey, nameMap, descriptionMap, xsd, "xml", 1, serviceContext) : this.ddmStructureLocalService.updateStructure(ddmStructure.getStructureId(), nameMap, descriptionMap, xsd, serviceContext);
            return ddmStructure.getStructureId();
        }
        catch (StructureXsdException structureXsdException) {
            if (ddmStructure != null) {
                this.ddmStructureLocalService.deleteStructure(ddmStructure.getStructureId());
            }
            return 0L;
        }
    }

    protected void validate(long fileEntryTypeId, long groupId, String fileEntryTypeName, long[] ddmStructureIds) throws PortalException, SystemException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.fetchByG_N(groupId, fileEntryTypeName);
        if (dlFileEntryType != null && dlFileEntryType.getFileEntryTypeId() != fileEntryTypeId) {
            throw new DuplicateFileEntryTypeException(fileEntryTypeName);
        }
        if (ddmStructureIds.length == 0) {
            throw new NoSuchMetadataSetException();
        }
        long[] lArray = ddmStructureIds;
        int n = ddmStructureIds.length;
        int n2 = 0;
        while (n2 < n) {
            long ddmStructureId = lArray[n2];
            DDMStructure ddmStructure = this.ddmStructurePersistence.fetchByPrimaryKey(ddmStructureId);
            if (ddmStructure == null) {
                throw new NoSuchMetadataSetException();
            }
            ++n2;
        }
    }
}

