/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Repository;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.base.DLAppLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLProcessorRegistryUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLAppLocalServiceImpl
extends DLAppLocalServiceBaseImpl {
    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (bytes != null && bytes.length > 0) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.addFileEntry(userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        }
        catch (IOException ioe) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.addFileEntry(userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, null, 0L, serviceContext);
        }
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        FileEntry fileEntry = localRepository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        this.dlAppHelperLocalService.addFileEntry(userId, fileEntry, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        if (is == null) {
            is = new UnsyncByteArrayInputStream(new byte[0]);
            size = 0L;
        }
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        FileEntry fileEntry = localRepository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
        this.dlAppHelperLocalService.addFileEntry(userId, fileEntry, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public DLFileRank addFileRank(long repositoryId, long companyId, long userId, long fileEntryId, ServiceContext serviceContext) throws SystemException {
        return this.dlFileRankLocalService.addFileRank(repositoryId, companyId, userId, fileEntryId, serviceContext);
    }

    public DLFileShortcut addFileShortcut(long userId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.dlFileShortcutLocalService.addFileShortcut(userId, repositoryId, folderId, toFileEntryId, serviceContext);
    }

    public Folder addFolder(long userId, long repositoryId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.addFolder(userId, parentFolderId, name, description, serviceContext);
    }

    public void deleteAll(long repositoryId) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        localRepository.deleteAll();
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(0L, fileEntryId, 0L);
        FileEntry fileEntry = localRepository.getFileEntry(fileEntryId);
        localRepository.deleteFileEntry(fileEntryId);
        this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
    }

    public void deleteFileRanksByFileEntryId(long fileEntryId) throws SystemException {
        this.dlFileRankLocalService.deleteFileRanksByFileEntryId(fileEntryId);
    }

    public void deleteFileRanksByUserId(long userId) throws SystemException {
        this.dlFileRankLocalService.deleteFileRanksByUserId(userId);
    }

    public void deleteFileShortcut(DLFileShortcut dlFileShortcut) throws PortalException, SystemException {
        this.dlFileShortcutLocalService.deleteFileShortcut(dlFileShortcut);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        this.dlFileShortcutLocalService.deleteDLFileShortcut(fileShortcutId);
    }

    public void deleteFileShortcuts(long toFileEntryId) throws PortalException, SystemException {
        this.dlFileShortcutLocalService.deleteFileShortcuts(toFileEntryId);
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(folderId, 0L, 0L);
        localRepository.deleteFolder(folderId);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId) throws PortalException, SystemException {
        return this.getFileEntries(repositoryId, folderId, -1, -1);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, int start, int end) throws PortalException, SystemException {
        return this.getFileEntries(repositoryId, folderId, start, end, null);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getFileEntries(folderId, start, end, obc);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, int start, int end) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getFileEntriesAndFileShortcuts(folderId, status, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getFileEntriesAndFileShortcutsCount(folderId, status);
    }

    public int getFileEntriesCount(long repositoryId, long folderId) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getFileEntriesCount(folderId);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(0L, fileEntryId, 0L);
        return localRepository.getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long groupId, long folderId, String title) throws PortalException, SystemException {
        try {
            LocalRepository localRepository = this.getLocalRepository(groupId);
            return localRepository.getFileEntry(folderId, title);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            LocalRepository localRepository = this.getLocalRepository(folderId, 0L, 0L);
            return localRepository.getFileEntry(folderId, title);
        }
    }

    /*
     * Unable to fully structure code
     */
    public FileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException, SystemException {
        try {
            localRepository = this.getLocalRepository(groupId);
            return localRepository.getFileEntryByUuid(uuid);
        }
        catch (NoSuchFileEntryException v0) {
            repositories = this.repositoryPersistence.findByGroupId(groupId);
            i = 0;
            ** while (i < repositories.size())
        }
lbl-1000:
        // 1 sources

        {
            try {
                repositoryId = ((Repository)repositories.get(i)).getRepositoryId();
                localRepository = this.getLocalRepository(repositoryId);
                return localRepository.getFileEntryByUuid(uuid);
            }
            catch (NoSuchFileEntryException v1) {
                ++i;
            }
            continue;
        }
lbl15:
        // 1 sources

        msg = new StringBundler(6);
        msg.append("No DLFileEntry exists with the key {");
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchFileEntryException(msg.toString());
    }

    public List<DLFileRank> getFileRanks(long repositoryId, long userId) throws SystemException {
        return this.dlFileRankLocalService.getFileRanks(repositoryId, userId);
    }

    public DLFileShortcut getFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        return this.dlFileShortcutLocalService.getFileShortcut(fileShortcutId);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(0L, 0L, fileVersionId);
        return localRepository.getFileVersion(fileVersionId);
    }

    public Folder getFolder(long folderId) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(folderId, 0L, 0L);
        return localRepository.getFolder(folderId);
    }

    public Folder getFolder(long repositoryId, long parentFolderId, String name) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getFolder(parentFolderId, name);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId) throws PortalException, SystemException {
        return this.getFolders(repositoryId, parentFolderId, true);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders) throws PortalException, SystemException {
        return this.getFolders(repositoryId, parentFolderId, includeMountFolders, -1, -1);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders, int start, int end) throws PortalException, SystemException {
        return this.getFolders(repositoryId, parentFolderId, includeMountFolders, -1, -1, null);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getFolders(parentFolderId, includeMountFolders, start, end, obc);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, int start, int end) throws PortalException, SystemException {
        return this.getFolders(repositoryId, parentFolderId, true, start, end);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.getFolders(repositoryId, parentFolderId, true, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.getFoldersAndFileEntriesAndFileShortcuts(repositoryId, folderId, status, null, includeMountFolders, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, mimeTypes, includeMountFolders, start, end, obc);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, boolean includeMountFolders) throws PortalException, SystemException {
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(repositoryId, folderId, status, null, includeMountFolders);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes, includeMountFolders);
    }

    public int getFoldersCount(long repositoryId, long parentFolderId) throws PortalException, SystemException {
        return this.getFoldersCount(repositoryId, parentFolderId, true);
    }

    public int getFoldersCount(long repositoryId, long parentFolderId, boolean includeMountFolders) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getFoldersCount(parentFolderId, includeMountFolders);
    }

    public int getFoldersFileEntriesCount(long repositoryId, List<Long> folderIds, int status) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getFoldersFileEntriesCount(folderIds, status);
    }

    public Folder getMountFolder(long repositoryId) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderLocalService.getMountFolder(repositoryId);
        return new LiferayFolder(dlFolder);
    }

    public List<Folder> getMountFolders(long repositoryId, long parentFolderId) throws PortalException, SystemException {
        return this.getMountFolders(repositoryId, parentFolderId, -1, -1);
    }

    public List<Folder> getMountFolders(long repositoryId, long parentFolderId, int start, int end) throws PortalException, SystemException {
        return this.getMountFolders(repositoryId, parentFolderId, start, end, null);
    }

    public List<Folder> getMountFolders(long repositoryId, long parentFolderId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getMountFolders(parentFolderId, start, end, obc);
    }

    public int getMountFoldersCount(long repositoryId, long parentFolderId) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getMountFoldersCount(parentFolderId);
    }

    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        LocalRepository fromLocalRepository = this.getLocalRepository(0L, fileEntryId, 0L);
        LocalRepository toLocalRepository = this.getLocalRepository(newFolderId, serviceContext);
        if (fromLocalRepository.getRepositoryId() == toLocalRepository.getRepositoryId()) {
            FileEntry fileEntry = fromLocalRepository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
            return fileEntry;
        }
        return this.moveFileEntries(userId, fileEntryId, newFolderId, fromLocalRepository, toLocalRepository, serviceContext);
    }

    public void updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(0L, fileEntry.getFileEntryId(), 0L);
        localRepository.updateAsset(userId, fileEntry, fileVersion, assetCategoryIds, assetTagNames, assetLinkEntryIds);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (bytes != null && bytes.length > 0) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
        }
        catch (IOException ioe) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, null, 0L, serviceContext);
        }
        LocalRepository localRepository = this.getLocalRepository(0L, fileEntryId, 0L);
        FileEntry fileEntry = localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
        DLProcessorRegistryUtil.cleanUp((FileVersion)fileEntry.getLatestFileVersion());
        this.dlAppHelperLocalService.updateFileEntry(userId, fileEntry, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(0L, fileEntryId, 0L);
        FileEntry fileEntry = localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, is, size, serviceContext);
        if (is != null) {
            DLProcessorRegistryUtil.cleanUp((FileVersion)fileEntry.getLatestFileVersion());
        }
        this.dlAppHelperLocalService.updateFileEntry(userId, fileEntry, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public DLFileRank updateFileRank(long repositoryId, long companyId, long userId, long fileEntryId, ServiceContext serviceContext) throws SystemException {
        return this.dlFileRankLocalService.updateFileRank(repositoryId, companyId, userId, fileEntryId, serviceContext);
    }

    public DLFileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.dlFileShortcutLocalService.updateFileShortcut(userId, fileShortcutId, folderId, toFileEntryId, serviceContext);
    }

    public void updateFileShortcuts(long toRepositoryId, long oldToFileEntryId, long newToFileEntryId) throws SystemException {
        this.dlFileShortcutLocalService.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        LocalRepository localRepository = this.getLocalRepository(folderId, 0L, 0L);
        return localRepository.updateFolder(folderId, parentFolderId, name, description, serviceContext);
    }

    protected FileEntry copyFileEntry(long userId, LocalRepository toLocalRepository, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        List fileVersions = fileEntry.getFileVersions(-1);
        FileVersion latestFileVersion = (FileVersion)fileVersions.get(fileVersions.size() - 1);
        FileEntry destinationFileEntry = toLocalRepository.addFileEntry(userId, newFolderId, fileEntry.getTitle(), latestFileVersion.getMimeType(), latestFileVersion.getTitle(), latestFileVersion.getDescription(), "", latestFileVersion.getContentStream(false), latestFileVersion.getSize(), serviceContext);
        int i = fileVersions.size() - 2;
        while (i >= 0) {
            FileVersion fileVersion = (FileVersion)fileVersions.get(i);
            FileVersion previousFileVersion = (FileVersion)fileVersions.get(i + 1);
            try {
                destinationFileEntry = toLocalRepository.updateFileEntry(userId, destinationFileEntry.getFileEntryId(), fileEntry.getTitle(), destinationFileEntry.getMimeType(), destinationFileEntry.getTitle(), destinationFileEntry.getDescription(), "", this.isMajorVersion(fileVersion, previousFileVersion), fileVersion.getContentStream(false), fileVersion.getSize(), serviceContext);
            }
            catch (PortalException pe) {
                toLocalRepository.deleteFileEntry(destinationFileEntry.getFileEntryId());
                throw pe;
            }
            --i;
        }
        this.dlAppHelperLocalService.addFileEntry(userId, destinationFileEntry, destinationFileEntry.getFileVersion(), serviceContext);
        return destinationFileEntry;
    }

    protected void deleteFileEntry(long oldFileEntryId, long newFileEntryId, LocalRepository fromLocalRepository, LocalRepository toLocalRepository) throws PortalException, SystemException {
        try {
            FileEntry fileEntry = fromLocalRepository.getFileEntry(oldFileEntryId);
            fromLocalRepository.deleteFileEntry(oldFileEntryId);
            this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
        }
        catch (PortalException pe) {
            FileEntry fileEntry = toLocalRepository.getFileEntry(newFileEntryId);
            toLocalRepository.deleteFileEntry(newFileEntryId);
            this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
            throw pe;
        }
    }

    protected LocalRepository getLocalRepository(long repositoryId) throws PortalException, SystemException {
        return this.repositoryLocalService.getLocalRepositoryImpl(repositoryId);
    }

    protected LocalRepository getLocalRepository(long folderId, long fileEntryId, long fileVersionId) throws PortalException, SystemException {
        return this.repositoryLocalService.getLocalRepositoryImpl(folderId, fileEntryId, fileVersionId);
    }

    protected LocalRepository getLocalRepository(long folderId, ServiceContext serviceContext) throws PortalException, SystemException {
        LocalRepository localRepository = null;
        localRepository = folderId == 0L ? this.getLocalRepository(serviceContext.getScopeGroupId()) : this.getLocalRepository(folderId, 0L, 0L);
        return localRepository;
    }

    protected boolean isMajorVersion(FileVersion previousFileVersion, FileVersion currentFileVersion) {
        long previousVersion;
        long currentVersion = GetterUtil.getLong((String)currentFileVersion.getVersion());
        return currentVersion - (previousVersion = GetterUtil.getLong((String)previousFileVersion.getVersion())) >= 1L;
    }

    protected FileEntry moveFileEntries(long userId, long fileEntryId, long newFolderId, LocalRepository fromLocalRepository, LocalRepository toLocalRepository, ServiceContext serviceContext) throws SystemException, PortalException {
        FileEntry sourceFileEntry = fromLocalRepository.getFileEntry(fileEntryId);
        FileEntry destinationFileEntry = this.copyFileEntry(userId, toLocalRepository, sourceFileEntry, newFolderId, serviceContext);
        this.deleteFileEntry(fileEntryId, destinationFileEntry.getFileEntryId(), fromLocalRepository, toLocalRepository);
        return destinationFileEntry;
    }
}

