/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.spring.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.NoSuchEntryException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.base.DLAppHelperLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLProcessorRegistryUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLAppHelperLocalServiceImpl
extends DLAppHelperLocalServiceBaseImpl {
    public void addFileEntry(long userId, FileEntry fileEntry, FileVersion fileVersion, ServiceContext serviceContext) throws PortalException, SystemException {
        this.updateAsset(userId, fileEntry, fileVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(fileEntry.getUserId(), fileEntry.getUserName(), fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 1);
        }
        if (fileVersion instanceof LiferayFileVersion) {
            DLFileVersion dlFileVersion = (DLFileVersion)fileVersion.getModel();
            HashMap<String, String> workflowContext = new HashMap<String, String>();
            workflowContext.put("event", "add");
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)dlFileVersion.getCompanyId(), (long)dlFileVersion.getGroupId(), (long)userId, (String)DLFileEntry.class.getName(), (long)dlFileVersion.getFileVersionId(), (Object)dlFileVersion, (ServiceContext)serviceContext, workflowContext);
        }
        this.registerDLProcessorCallback(fileEntry);
    }

    public void addFolder(Folder folder, ServiceContext serviceContext) throws SystemException {
        if (!this.isStagingGroup(folder.getGroupId())) {
            this.dlSyncLocalService.addSync(folder.getFolderId(), folder.getUuid(), folder.getCompanyId(), folder.getRepositoryId(), folder.getParentFolderId(), folder.getName(), "folder", "-1");
        }
    }

    public void checkAssetEntry(long userId, FileEntry fileEntry, FileVersion fileVersion) throws PortalException, SystemException {
        AssetEntry fileVersionAssetEntry;
        AssetEntry fileEntryAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        long[] assetCategoryIds = new long[]{};
        String[] assetTagNames = new String[]{};
        long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
        if (fileEntryAssetEntry == null) {
            fileEntryAssetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, false, null, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
        }
        if ((fileVersionAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId())) == null && !fileVersion.isApproved() && !fileVersion.getVersion().equals("1.0")) {
            assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            assetTagNames = this.assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            fileVersionAssetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, false, null, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
            List assetLinks = this.assetLinkLocalService.getDirectLinks(fileEntryAssetEntry.getEntryId());
            long[] assetLinkIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
            this.assetLinkLocalService.updateLinks(userId, fileVersionAssetEntry.getEntryId(), assetLinkIds, 0);
        }
    }

    public void deleteFileEntry(FileEntry fileEntry) throws PortalException, SystemException {
        DLProcessorRegistryUtil.cleanUp((FileEntry)fileEntry);
        this.dlFileRankLocalService.deleteFileRanksByFileEntryId(fileEntry.getFileEntryId());
        this.dlFileShortcutLocalService.deleteFileShortcuts(fileEntry.getFileEntryId());
        if (!this.isStagingGroup(fileEntry.getGroupId())) {
            this.dlSyncLocalService.updateSync(fileEntry.getFileEntryId(), fileEntry.getFolderId(), fileEntry.getTitle(), "delete", fileEntry.getVersion());
        }
        this.assetEntryLocalService.deleteEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        this.mbMessageLocalService.deleteDiscussionMessages(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        this.ratingsStatsLocalService.deleteStats(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
    }

    public void deleteFolder(Folder folder) throws PortalException, SystemException {
        if (!this.isStagingGroup(folder.getGroupId())) {
            this.dlSyncLocalService.updateSync(folder.getFolderId(), folder.getParentFolderId(), folder.getName(), "delete", "-1");
        }
    }

    public void getFileAsStream(long userId, FileEntry fileEntry, boolean incrementCounter) throws SystemException {
        if (userId > 0L && incrementCounter) {
            this.dlFileRankLocalService.updateFileRank(fileEntry.getGroupId(), fileEntry.getCompanyId(), userId, fileEntry.getFileEntryId(), new ServiceContext());
        }
        if (PropsValues.DL_FILE_ENTRY_READ_COUNT_ENABLED && incrementCounter) {
            this.assetEntryLocalService.incrementViewCounter(userId, DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 1);
            List fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(fileEntry.getFileEntryId());
            for (DLFileShortcut fileShortcut : fileShortcuts) {
                this.assetEntryLocalService.incrementViewCounter(userId, DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), 1);
            }
        }
    }

    public List<DLFileShortcut> getFileShortcuts(long groupId, long folderId, int status) throws SystemException {
        return this.dlFileShortcutPersistence.findByG_F_S(groupId, folderId, status);
    }

    public int getFileShortcutsCount(long groupId, long folderId, int status) throws SystemException {
        return this.dlFileShortcutPersistence.countByG_F_S(groupId, folderId, status);
    }

    public List<FileEntry> getNoAssetFileEntries() {
        return null;
    }

    public void moveFileEntry(FileEntry fileEntry) throws PortalException, SystemException {
        this.dlSyncLocalService.updateSync(fileEntry.getFileEntryId(), fileEntry.getFolderId(), fileEntry.getTitle(), "update", fileEntry.getVersion());
    }

    public void moveFolder(Folder folder) throws PortalException, SystemException {
        this.dlSyncLocalService.updateSync(folder.getFolderId(), folder.getParentFolderId(), folder.getName(), "update", "-1");
    }

    public AssetEntry updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long assetClassPk) throws PortalException, SystemException {
        long[] assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), assetClassPk);
        String[] assetTagNames = this.assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), assetClassPk);
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), assetClassPk);
        List assetLinks = this.assetLinkLocalService.getDirectLinks(assetEntry.getEntryId());
        long[] assetLinkIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
        return this.updateAsset(userId, fileEntry, fileVersion, assetCategoryIds, assetTagNames, assetLinkIds);
    }

    public AssetEntry updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        AssetEntry assetEntry = null;
        boolean visible = false;
        boolean addDraftAssetEntry = false;
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileVersion dlFileVersion = (DLFileVersion)fileVersion.getModel();
            if (dlFileVersion.isApproved()) {
                visible = true;
            } else {
                String version = dlFileVersion.getVersion();
                if (!version.equals("1.0")) {
                    addDraftAssetEntry = true;
                }
            }
        } else {
            visible = true;
        }
        long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
        if (addDraftAssetEntry) {
            assetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, false, null, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
        } else {
            assetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, visible, null, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
            List dlFileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(fileEntry.getFileEntryId());
            for (DLFileShortcut dlFileShortcut : dlFileShortcuts) {
                this.assetEntryLocalService.updateEntry(userId, dlFileShortcut.getGroupId(), DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), dlFileShortcut.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, null, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
            }
        }
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
        return assetEntry;
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, FileVersion fileVersion, long assetClassPk) throws PortalException, SystemException {
        boolean updateAsset = true;
        if (fileEntry instanceof LiferayFileEntry && fileEntry.getVersion().equals(fileVersion.getVersion())) {
            updateAsset = false;
        }
        if (updateAsset) {
            this.updateAsset(userId, fileEntry, fileVersion, assetClassPk);
        }
        this.registerDLProcessorCallback(fileEntry);
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, FileVersion fileVersion, ServiceContext serviceContext) throws PortalException, SystemException {
        this.updateAsset(userId, fileEntry, fileVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this.registerDLProcessorCallback(fileEntry);
    }

    public void updateFolder(Folder folder, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!this.isStagingGroup(folder.getGroupId())) {
            this.dlSyncLocalService.updateSync(folder.getFolderId(), folder.getParentFolderId(), folder.getName(), "update", "-1");
        }
    }

    public void updateStatus(long userId, FileEntry fileEntry, FileVersion latestFileVersion, int status, Map<String, Serializable> workflowContext) throws PortalException, SystemException {
        if (status == 0) {
            String latestFileVersionVersion = latestFileVersion.getVersion();
            if (latestFileVersionVersion.equals(fileEntry.getVersion())) {
                if (!latestFileVersionVersion.equals("1.0")) {
                    AssetEntry draftAssetEntry = null;
                    try {
                        long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
                        draftAssetEntry = this.assetEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), latestFileVersion.getPrimaryKey());
                        long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                        String[] assetTagNames = draftAssetEntry.getTagNames();
                        List assetLinks = this.assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0);
                        long[] assetLinkEntryIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
                        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, null, null, null, null, draftAssetEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
                        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
                        this.assetEntryLocalService.deleteEntry(draftAssetEntry.getEntryId());
                    }
                    catch (NoSuchEntryException noSuchEntryException) {}
                }
                this.assetEntryLocalService.updateVisible(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), true);
            }
            String event = (String)((Object)workflowContext.get("event"));
            if (!this.isStagingGroup(fileEntry.getGroupId()) && Validator.isNotNull((String)event)) {
                if (event.equals("add")) {
                    this.dlSyncLocalService.addSync(fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntry.getCompanyId(), fileEntry.getRepositoryId(), fileEntry.getFolderId(), fileEntry.getTitle(), "file", fileEntry.getVersion());
                } else if (event.equals("update")) {
                    this.dlSyncLocalService.updateSync(fileEntry.getFileEntryId(), fileEntry.getFolderId(), fileEntry.getTitle(), "update", fileEntry.getVersion());
                }
            }
            int activityType = 2;
            if (latestFileVersionVersion.equals("1.0")) {
                activityType = 1;
            }
            this.socialActivityLocalService.addUniqueActivity(latestFileVersion.getStatusByUserId(), fileEntry.getGroupId(), latestFileVersion.getCreateDate(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), activityType, "", 0L);
        } else if (Validator.isNull((String)fileEntry.getVersion())) {
            this.assetEntryLocalService.updateVisible(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), false);
        }
    }

    protected long getFileEntryTypeId(FileEntry fileEntry) {
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
            return dlFileEntry.getFileEntryTypeId();
        }
        return 0L;
    }

    protected boolean isStagingGroup(long groupId) {
        try {
            Group group = this.groupLocalService.getGroup(groupId);
            return group.isStagingGroup();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void registerDLProcessorCallback(final FileEntry fileEntry) {
        TransactionCommitCallbackUtil.registerCallback(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DLProcessorRegistryUtil.trigger((FileEntry)fileEntry);
                return null;
            }
        });
    }
}

