/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryBaseImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileEntryImpl
extends DLFileEntryBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryImpl.class);
    private UnicodeProperties _extraSettingsProperties;
    private DLFileVersion _dlFileVersion;

    public InputStream getContentStream() throws PortalException, SystemException {
        return this.getContentStream(this.getVersion());
    }

    public InputStream getContentStream(String version) throws PortalException, SystemException {
        return DLFileEntryServiceUtil.getFileAsStream((long)this.getFileEntryId(), (String)version);
    }

    public long getDataRepositoryId() {
        return DLFolderConstants.getDataRepositoryId((long)this.getGroupId(), (long)this.getFolderId());
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        try {
            DLFileVersion dlFileVersion = this.getFileVersion();
            return dlFileVersion.getExpandoBridge();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    @Override
    public String getExtraSettings() {
        if (this._extraSettingsProperties == null) {
            return super.getExtraSettings();
        }
        return this._extraSettingsProperties.toString();
    }

    public UnicodeProperties getExtraSettingsProperties() {
        if (this._extraSettingsProperties == null) {
            this._extraSettingsProperties = new UnicodeProperties(true);
            try {
                this._extraSettingsProperties.load(super.getExtraSettings());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return this._extraSettingsProperties;
    }

    public Map<String, Fields> getFieldsMap(long fileVersionId) throws PortalException, SystemException {
        HashMap<String, Fields> fieldsMap = new HashMap<String, Fields>();
        DLFileVersion dlFileVersion = DLFileVersionLocalServiceUtil.getFileVersion((long)fileVersionId);
        long fileEntryTypeId = dlFileVersion.getFileEntryTypeId();
        if (fileEntryTypeId <= 0L) {
            return fieldsMap;
        }
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)fileEntryTypeId);
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.getFileEntryMetadata((long)ddmStructure.getStructureId(), (long)fileVersionId);
            Fields fields = StorageEngineUtil.getFields((long)dlFileEntryMetadata.getDDMStorageId());
            fieldsMap.put(ddmStructure.getStructureKey(), fields);
        }
        return fieldsMap;
    }

    public DLFileVersion getFileVersion() throws PortalException, SystemException {
        if (this._dlFileVersion == null) {
            this._dlFileVersion = this.getFileVersion(this.getVersion());
        }
        return this._dlFileVersion;
    }

    public DLFileVersion getFileVersion(String version) throws PortalException, SystemException {
        return DLFileVersionLocalServiceUtil.getFileVersion((long)this.getFileEntryId(), (String)version);
    }

    public List<DLFileVersion> getFileVersions(int status) throws SystemException {
        return DLFileVersionLocalServiceUtil.getFileVersions((long)this.getFileEntryId(), (int)status);
    }

    public DLFolder getFolder() {
        DLFolderImpl dlFolder = null;
        if (this.getFolderId() > 0L) {
            try {
                dlFolder = DLFolderLocalServiceUtil.getFolder((long)this.getFolderId());
            }
            catch (Exception e) {
                dlFolder = new DLFolderImpl();
                _log.error((Object)e, (Throwable)e);
            }
        } else {
            dlFolder = new DLFolderImpl();
        }
        return dlFolder;
    }

    public String getIcon() {
        return DLUtil.getFileIcon((String)this.getExtension());
    }

    public DLFileVersion getLatestFileVersion(boolean trusted) throws PortalException, SystemException {
        if (trusted) {
            return DLFileVersionLocalServiceUtil.getLatestFileVersion((long)this.getFileEntryId(), (boolean)true);
        }
        return DLFileVersionServiceUtil.getLatestFileVersion((long)this.getFileEntryId());
    }

    public Lock getLock() {
        try {
            return LockLocalServiceUtil.getLock((String)DLFileEntry.class.getName(), (long)this.getFileEntryId());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLuceneProperties() {
        UnicodeProperties extraSettingsProps = this.getExtraSettingsProperties();
        Iterator itr = extraSettingsProps.entrySet().iterator();
        StringBundler sb = new StringBundler(extraSettingsProps.entrySet().size() + 4);
        sb.append(FileUtil.stripExtension((String)this.getTitle()));
        sb.append(" ");
        sb.append(this.getDescription());
        sb.append(" ");
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            String value = GetterUtil.getString((String)((String)entry.getValue()));
            sb.append(value);
        }
        return sb.toString();
    }

    public boolean hasLock() {
        try {
            return DLFileEntryServiceUtil.hasFileEntryLock((long)this.getFileEntryId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isCheckedOut() {
        try {
            return DLFileEntryServiceUtil.isFileEntryCheckedOut((long)this.getFileEntryId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void setExtraSettings(String extraSettings) {
        this._extraSettingsProperties = null;
        super.setExtraSettings(extraSettings);
    }

    public void setExtraSettingsProperties(UnicodeProperties extraSettingsProperties) {
        this._extraSettingsProperties = extraSettingsProperties;
        super.setExtraSettings(this._extraSettingsProperties.toString());
    }

    public void setFileVersion(DLFileVersion dlFileVersion) {
        this._dlFileVersion = dlFileVersion;
    }
}

