/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Repository;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RepositoryLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.RepositoryUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.portlet.documentlibrary.lar.FolderUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryTypeUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileRankUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileShortcutUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.lar.DDMPortletDataHandlerImpl;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStructureUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.util.PwdGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DLPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "document_library";
    private static Log _log = LogFactoryUtil.getLog(DLPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("document_library", "categories");
    private static PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("document_library", "comments");
    private static PortletDataHandlerBoolean _foldersAndDocuments = new PortletDataHandlerBoolean("document_library", "folders-and-documents", true, true);
    private static PortletDataHandlerBoolean _ranks = new PortletDataHandlerBoolean("document_library", "ranks");
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("document_library", "ratings");
    private static PortletDataHandlerBoolean _repositories = new PortletDataHandlerBoolean("document_library", "repositories", false, false);
    private static PortletDataHandlerBoolean _shortcuts = new PortletDataHandlerBoolean("document_library", "shortcuts");
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("document_library", "tags");

    public static void exportFileEntry(PortletDataContext portletDataContext, Element fileEntryTypesElement, Element foldersElement, Element fileEntriesElement, Element fileRanksElement, FileEntry fileEntry, boolean checkDateRange) throws Exception {
        if (checkDateRange && !portletDataContext.isWithinDateRange(fileEntry.getModifiedDate())) {
            return;
        }
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (fileVersion.getStatus() != 0) {
            return;
        }
        String path = DLPortletDataHandlerImpl.getFileEntryPath(portletDataContext, fileEntry);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element fileEntryElement = fileEntriesElement.addElement("file-entry");
        if (foldersElement != null) {
            DLPortletDataHandlerImpl.exportParentFolder(portletDataContext, fileEntryTypesElement, foldersElement, fileEntry.getFolderId());
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            String binPath = DLPortletDataHandlerImpl.getFileEntryBinPath(portletDataContext, fileEntry);
            fileEntryElement.addAttribute("bin-path", binPath);
            InputStream is = null;
            try {
                is = FileEntryUtil.getContentStream(fileEntry);
            }
            catch (NoSuchFileException noSuchFileException) {}
            if (is == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No file found for file entry " + fileEntry.getFileEntryId()));
                }
                fileEntryElement.detach();
                return;
            }
            try {
                portletDataContext.addZipEntry(binPath, is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    _log.error((Object)ioe, (Throwable)ioe);
                }
            }
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "ranks")) {
            List fileRanks = DLFileRankUtil.findByFileEntryId((long)fileEntry.getFileEntryId());
            for (DLFileRank fileRank : fileRanks) {
                DLPortletDataHandlerImpl.exportFileRank(portletDataContext, fileRanksElement, fileRank);
            }
        }
        DLPortletDataHandlerImpl.exportMetaData(portletDataContext, fileEntryTypesElement, fileEntryElement, fileEntry);
        portletDataContext.addClassedModel(fileEntryElement, path, (ClassedModel)fileEntry, _NAMESPACE);
    }

    public static String getFileEntryPath(PortletDataContext portletDataContext, FileEntry fileEntry) {
        StringBundler sb = new StringBundler(6);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/file-entries/");
        sb.append(fileEntry.getFileEntryId());
        sb.append("/");
        sb.append(fileEntry.getVersion());
        sb.append(".xml");
        return sb.toString();
    }

    public static void importFileEntry(PortletDataContext portletDataContext, Element fileEntryElement) throws Exception {
        String path = fileEntryElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        FileEntry fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
        long userId = portletDataContext.getUserId(fileEntry.getUserUuid());
        Map folderPKs = portletDataContext.getNewPrimaryKeysMap(DLFolder.class);
        long folderId = MapUtil.getLong((Map)folderPKs, (long)fileEntry.getFolderId(), (long)fileEntry.getFolderId());
        long[] assetCategoryIds = null;
        String[] assetTagNames = null;
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "categories")) {
            assetCategoryIds = portletDataContext.getAssetCategoryIds(DLFileEntry.class, fileEntry.getFileEntryId());
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "tags")) {
            assetTagNames = portletDataContext.getAssetTagNames(DLFileEntry.class, fileEntry.getFileEntryId());
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext(fileEntryElement, (ClassedModel)fileEntry, _NAMESPACE);
        serviceContext.setAttribute("sourceFileName", (Serializable)((Object)("A." + fileEntry.getExtension())));
        serviceContext.setUserId(userId);
        String binPath = fileEntryElement.attributeValue("bin-path");
        InputStream is = null;
        is = Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport() ? FileEntryUtil.getContentStream(fileEntry) : portletDataContext.getZipEntryAsInputStream(binPath);
        String folderUuid = "";
        if (folderId != 0L && folderId == fileEntry.getFolderId()) {
            String folderPath = DLPortletDataHandlerImpl.getImportFolderPath(portletDataContext, folderId);
            Folder folder = (Folder)portletDataContext.getZipEntryAsObject(folderPath);
            Document document = fileEntryElement.getDocument();
            Element rootElement = document.getRootElement();
            Element folderElement = (Element)rootElement.selectSingleNode("//folder[@path='".concat(folderPath).concat("']"));
            DLPortletDataHandlerImpl.importFolder(portletDataContext, folderPath, folderElement, folder);
            folderUuid = folder.getUuid();
            folderId = MapUtil.getLong((Map)folderPKs, (long)fileEntry.getFolderId(), (long)fileEntry.getFolderId());
        }
        DLPortletDataHandlerImpl.importMetaData(portletDataContext, fileEntryElement, serviceContext);
        FileEntry importedFileEntry = null;
        String titleWithExtension = fileEntry.getTitle();
        String extension = fileEntry.getExtension();
        if (!titleWithExtension.endsWith("." + extension)) {
            titleWithExtension = String.valueOf(titleWithExtension) + "." + extension;
        }
        if (portletDataContext.isDataStrategyMirror()) {
            FileEntry existingFileEntry = FileEntryUtil.fetchByUUID_R(fileEntry.getUuid(), portletDataContext.getScopeGroupId());
            if (existingFileEntry == null) {
                FileEntry existingTitleFileEntry = FileEntryUtil.fetchByR_F_T(portletDataContext.getScopeGroupId(), folderId, fileEntry.getTitle());
                if (existingTitleFileEntry != null) {
                    if (portletDataContext.isDataStrategyMirrorWithOverwritting()) {
                        DLAppLocalServiceUtil.deleteFileEntry((long)existingTitleFileEntry.getFileEntryId());
                    } else {
                        String dotExtension;
                        String originalTitle = fileEntry.getTitle();
                        if (originalTitle.endsWith(dotExtension = "." + extension)) {
                            int pos = originalTitle.lastIndexOf(dotExtension);
                            originalTitle = originalTitle.substring(0, pos);
                        }
                        int i = 1;
                        while (true) {
                            titleWithExtension = String.valueOf(originalTitle) + " " + i + dotExtension;
                            existingTitleFileEntry = FileEntryUtil.findByR_F_T(portletDataContext.getScopeGroupId(), folderId, titleWithExtension);
                            if (existingTitleFileEntry == null) break;
                            ++i;
                        }
                    }
                }
                serviceContext.setUuid(fileEntry.getUuid());
                importedFileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)titleWithExtension, (String)fileEntry.getMimeType(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), null, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            } else if (!DLPortletDataHandlerImpl.isDuplicateFileEntry(folderUuid, fileEntry, existingFileEntry)) {
                importedFileEntry = DLAppLocalServiceUtil.updateFileEntry((long)userId, (long)existingFileEntry.getFileEntryId(), (String)fileEntry.getTitle(), (String)fileEntry.getMimeType(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), null, (boolean)true, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            } else {
                FileVersion latestFileVersion = existingFileEntry.getLatestFileVersion();
                DLAppLocalServiceUtil.updateAsset((long)userId, (FileEntry)existingFileEntry, (FileVersion)latestFileVersion, (long[])assetCategoryIds, (String[])assetTagNames, null);
                if (existingFileEntry instanceof LiferayFileEntry) {
                    LiferayFileEntry liferayFileEntry = (LiferayFileEntry)existingFileEntry;
                    Indexer indexer = IndexerRegistryUtil.getIndexer(DLFileEntry.class);
                    indexer.reindex(liferayFileEntry.getModel());
                }
                importedFileEntry = existingFileEntry;
            }
        } else {
            try {
                importedFileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)titleWithExtension, (String)fileEntry.getMimeType(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), null, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            }
            catch (DuplicateFileException duplicateFileException) {
                String title = fileEntry.getTitle();
                String[] titleParts = title.split("\\.", 2);
                title = String.valueOf(titleParts[0]) + PwdGenerator.getPassword();
                if (titleParts.length > 1) {
                    title = String.valueOf(title) + "." + titleParts[1];
                }
                if (!title.endsWith("." + extension)) {
                    title = String.valueOf(title) + "." + extension;
                }
                importedFileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)title, (String)fileEntry.getMimeType(), (String)title, (String)fileEntry.getDescription(), null, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            }
        }
        Map fileEntryTitles = portletDataContext.getNewPrimaryKeysMap(String.valueOf(DLFileEntry.class.getName()) + ".title");
        fileEntryTitles.put(fileEntry.getTitle(), importedFileEntry.getTitle());
        portletDataContext.importClassedModel((ClassedModel)fileEntry, (ClassedModel)importedFileEntry, _NAMESPACE);
    }

    public static void importFileRank(PortletDataContext portletDataContext, Element fileRankElement) throws Exception {
        String path = fileRankElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        DLFileRank fileRank = (DLFileRank)portletDataContext.getZipEntryAsObject(path);
        String fileEntryUuid = fileRankElement.attributeValue("file-entry-uuid");
        DLPortletDataHandlerImpl.importFileRank(portletDataContext, fileRank, fileEntryUuid);
    }

    public static void importFolder(PortletDataContext portletDataContext, Element folderElement) throws Exception {
        String path = folderElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Folder folder = (Folder)portletDataContext.getZipEntryAsObject(path);
        DLPortletDataHandlerImpl.importFolder(portletDataContext, path, folderElement, folder);
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_repositories, _foldersAndDocuments, _shortcuts, _ranks, _categories, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_repositories, _foldersAndDocuments, _shortcuts, _ranks, _categories, _comments, _ratings, _tags};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return PropsValues.DL_PUBLISH_TO_LIVE_BY_DEFAULT;
    }

    protected static void exportFileEntryType(PortletDataContext portletDataContext, Element fileEntryTypesElement, DLFileEntryType dlFileEntryType) throws Exception {
        String path = DLPortletDataHandlerImpl.getFileEntryTypePath(portletDataContext, dlFileEntryType);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element fileEntryTypeElement = fileEntryTypesElement.addElement("file-entry-type");
        List ddmStructures = dlFileEntryType.getDDMStructures();
        Object[] ddmStructureUuids = new String[ddmStructures.size()];
        int i = 0;
        while (i < ddmStructures.size()) {
            DDMStructure ddmStructure = (DDMStructure)ddmStructures.get(i);
            ddmStructureUuids[i] = ddmStructure.getUuid();
            DDMPortletDataHandlerImpl.exportStructure(portletDataContext, fileEntryTypeElement, ddmStructure);
            ++i;
        }
        fileEntryTypeElement.addAttribute("structureUuids", StringUtil.merge((Object[])ddmStructureUuids));
        portletDataContext.addClassedModel(fileEntryTypeElement, path, (ClassedModel)dlFileEntryType, _NAMESPACE);
    }

    protected static void exportFileRank(PortletDataContext portletDataContext, Element fileRanksElement, DLFileRank fileRank) throws Exception {
        String path = DLPortletDataHandlerImpl.getFileRankPath(portletDataContext, fileRank);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element fileRankElement = fileRanksElement.addElement("file-rank");
        FileEntry fileEntry = FileEntryUtil.fetchByPrimaryKey(fileRank.getFileEntryId());
        String fileEntryUuid = fileEntry.getUuid();
        fileRankElement.addAttribute("file-entry-uuid", fileEntryUuid);
        portletDataContext.addClassedModel(fileRankElement, path, (ClassedModel)fileRank, _NAMESPACE);
    }

    protected static void exportFileShortcut(PortletDataContext portletDataContext, Element fileEntryTypesElement, Element foldersElement, Element fileShortcutsElement, DLFileShortcut fileShortcut) throws Exception {
        if (!portletDataContext.isWithinDateRange(fileShortcut.getModifiedDate())) {
            return;
        }
        DLPortletDataHandlerImpl.exportParentFolder(portletDataContext, fileEntryTypesElement, foldersElement, fileShortcut.getFolderId());
        String path = DLPortletDataHandlerImpl.getFileShortcutPath(portletDataContext, fileShortcut);
        if (portletDataContext.isPathNotProcessed(path)) {
            Element fileShortcutElement = fileShortcutsElement.addElement("file-shortcut");
            FileEntry fileEntry = FileEntryUtil.fetchByPrimaryKey(fileShortcut.getToFileEntryId());
            String fileEntryUuid = fileEntry.getUuid();
            fileShortcutElement.addAttribute("file-entry-uuid", fileEntryUuid);
            portletDataContext.addClassedModel(fileShortcutElement, path, (ClassedModel)fileShortcut, _NAMESPACE);
        }
    }

    protected static void exportFolder(PortletDataContext portletDataContext, Element fileEntryTypesElement, Element foldersElement, Element fileEntriesElement, Element fileShortcutsElement, Element fileRanksElement, Folder folder, boolean recurse) throws Exception {
        if (!portletDataContext.isWithinDateRange(folder.getModifiedDate())) {
            return;
        }
        DLPortletDataHandlerImpl.exportParentFolder(portletDataContext, fileEntryTypesElement, foldersElement, folder.getParentFolderId());
        String path = DLPortletDataHandlerImpl.getFolderPath(portletDataContext, folder);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element folderElement = foldersElement.addElement("folder");
        DLPortletDataHandlerImpl.exportFolderFileEntryTypes(portletDataContext, folder, fileEntryTypesElement, folderElement);
        portletDataContext.addClassedModel(folderElement, path, (ClassedModel)folder, _NAMESPACE);
        if (recurse) {
            List<Folder> folders = FolderUtil.findByR_P(folder.getRepositoryId(), folder.getFolderId());
            for (Folder curFolder : folders) {
                DLPortletDataHandlerImpl.exportFolder(portletDataContext, fileEntryTypesElement, foldersElement, fileEntriesElement, fileShortcutsElement, fileRanksElement, curFolder, recurse);
            }
        }
        List<FileEntry> fileEntries = FileEntryUtil.findByR_F(folder.getRepositoryId(), folder.getFolderId());
        for (FileEntry fileEntry : fileEntries) {
            DLPortletDataHandlerImpl.exportFileEntry(portletDataContext, fileEntryTypesElement, foldersElement, fileEntriesElement, fileRanksElement, fileEntry, true);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "shortcuts")) {
            List fileShortcuts = DLFileShortcutUtil.findByG_F((long)folder.getRepositoryId(), (long)folder.getFolderId());
            for (DLFileShortcut fileShortcut : fileShortcuts) {
                DLPortletDataHandlerImpl.exportFileShortcut(portletDataContext, fileEntryTypesElement, foldersElement, fileShortcutsElement, fileShortcut);
            }
        }
    }

    protected static void exportFolderFileEntryTypes(PortletDataContext portletDataContext, Folder folder, Element fileEntryTypesElement, Element folderElement) throws Exception {
        List dlFileEntryTypes = DLFileEntryTypeLocalServiceUtil.getFolderFileEntryTypes((long[])new long[]{portletDataContext.getScopeGroupId()}, (long)folder.getFolderId(), (boolean)false);
        Object[] fileEntryTypeUuids = new String[dlFileEntryTypes.size()];
        long defaultFileEntryTypeId = DLFileEntryTypeLocalServiceUtil.getDefaultFileEntryTypeId((long)folder.getFolderId());
        String defaultFileEntryTypeUuid = "";
        int i = 0;
        while (i < dlFileEntryTypes.size()) {
            DLFileEntryType dlFileEntryType = (DLFileEntryType)dlFileEntryTypes.get(i);
            if (DLPortletDataHandlerImpl.isFileEntryTypeExportable(portletDataContext.getCompanyId(), dlFileEntryType)) {
                fileEntryTypeUuids[i] = dlFileEntryType.getUuid();
                if (defaultFileEntryTypeId == dlFileEntryType.getFileEntryTypeId()) {
                    defaultFileEntryTypeUuid = dlFileEntryType.getUuid();
                }
                DLPortletDataHandlerImpl.exportFileEntryType(portletDataContext, fileEntryTypesElement, dlFileEntryType);
            }
            ++i;
        }
        folderElement.addAttribute("fileEntryTypeUuids", StringUtil.merge((Object[])fileEntryTypeUuids));
        folderElement.addAttribute("defaultFileEntryTypeUuid", defaultFileEntryTypeUuid);
    }

    protected static void exportMetaData(PortletDataContext portletDataContext, Element fileEntryTypesElement, Element fileEntryElement, FileEntry fileEntry) throws Exception {
        if (!(fileEntry instanceof LiferayFileEntry)) {
            return;
        }
        LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
        DLFileEntry dlFileEntry = liferayFileEntry.getDLFileEntry();
        long fileEntryTypeId = dlFileEntry.getFileEntryTypeId();
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchFileEntryType((long)fileEntryTypeId);
        if (dlFileEntryType == null) {
            return;
        }
        fileEntryElement.addAttribute("fileEntryTypeUuid", dlFileEntryType.getUuid());
        if (!DLPortletDataHandlerImpl.isFileEntryTypeExportable(portletDataContext.getCompanyId(), dlFileEntryType)) {
            return;
        }
        DLPortletDataHandlerImpl.exportFileEntryType(portletDataContext, fileEntryTypesElement, dlFileEntryType);
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            Element structureFields = fileEntryElement.addElement("structure-fields");
            String path = DLPortletDataHandlerImpl.getFileEntryFileEntryTypeStructureFieldsPath(portletDataContext, fileEntry, dlFileEntryType.getUuid(), ddmStructure.getStructureId());
            structureFields.addAttribute("path", path);
            structureFields.addAttribute("structureUuid", ddmStructure.getUuid());
            FileVersion fileVersion = fileEntry.getFileVersion();
            DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.getFileEntryMetadata((long)ddmStructure.getStructureId(), (long)fileVersion.getFileVersionId());
            Fields fields = StorageEngineUtil.getFields((long)dlFileEntryMetadata.getDDMStorageId());
            portletDataContext.addZipEntry(path, (Object)fields);
        }
    }

    protected static void exportParentFolder(PortletDataContext portletDataContext, Element fileEntryTypesElement, Element foldersElement, long folderId) throws Exception {
        if (folderId == 0L) {
            return;
        }
        Folder folder = FolderUtil.findByPrimaryKey(folderId);
        DLPortletDataHandlerImpl.exportParentFolder(portletDataContext, fileEntryTypesElement, foldersElement, folder.getParentFolderId());
        String path = DLPortletDataHandlerImpl.getFolderPath(portletDataContext, folder);
        if (portletDataContext.isPathNotProcessed(path)) {
            Element folderElement = foldersElement.addElement("folder");
            DLPortletDataHandlerImpl.exportFolderFileEntryTypes(portletDataContext, folder, fileEntryTypesElement, folderElement);
            portletDataContext.addClassedModel(folderElement, path, (ClassedModel)folder, _NAMESPACE);
        }
    }

    protected static void exportRepository(PortletDataContext portletDataContext, Element repositoriesElement, Repository repository) throws Exception {
        if (!portletDataContext.isWithinDateRange(repository.getModifiedDate())) {
            return;
        }
        String path = DLPortletDataHandlerImpl.getRepositoryPath(portletDataContext, repository);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element repositoryElement = repositoriesElement.addElement("repository");
        repositoryElement.addAttribute("repositoryClassName", repository.getClassName());
        portletDataContext.addClassedModel(repositoryElement, path, (ClassedModel)repository, _NAMESPACE);
    }

    protected static String getFileEntryBinPath(PortletDataContext portletDataContext, FileEntry fileEntry) {
        StringBundler sb = new StringBundler(5);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/bin/");
        sb.append(fileEntry.getFileEntryId());
        sb.append("/");
        sb.append(fileEntry.getVersion());
        return sb.toString();
    }

    protected static String getFileEntryFileEntryTypeStructureFieldsPath(PortletDataContext portletDataContext, FileEntry fileEntry, String fileEntryTypeUuid, long structureId) {
        StringBundler sb = new StringBundler(4);
        String fileEntryPath = DLPortletDataHandlerImpl.getFileEntryPath(portletDataContext, fileEntry);
        sb.append(StringUtil.replace((String)fileEntryPath, (String)".xml", (String)""));
        sb.append("/file-entry-type/");
        sb.append(fileEntryTypeUuid);
        sb.append("/structure-fields/");
        sb.append(structureId);
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getFileEntryTypeName(String uuid, long companyId, long groupId, String name, int count) throws Exception {
        DLFileEntryType dlFileEntryType = DLFileEntryTypeUtil.fetchByG_N((long)groupId, (String)name);
        if (dlFileEntryType == null) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(dlFileEntryType.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return DLPortletDataHandlerImpl.getFileEntryTypeName(uuid, companyId, groupId, name, ++count);
    }

    protected static String getFileEntryTypePath(PortletDataContext portletDataContext, DLFileEntryType dlFileEntryType) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/entry-types/");
        sb.append(dlFileEntryType.getFileEntryTypeId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getFileRankPath(PortletDataContext portletDataContext, DLFileRank fileRank) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/ranks/");
        sb.append(fileRank.getFileRankId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getFileShortcutPath(PortletDataContext portletDataContext, DLFileShortcut fileShortcut) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/shortcuts/");
        sb.append(fileShortcut.getFileShortcutId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getFolderName(String uuid, long groupId, long parentFolderId, String name, int count) throws Exception {
        Folder folder = FolderUtil.fetchByR_P_N(groupId, parentFolderId, name);
        if (folder == null) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(folder.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return DLPortletDataHandlerImpl.getFolderName(uuid, groupId, parentFolderId, name, ++count);
    }

    protected static String getFolderPath(PortletDataContext portletDataContext, Folder folder) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/folders/");
        sb.append(folder.getFolderId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getImportFolderPath(PortletDataContext portletDataContext, long folderId) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getSourcePortletPath("20"));
        sb.append("/folders/");
        sb.append(folderId);
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getImportRepositoryPath(PortletDataContext portletDataContext, long repositoryId) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getSourcePortletPath("20"));
        sb.append("/repositories/");
        sb.append(repositoryId);
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getRepositoryPath(PortletDataContext portletDataContext, Repository repository) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/repositories/");
        sb.append(repository.getRepositoryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static void importFileEntryType(PortletDataContext portletDataContext, Element fileEntryTypeElement) throws Exception {
        String path = fileEntryTypeElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        DLFileEntryType dlFileEntryType = (DLFileEntryType)portletDataContext.getZipEntryAsObject(path);
        long userId = portletDataContext.getUserId(dlFileEntryType.getUserUuid());
        String name = DLPortletDataHandlerImpl.getFileEntryTypeName(dlFileEntryType.getUuid(), portletDataContext.getCompanyId(), portletDataContext.getScopeGroupId(), dlFileEntryType.getName(), 2);
        List structureElements = fileEntryTypeElement.elements("structure");
        for (Element structureElement : structureElements) {
            DDMPortletDataHandlerImpl.importStructure(portletDataContext, structureElement);
        }
        String[] ddmStructureUuids = StringUtil.split((String)fileEntryTypeElement.attributeValue("structureUuids"));
        long[] ddmStrutureIds = new long[ddmStructureUuids.length];
        int i = 0;
        while (i < ddmStructureUuids.length) {
            DDMStructure existingStructure = DDMStructureUtil.fetchByUUID_G((String)ddmStructureUuids[i], (long)portletDataContext.getScopeGroupId());
            ddmStrutureIds[i] = existingStructure.getStructureId();
            ++i;
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext(path, (ClassedModel)dlFileEntryType, _NAMESPACE);
        DLFileEntryType importedDLFileEntryType = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DLFileEntryType existingDLFileEntryType = DLFileEntryTypeUtil.fetchByUUID_G((String)dlFileEntryType.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingDLFileEntryType == null) {
                serviceContext.setUuid(dlFileEntryType.getUuid());
                importedDLFileEntryType = DLFileEntryTypeLocalServiceUtil.addFileEntryType((long)userId, (long)portletDataContext.getScopeGroupId(), (String)name, (String)dlFileEntryType.getDescription(), (long[])ddmStrutureIds, (ServiceContext)serviceContext);
            } else {
                DLFileEntryTypeLocalServiceUtil.updateFileEntryType((long)userId, (long)existingDLFileEntryType.getFileEntryTypeId(), (String)name, (String)dlFileEntryType.getDescription(), (long[])ddmStrutureIds, (ServiceContext)serviceContext);
                importedDLFileEntryType = existingDLFileEntryType;
            }
        } else {
            importedDLFileEntryType = DLFileEntryTypeLocalServiceUtil.addFileEntryType((long)userId, (long)portletDataContext.getScopeGroupId(), (String)name, (String)dlFileEntryType.getDescription(), (long[])ddmStrutureIds, (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)dlFileEntryType, (ClassedModel)importedDLFileEntryType, _NAMESPACE);
    }

    protected static void importFileRank(PortletDataContext portletDataContext, DLFileRank fileRank, String fileEntryUuid) throws Exception {
        long userId = portletDataContext.getUserId(fileRank.getUserUuid());
        long groupId = portletDataContext.getScopeGroupId();
        FileEntry fileEntry = FileEntryUtil.fetchByUUID_R(fileEntryUuid, groupId);
        if (fileEntry == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to retrieve file: " + fileEntryUuid + " to import file rank."));
            }
            return;
        }
        long fileEntryId = fileEntry.getFileEntryId();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCreateDate(fileRank.getCreateDate());
        DLAppLocalServiceUtil.updateFileRank((long)portletDataContext.getScopeGroupId(), (long)portletDataContext.getCompanyId(), (long)userId, (long)fileEntryId, (ServiceContext)serviceContext);
    }

    protected static void importFileShortcut(PortletDataContext portletDataContext, Element fileShortcutElement) throws Exception {
        String path = fileShortcutElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        DLFileShortcut fileShortcut = (DLFileShortcut)portletDataContext.getZipEntryAsObject(path);
        DLPortletDataHandlerImpl.importFileShortcut(portletDataContext, fileShortcutElement, fileShortcut);
    }

    protected static void importFileShortcut(PortletDataContext portletDataContext, Element fileShortcutElement, DLFileShortcut fileShortcut) throws Exception {
        String fileEntryUuid;
        FileEntry fileEntry;
        long userId = portletDataContext.getUserId(fileShortcut.getUserUuid());
        Map folderPKs = portletDataContext.getNewPrimaryKeysMap(DLFolder.class);
        long folderId = MapUtil.getLong((Map)folderPKs, (long)fileShortcut.getFolderId(), (long)fileShortcut.getFolderId());
        long groupId = portletDataContext.getScopeGroupId();
        if (folderId != 0L) {
            Folder folder = FolderUtil.findByPrimaryKey(folderId);
            groupId = folder.getRepositoryId();
        }
        if ((fileEntry = FileEntryUtil.fetchByUUID_R(fileEntryUuid = fileShortcutElement.attributeValue("file-entry-uuid"), groupId)) == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to fetch file entry {uuid=" + fileEntryUuid + ",groupId=" + groupId + "}"));
            }
            return;
        }
        long fileEntryId = fileEntry.getFileEntryId();
        ServiceContext serviceContext = portletDataContext.createServiceContext(fileShortcutElement, (ClassedModel)fileShortcut, _NAMESPACE);
        DLFileShortcut importedFileShortcut = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DLFileShortcut existingFileShortcut = DLFileShortcutUtil.fetchByUUID_G((String)fileShortcut.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingFileShortcut == null) {
                serviceContext.setUuid(fileShortcut.getUuid());
                importedFileShortcut = DLAppLocalServiceUtil.addFileShortcut((long)userId, (long)groupId, (long)folderId, (long)fileEntryId, (ServiceContext)serviceContext);
            } else {
                importedFileShortcut = DLAppLocalServiceUtil.updateFileShortcut((long)userId, (long)existingFileShortcut.getFileShortcutId(), (long)folderId, (long)fileEntryId, (ServiceContext)serviceContext);
            }
        } else {
            importedFileShortcut = DLAppLocalServiceUtil.addFileShortcut((long)userId, (long)groupId, (long)folderId, (long)fileEntryId, (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)fileShortcut, (ClassedModel)importedFileShortcut, _NAMESPACE);
    }

    protected static void importFolder(PortletDataContext portletDataContext, String folderPath, Element folderElement, Folder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        Map folderPKs = portletDataContext.getNewPrimaryKeysMap(DLFolder.class);
        long parentFolderId = MapUtil.getLong((Map)folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = portletDataContext.createServiceContext(folderPath, (ClassedModel)folder, _NAMESPACE);
        if (parentFolderId != 0L && parentFolderId == folder.getParentFolderId()) {
            String path = DLPortletDataHandlerImpl.getImportFolderPath(portletDataContext, parentFolderId);
            Folder parentFolder = (Folder)portletDataContext.getZipEntryAsObject(path);
            DLPortletDataHandlerImpl.importFolder(portletDataContext, path, folderElement, parentFolder);
            parentFolderId = MapUtil.getLong((Map)folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        }
        Folder importedFolder = null;
        if (portletDataContext.isDataStrategyMirror()) {
            Folder existingFolder = FolderUtil.fetchByUUID_R(folder.getUuid(), portletDataContext.getScopeGroupId());
            if (existingFolder == null) {
                String name = DLPortletDataHandlerImpl.getFolderName(null, portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                serviceContext.setUuid(folder.getUuid());
                importedFolder = DLAppLocalServiceUtil.addFolder((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            } else {
                String name = DLPortletDataHandlerImpl.getFolderName(folder.getUuid(), portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                importedFolder = DLAppLocalServiceUtil.updateFolder((long)existingFolder.getFolderId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            }
        } else {
            String name = DLPortletDataHandlerImpl.getFolderName(null, portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
            importedFolder = DLAppLocalServiceUtil.addFolder((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
        }
        DLPortletDataHandlerImpl.importFolderFileEntryTypes(portletDataContext, folderElement, importedFolder, serviceContext);
        portletDataContext.importClassedModel((ClassedModel)folder, (ClassedModel)importedFolder, _NAMESPACE);
    }

    protected static void importFolderFileEntryTypes(PortletDataContext portletDataContext, Element folderElement, Folder folder, ServiceContext serviceContext) throws Exception {
        String[] fileEntryTypeUuids = StringUtil.split((String)folderElement.attributeValue("fileEntryTypeUuids"));
        ArrayList<Long> fileEntryTypeIds = new ArrayList<Long>();
        String defaultFileEntryTypeUuid = GetterUtil.getString((String)folderElement.attributeValue("defaultFileEntryTypeUuid"));
        long defaultFileEntryTypeId = 0L;
        String[] stringArray = fileEntryTypeUuids;
        int n = fileEntryTypeUuids.length;
        int n2 = 0;
        while (n2 < n) {
            String fileEntryTypeUuid = stringArray[n2];
            DLFileEntryType dlFileEntryType = DLFileEntryTypeUtil.fetchByUUID_G((String)fileEntryTypeUuid, (long)portletDataContext.getScopeGroupId());
            if (dlFileEntryType != null) {
                fileEntryTypeIds.add(dlFileEntryType.getFileEntryTypeId());
                if (defaultFileEntryTypeUuid.equals(dlFileEntryType.getUuid())) {
                    defaultFileEntryTypeId = dlFileEntryType.getFileEntryTypeId();
                }
            }
            ++n2;
        }
        DLFileEntryTypeLocalServiceUtil.updateFolderFileEntryTypes((DLFolder)((DLFolder)folder.getModel()), fileEntryTypeIds, (long)defaultFileEntryTypeId, (ServiceContext)serviceContext);
    }

    protected static void importMetaData(PortletDataContext portletDataContext, Element fileEntryElement, ServiceContext serviceContext) throws Exception {
        String fileEntryTypeUuid = fileEntryElement.attributeValue("fileEntryTypeUuid");
        if (Validator.isNull((String)fileEntryTypeUuid)) {
            return;
        }
        DLFileEntryType dlFileEntryType = DLFileEntryTypeUtil.fetchByUUID_G((String)fileEntryTypeUuid, (long)portletDataContext.getScopeGroupId());
        if (dlFileEntryType == null) {
            serviceContext.setAttribute("fileEntryTypeId", (Serializable)Integer.valueOf(-1));
            return;
        }
        serviceContext.setAttribute("fileEntryTypeId", (Serializable)Long.valueOf(dlFileEntryType.getFileEntryTypeId()));
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            Element structureFieldsElement = (Element)fileEntryElement.selectSingleNode("//structure-fields[@structureUuid='".concat(ddmStructure.getUuid()).concat("']"));
            if (structureFieldsElement == null) continue;
            String path = structureFieldsElement.attributeValue("path");
            Fields fields = (Fields)portletDataContext.getZipEntryAsObject(path);
            serviceContext.setAttribute(String.valueOf(Fields.class.getName()) + ddmStructure.getStructureId(), (Serializable)fields);
        }
    }

    protected void importRepository(PortletDataContext portletDataContext, Element repositoryElement) throws Exception {
        String path = repositoryElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Repository repository = (Repository)portletDataContext.getZipEntryAsObject(path);
        long userId = portletDataContext.getUserId(repository.getUserUuid());
        long classNameId = PortalUtil.getClassNameId((String)repositoryElement.attributeValue("repositoryClassName"));
        String repositoryPath = DLPortletDataHandlerImpl.getImportRepositoryPath(portletDataContext, repository.getRepositoryId());
        ServiceContext serviceContext = portletDataContext.createServiceContext(repositoryPath, (ClassedModel)repository, _NAMESPACE);
        RepositoryLocalServiceUtil.addRepository((long)userId, (long)portletDataContext.getScopeGroupId(), (long)classNameId, (long)0L, (String)repository.getName(), (String)repository.getDescription(), (String)repository.getPortletId(), (UnicodeProperties)repository.getTypeSettingsProperties(), (ServiceContext)serviceContext);
    }

    protected static boolean isDuplicateFileEntry(String folderUuid, FileEntry fileEntry1, FileEntry fileEntry2) {
        try {
            Folder folder2 = fileEntry2.getFolder();
            return folderUuid.equals(folder2.getUuid()) && fileEntry1.getSize() == fileEntry2.getSize() && DLUtil.compareVersions((String)fileEntry1.getVersion(), (String)fileEntry2.getVersion()) == 0 && fileEntry1.getVersionUserUuid().equals(fileEntry2.getVersionUserUuid());
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static boolean isFileEntryTypeExportable(long companyId, DLFileEntryType dlFileEntryType) throws PortalException, SystemException {
        if (dlFileEntryType.getFileEntryTypeId() == 0L) {
            return false;
        }
        Group group = GroupLocalServiceUtil.getCompanyGroup((long)companyId);
        return dlFileEntryType.getGroupId() != group.getGroupId();
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (!portletDataContext.addPrimaryKey(DLPortletDataHandlerImpl.class, "deleteData")) {
            DLAppLocalServiceUtil.deleteAll((long)portletDataContext.getScopeGroupId());
        }
        return null;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.documentlibrary", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("documentlibrary-data");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        if (rootFolderId != 0L) {
            rootElement.addAttribute("root-folder-id", String.valueOf(rootFolderId));
        }
        Element repositoryElement = rootElement.addElement("repositories");
        Element fileEntryTypesElement = rootElement.addElement("file-entry-types");
        Element foldersElement = rootElement.addElement("folders");
        Element fileEntriesElement = rootElement.addElement("file-entries");
        Element fileShortcutsElement = rootElement.addElement("file-shortcuts");
        Element fileRanksElement = rootElement.addElement("file-ranks");
        List dlFileEntryTypes = DLFileEntryTypeServiceUtil.getFileEntryTypes((long[])new long[]{portletDataContext.getScopeGroupId()});
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            if (!DLPortletDataHandlerImpl.isFileEntryTypeExportable(portletDataContext.getCompanyId(), dlFileEntryType)) continue;
            DLPortletDataHandlerImpl.exportFileEntryType(portletDataContext, fileEntryTypesElement, dlFileEntryType);
        }
        List<Folder> folders = FolderUtil.findByRepositoryId(portletDataContext.getScopeGroupId());
        for (Folder folder : folders) {
            if (!folder.isMountPoint()) {
                DLPortletDataHandlerImpl.exportFolder(portletDataContext, fileEntryTypesElement, foldersElement, fileEntriesElement, fileShortcutsElement, fileRanksElement, folder, false);
                continue;
            }
            if (!portletDataContext.getBooleanParameter(_NAMESPACE, "repositories")) continue;
            Repository repository = RepositoryUtil.findByPrimaryKey((long)folder.getRepositoryId());
            DLPortletDataHandlerImpl.exportRepository(portletDataContext, repositoryElement, repository);
        }
        List<FileEntry> fileEntries = FileEntryUtil.findByR_F(portletDataContext.getScopeGroupId(), 0L);
        for (FileEntry fileEntry : fileEntries) {
            DLPortletDataHandlerImpl.exportFileEntry(portletDataContext, fileEntryTypesElement, foldersElement, fileEntriesElement, fileRanksElement, fileEntry, true);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "shortcuts")) {
            List fileShortcuts = DLFileShortcutUtil.findByG_F((long)portletDataContext.getScopeGroupId(), (long)0L);
            for (DLFileShortcut fileShortcut : fileShortcuts) {
                DLPortletDataHandlerImpl.exportFileShortcut(portletDataContext, fileEntryTypesElement, foldersElement, fileShortcutsElement, fileShortcut);
            }
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        long rootFolderId;
        Element repositoriesElement;
        portletDataContext.importPermissions("com.liferay.portlet.documentlibrary", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "repositories") && (repositoriesElement = rootElement.element("repositories")) != null) {
            List repositoryElements = repositoriesElement.elements("repository");
            for (Element repositoryElement : repositoryElements) {
                this.importRepository(portletDataContext, repositoryElement);
            }
        }
        Element fileEntryTypesElement = rootElement.element("file-entry-types");
        List fileEntryTypeElements = fileEntryTypesElement.elements("file-entry-type");
        for (Element fileEntryTypeElement : fileEntryTypeElements) {
            DLPortletDataHandlerImpl.importFileEntryType(portletDataContext, fileEntryTypeElement);
        }
        Element foldersElement = rootElement.element("folders");
        List folderElements = foldersElement.elements("folder");
        for (Element folderElement : folderElements) {
            DLPortletDataHandlerImpl.importFolder(portletDataContext, folderElement);
        }
        Element fileEntriesElement = rootElement.element("file-entries");
        List fileEntryElements = fileEntriesElement.elements("file-entry");
        for (Element fileEntryElement : fileEntryElements) {
            DLPortletDataHandlerImpl.importFileEntry(portletDataContext, fileEntryElement);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "shortcuts")) {
            List fileShortcutElements = rootElement.element("file-shortcuts").elements("file-shortcut");
            for (Element fileShortcutElement : fileShortcutElements) {
                DLPortletDataHandlerImpl.importFileShortcut(portletDataContext, fileShortcutElement);
            }
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "ranks")) {
            Element fileRanksElement = rootElement.element("file-ranks");
            List fileRankElements = fileRanksElement.elements("file-rank");
            for (Element fileRankElement : fileRankElements) {
                DLPortletDataHandlerImpl.importFileRank(portletDataContext, fileRankElement);
            }
        }
        if ((rootFolderId = GetterUtil.getLong((String)rootElement.attributeValue("root-folder-id"))) > 0L) {
            Map folderPKs = portletDataContext.getNewPrimaryKeysMap(DLFolder.class);
            rootFolderId = MapUtil.getLong((Map)folderPKs, (long)rootFolderId, (long)rootFolderId);
            portletPreferences.setValue("rootFolderId", String.valueOf(rootFolderId));
        }
        return portletPreferences;
    }
}

