/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.lar.DLPortletDataHandlerImpl;
import com.liferay.portlet.documentlibrary.lar.FolderUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DLDisplayPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "document_library";
    private static PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("document_library", "comments");
    private static PortletDataHandlerBoolean _foldersAndDocuments = new PortletDataHandlerBoolean("document_library", "folders-and-documents", true, true);
    private static PortletDataHandlerBoolean _ranks = new PortletDataHandlerBoolean("document_library", "ranks");
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("document_library", "ratings");
    private static PortletDataHandlerBoolean _shortcuts = new PortletDataHandlerBoolean("document_library", "shortcuts");
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("document_library", "tags");

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_foldersAndDocuments, _shortcuts, _ranks, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_foldersAndDocuments, _shortcuts, _ranks, _comments, _ratings, _tags};
    }

    public boolean isPublishToLiveByDefault() {
        return PropsValues.DL_PUBLISH_TO_LIVE_BY_DEFAULT;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletPreferences.setValue("rootFolderId", "");
        portletPreferences.setValue("showFoldersSearch", "");
        portletPreferences.setValue("showSubfolders", "");
        portletPreferences.setValue("foldersPerPage", "");
        portletPreferences.setValue("folderColumns", "");
        portletPreferences.setValue("fileEntriesPerPage", "");
        portletPreferences.setValue("fileEntryColumns", "");
        portletPreferences.setValue("enable-comment-ratings", "");
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.documentlibrary", portletDataContext.getScopeGroupId());
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("documentlibrary-display-data");
        Element fileEntryTypesElement = rootElement.addElement("file-entry-types");
        Element foldersElement = rootElement.addElement("folders");
        Element fileEntriesElement = rootElement.addElement("file-entries");
        Element fileShortcutsElement = rootElement.addElement("file-shortcuts");
        Element fileRanksElement = rootElement.addElement("file-ranks");
        if (rootFolderId == 0L) {
            List<Folder> folders = FolderUtil.findByRepositoryId(portletDataContext.getScopeGroupId());
            for (Folder folder : folders) {
                DLPortletDataHandlerImpl.exportFolder(portletDataContext, fileEntryTypesElement, foldersElement, fileEntriesElement, fileShortcutsElement, fileRanksElement, folder, false);
            }
        } else {
            Folder folder = FolderUtil.findByPrimaryKey(rootFolderId);
            rootElement.addAttribute("root-folder-id", String.valueOf(folder.getFolderId()));
            DLPortletDataHandlerImpl.exportFolder(portletDataContext, fileEntryTypesElement, foldersElement, fileEntriesElement, fileShortcutsElement, fileRanksElement, folder, true);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        long rootFolderId;
        portletDataContext.importPermissions("com.liferay.portlet.documentlibrary", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element fileEntryTypesElement = rootElement.element("file-entry-types");
        List fileEntryTypeElements = fileEntryTypesElement.elements("file-entry-type");
        for (Element fileEntryTypeElement : fileEntryTypeElements) {
            DLPortletDataHandlerImpl.importFileEntryType(portletDataContext, fileEntryTypeElement);
        }
        Element foldersElement = rootElement.element("folders");
        List folderElements = foldersElement.elements("folder");
        for (Element folderElement : folderElements) {
            DLPortletDataHandlerImpl.importFolder(portletDataContext, folderElement);
        }
        Element fileEntriesElement = rootElement.element("file-entries");
        List fileEntryElements = fileEntriesElement.elements("file-entry");
        for (Element fileEntryElement : fileEntryElements) {
            DLPortletDataHandlerImpl.importFileEntry(portletDataContext, fileEntryElement);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "shortcuts")) {
            List fileShortcutElements = rootElement.element("file-shortcuts").elements("file-shortcut");
            for (Element fileShortcutElement : fileShortcutElements) {
                DLPortletDataHandlerImpl.importFileShortcut(portletDataContext, fileShortcutElement);
            }
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "ranks")) {
            Element fileRanksElement = rootElement.element("file-ranks");
            List fileRankElements = fileRanksElement.elements("file-rank");
            for (Element fileRankElement : fileRankElements) {
                DLPortletDataHandlerImpl.importFileRank(portletDataContext, fileRankElement);
            }
        }
        if ((rootFolderId = GetterUtil.getLong((String)rootElement.attributeValue("root-folder-id"))) > 0L) {
            Map folderPKs = portletDataContext.getNewPrimaryKeysMap(Folder.class);
            rootFolderId = MapUtil.getLong((Map)folderPKs, (long)rootFolderId, (long)rootFolderId);
            portletPreferences.setValue("rootFolderId", String.valueOf(rootFolderId));
        }
        return portletPreferences;
    }
}

