/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.atom;

import com.liferay.portal.atom.AtomPager;
import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.atom.AtomEntryContent;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import com.liferay.portal.kernel.atom.BaseAtomCollectionAdapter;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.util.comparator.EntryNameComparator;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderAtomCollectionAdapter
extends BaseAtomCollectionAdapter<Folder> {
    private static final String _COLLECTION_NAME = "folders";

    public String getCollectionName() {
        return _COLLECTION_NAME;
    }

    public List<String> getEntryAuthors(Folder folder) {
        ArrayList<String> authors = new ArrayList<String>();
        authors.add(folder.getUserName());
        return authors;
    }

    public AtomEntryContent getEntryContent(Folder folder, AtomRequestContext atomRequestContext) {
        AtomEntryContent atomEntryContent = new AtomEntryContent(AtomEntryContent.Type.XML);
        String srcLink = AtomUtil.createCollectionLink(atomRequestContext, "files");
        srcLink = String.valueOf(srcLink) + "?folderId=" + folder.getFolderId();
        atomEntryContent.setSrcLink(srcLink);
        return atomEntryContent;
    }

    public String getEntryId(Folder folder) {
        return String.valueOf(folder.getPrimaryKey());
    }

    public String getEntrySummary(Folder folder) {
        return folder.getDescription();
    }

    public String getEntryTitle(Folder folder) {
        return folder.getName();
    }

    public Date getEntryUpdated(Folder folder) {
        return folder.getModifiedDate();
    }

    public String getFeedTitle(AtomRequestContext atomRequestContext) {
        return String.valueOf(AtomUtil.createFeedTitleFromPortletName(atomRequestContext, "20")) + " folders";
    }

    protected void doDeleteEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long folderEntryId = GetterUtil.getLong((String)resourceName);
        DLAppServiceUtil.deleteFolder((long)folderEntryId);
    }

    protected Folder doGetEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long folderEntryId = GetterUtil.getLong((String)resourceName);
        return DLAppServiceUtil.getFolder((long)folderEntryId);
    }

    protected Iterable<Folder> doGetFeedEntries(AtomRequestContext atomRequestContext) throws Exception {
        long repositoryId = 0L;
        long parentFolderId = atomRequestContext.getLongParameter("parentFolderId");
        if (parentFolderId != 0L) {
            Folder parentFolder = DLAppServiceUtil.getFolder((long)parentFolderId);
            repositoryId = parentFolder.getRepositoryId();
        } else {
            repositoryId = atomRequestContext.getLongParameter("repositoryId");
        }
        int count = DLAppServiceUtil.getFoldersCount((long)repositoryId, (long)parentFolderId);
        AtomPager atomPager = new AtomPager(atomRequestContext, count);
        AtomUtil.saveAtomPagerInRequest(atomRequestContext, atomPager);
        return DLAppServiceUtil.getFolders((long)repositoryId, (long)parentFolderId, (int)atomPager.getStart(), (int)(atomPager.getEnd() + 1), (OrderByComparator)new EntryNameComparator());
    }

    protected Folder doPostEntry(String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        long repositoryId = 0L;
        long parentFolderId = atomRequestContext.getLongParameter("parentFolderId");
        if (parentFolderId != 0L) {
            Folder parentFolder = DLAppServiceUtil.getFolder((long)parentFolderId);
            repositoryId = parentFolder.getRepositoryId();
        } else {
            repositoryId = atomRequestContext.getLongParameter("repositoryId");
        }
        ServiceContext serviceContext = new ServiceContext();
        Folder folder = DLAppServiceUtil.addFolder((long)repositoryId, (long)parentFolderId, (String)title, (String)summary, (ServiceContext)serviceContext);
        return folder;
    }

    protected void doPutEntry(Folder folder, String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        DLAppServiceUtil.updateFolder((long)folder.getFolderId(), (String)title, (String)summary, (ServiceContext)serviceContext);
    }
}

