/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.asset.DLFileEntryAssetRenderer;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryTypePermission;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileEntryAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String CLASS_NAME = DLFileEntry.class.getName();
    public static final String TYPE = "document";
    private static final boolean _LINKABLE = true;

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        FileEntry fileEntry = null;
        FileVersion fileVersion = null;
        if (type == 0) {
            fileVersion = DLAppLocalServiceUtil.getFileVersion((long)classPK);
            fileEntry = fileVersion.getFileEntry();
        } else {
            fileEntry = DLAppLocalServiceUtil.getFileEntry((long)classPK);
            fileVersion = fileEntry.getFileVersion();
        }
        return new DLFileEntryAssetRenderer(fileEntry, fileVersion);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public Map<Long, String> getClassTypes(long[] groupIds, Locale locale) throws Exception {
        HashMap<Long, String> classTypes = new HashMap<Long, String>();
        List dlFileEntryTypes = DLFileEntryTypeServiceUtil.getFileEntryTypes((long[])groupIds);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            classTypes.put(dlFileEntryType.getFileEntryTypeId(), dlFileEntryType.getName());
        }
        return classTypes;
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException, SystemException {
        HttpServletRequest request = liferayPortletRequest.getHttpServletRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        if (!DLPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "ADD_DOCUMENT")) {
            return null;
        }
        long classTypeId = GetterUtil.getLong((Object)liferayPortletRequest.getAttribute("ASSET_RENDERER_FACTORY_CLASS_TYPE_ID"));
        if (classTypeId > 0L && !DLFileEntryTypePermission.contains(themeDisplay.getPermissionChecker(), classTypeId, "VIEW")) {
            return null;
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"20", (long)this.getControlPanelPlid(themeDisplay), (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/document_library/edit_file_entry");
        portletURL.setParameter("folderId", String.valueOf(AssetPublisherUtil.getRecentFolderId((PortletRequest)liferayPortletRequest, CLASS_NAME)));
        portletURL.setParameter("uploader", "classic");
        return portletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return DLFileEntryPermission.contains(permissionChecker, classPK, actionId);
    }

    public boolean isLinkable() {
        return true;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/clip.png";
    }
}

