/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.FolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.action.ActionUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFolderAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFolder(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFolders(actionRequest);
            } else if (cmd.equals("move")) {
                this.moveFolders(actionRequest);
            } else if (cmd.equals("updateWorkflowDefinitions")) {
                this.updateWorkflowDefinitions(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFolderException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
            }
            if (e instanceof DuplicateFileException || e instanceof DuplicateFolderNameException || e instanceof FolderNameException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFolder((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFolderException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.document_library.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.document_library.edit_folder"));
    }

    protected void deleteFolders(ActionRequest actionRequest) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        if (folderId > 0L) {
            DLAppServiceUtil.deleteFolder((long)folderId);
            AssetPublisherUtil.removeRecentFolderId((PortletRequest)actionRequest, DLFileEntry.class.getName(), folderId);
        } else {
            long[] folderIds;
            long[] lArray = folderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
            int n = folderIds.length;
            int n2 = 0;
            while (n2 < n) {
                long curFolderId = lArray[n2];
                DLAppServiceUtil.deleteFolder((long)curFolderId);
                AssetPublisherUtil.removeRecentFolderId((PortletRequest)actionRequest, DLFileEntry.class.getName(), curFolderId);
                ++n2;
            }
        }
    }

    protected void moveFolders(ActionRequest actionRequest) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long parentFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentFolderId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        if (folderId > 0L) {
            DLAppServiceUtil.moveFolder((long)folderId, (long)parentFolderId, (ServiceContext)serviceContext);
        } else {
            long[] folderIds;
            long[] lArray = folderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
            int n = folderIds.length;
            int n2 = 0;
            while (n2 < n) {
                long curFolderId = lArray[n2];
                DLAppServiceUtil.moveFolder((long)curFolderId, (long)parentFolderId, (ServiceContext)serviceContext);
                ++n2;
            }
        }
    }

    protected void updateFolder(ActionRequest actionRequest) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        long parentFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentFolderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFolder.class.getName(), (PortletRequest)actionRequest);
        if (folderId <= 0L) {
            DLAppServiceUtil.addFolder((long)repositoryId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
        } else {
            DLAppServiceUtil.updateFolder((long)folderId, (String)name, (String)description, (ServiceContext)serviceContext);
        }
    }

    protected void updateWorkflowDefinitions(ActionRequest actionRequest) throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        DLAppServiceUtil.updateFolder((long)0L, null, null, (ServiceContext)serviceContext);
    }
}

