/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.documentlibrary.DuplicateFileEntryTypeException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryTypeException;
import com.liferay.portlet.documentlibrary.NoSuchMetadataSetException;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeServiceUtil;
import com.liferay.portlet.dynamicdatamapping.NoSuchStructureException;
import com.liferay.portlet.dynamicdatamapping.RequiredStructureException;
import com.liferay.portlet.dynamicdatamapping.StructureDuplicateElementException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFileEntryTypeAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFileEntryType(actionRequest, actionResponse);
            } else if (cmd.equals("delete")) {
                this.deleteFileEntryType(actionRequest, actionResponse);
            }
            if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".refreshPortlet"), (Object)"20");
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof DuplicateFileEntryTypeException || e instanceof NoSuchMetadataSetException || e instanceof StructureDuplicateElementException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            if (e instanceof NoSuchFileEntryTypeException || e instanceof NoSuchStructureException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
            }
            if (e instanceof RequiredStructureException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.sendRedirect(actionRequest, actionResponse);
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        DLFileEntryType fileEntryType = null;
        try {
            long fileEntryTypeId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"fileEntryTypeId");
            if (fileEntryTypeId > 0L) {
                fileEntryType = DLFileEntryTypeServiceUtil.getFileEntryType((long)fileEntryTypeId);
                renderRequest.setAttribute("DOCUMENT_LIBRARY_FILE_ENTRY_TYPE", (Object)fileEntryType);
                DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)fileEntryType.getGroupId(), (String)("auto_" + fileEntryTypeId));
                renderRequest.setAttribute("DYNAMIC_DATA_MAPPING_STRUCTURE", (Object)ddmStructure);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryTypeException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.document_library.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.document_library.edit_file_entry_type"));
    }

    protected void deleteFileEntryType(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long fileEntryTypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryTypeId");
        DLFileEntryTypeServiceUtil.deleteFileEntryType((long)fileEntryTypeId);
    }

    protected long[] getLongArray(PortletRequest portletRequest, String name) {
        String value = portletRequest.getParameter(name);
        if (value == null) {
            return null;
        }
        return StringUtil.split((String)GetterUtil.getString((String)value), (long)0L);
    }

    protected void updateFileEntryType(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long fileEntryTypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryTypeId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        long[] ddmStructureIds = this.getLongArray((PortletRequest)actionRequest, "ddmStructuresSearchContainerPrimaryKeys");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntryType.class.getName(), (PortletRequest)actionRequest);
        if (fileEntryTypeId <= 0L) {
            long groupId = themeDisplay.getScopeGroupId();
            Group scopeGroup = GroupLocalServiceUtil.getGroup((long)groupId);
            if (scopeGroup.isLayout()) {
                groupId = scopeGroup.getParentGroupId();
            }
            DLFileEntryTypeServiceUtil.addFileEntryType((long)groupId, (String)name, (String)description, (long[])ddmStructureIds, (ServiceContext)serviceContext);
        } else {
            DLFileEntryTypeServiceUtil.updateFileEntryType((long)fileEntryTypeId, (String)name, (String)description, (long[])ddmStructureIds, (ServiceContext)serviceContext);
        }
    }
}

