/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.SourceFileNameException;
import com.liferay.portlet.documentlibrary.action.ActionUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditEntryAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteEntries(actionRequest);
            } else if (cmd.equals("cancel_checkout")) {
                this.cancelCheckedOutEntries(actionRequest);
            } else if (cmd.equals("checkin")) {
                this.checkInEntries(actionRequest);
            } else if (cmd.equals("checkout")) {
                this.checkOutEntries(actionRequest);
            } else if (cmd.equals("move")) {
                this.moveEntries(actionRequest);
            }
            WindowState windowState = actionRequest.getWindowState();
            if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                this.sendRedirect(actionRequest, actionResponse);
            } else {
                String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                if (Validator.isNotNull((String)redirect)) {
                    actionResponse.sendRedirect(redirect);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof DuplicateLockException || e instanceof NoSuchFileEntryException || e instanceof NoSuchFolderException || e instanceof PrincipalException) {
                if (e instanceof DuplicateLockException) {
                    DuplicateLockException dle = (DuplicateLockException)e;
                    SessionErrors.add((PortletRequest)actionRequest, (String)dle.getClass().getName(), (Object)dle.getLock());
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                }
                this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
            }
            if (e instanceof DuplicateFileException || e instanceof DuplicateFolderNameException || e instanceof NoSuchFolderException || e instanceof SourceFileNameException) {
                if (e instanceof DuplicateFileException) {
                    HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                    response.setStatus(490);
                }
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFolders((PortletRequest)renderRequest);
            ActionUtil.getFileEntries((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.document_library.error");
            }
            throw e;
        }
        String forward = "portlet.document_library.edit_entry";
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, forward));
    }

    protected void cancelCheckedOutEntries(ActionRequest actionRequest) throws Exception {
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        long[] folderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        int i = 0;
        while (i < folderIds.length) {
            DLAppServiceUtil.lockFolder((long)repositoryId, (long)folderIds[i]);
            ++i;
        }
        long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
        int i2 = 0;
        while (i2 < fileEntryIds.length) {
            DLAppServiceUtil.cancelCheckOut((long)fileEntryIds[i2]);
            ++i2;
        }
    }

    protected void checkInEntries(ActionRequest actionRequest) throws Exception {
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        long[] folderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        int i = 0;
        while (i < folderIds.length) {
            DLAppServiceUtil.unlockFolder((long)repositoryId, (long)folderIds[i], null);
            ++i;
        }
        long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        int i2 = 0;
        while (i2 < fileEntryIds.length) {
            DLAppServiceUtil.checkInFileEntry((long)fileEntryIds[i2], (boolean)false, (String)"", (ServiceContext)serviceContext);
            ++i2;
        }
    }

    protected void checkOutEntries(ActionRequest actionRequest) throws Exception {
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        long[] folderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        int i = 0;
        while (i < folderIds.length) {
            DLAppServiceUtil.lockFolder((long)repositoryId, (long)folderIds[i]);
            ++i;
        }
        long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
        int i2 = 0;
        while (i2 < fileEntryIds.length) {
            DLAppServiceUtil.checkOutFileEntry((long)fileEntryIds[i2]);
            ++i2;
        }
    }

    protected void deleteEntries(ActionRequest actionRequest) throws Exception {
        long[] deleteFolderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        int i = 0;
        while (i < deleteFolderIds.length) {
            DLAppServiceUtil.deleteFolder((long)deleteFolderIds[i]);
            ++i;
        }
        long[] deleteFileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
        int i2 = 0;
        while (i2 < deleteFileEntryIds.length) {
            DLAppServiceUtil.deleteFileEntry((long)deleteFileEntryIds[i2]);
            ++i2;
        }
        long[] deleteFileShortcutIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileShortcutIds"), (long)0L);
        int i3 = 0;
        while (i3 < deleteFileShortcutIds.length) {
            DLAppServiceUtil.deleteFileShortcut((long)deleteFileShortcutIds[i3]);
            ++i3;
        }
    }

    protected void moveEntries(ActionRequest actionRequest) throws Exception {
        long newFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"newFolderId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        long[] folderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        int i = 0;
        while (i < folderIds.length) {
            DLAppServiceUtil.moveFolder((long)folderIds[i], (long)newFolderId, (ServiceContext)serviceContext);
            ++i;
        }
        long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
        int i2 = 0;
        while (i2 < fileEntryIds.length) {
            DLAppServiceUtil.moveFileEntry((long)fileEntryIds[i2], (long)newFolderId, (ServiceContext)serviceContext);
            ++i2;
        }
    }
}

