/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.DiffUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CompareVersionsAction
extends PortletAction {
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            this.compareVersions(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)renderRequest, "portlet.document_library.error");
            }
            throw e;
        }
        return mapping.findForward("portlet.document_library.compare_versions");
    }

    protected void compareVersions(RenderRequest renderRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"fileEntryId");
        String sourceVersion = ParamUtil.getString((PortletRequest)renderRequest, (String)"sourceVersion");
        String targetVersion = ParamUtil.getString((PortletRequest)renderRequest, (String)"targetVersion");
        FileEntry fileEntry = DLAppServiceUtil.getFileEntry((long)fileEntryId);
        String extension = fileEntry.getExtension();
        FileVersion sourceFileVersion = fileEntry.getFileVersion(sourceVersion);
        String sourceTitle = sourceFileVersion.getTitle();
        FileVersion targetFileVersion = fileEntry.getFileVersion(targetVersion);
        String targetTitle = targetFileVersion.getTitle();
        InputStream sourceIs = fileEntry.getContentStream(sourceVersion);
        InputStream targetIs = fileEntry.getContentStream(targetVersion);
        if (extension.equals("htm") || extension.equals("html") || extension.equals("xml")) {
            String escapedSource = HtmlUtil.escape((String)StringUtil.read((InputStream)sourceIs));
            String escapedTarget = HtmlUtil.escape((String)StringUtil.read((InputStream)targetIs));
            sourceIs = new UnsyncByteArrayInputStream(escapedSource.getBytes("UTF-8"));
            targetIs = new UnsyncByteArrayInputStream(escapedTarget.getBytes("UTF-8"));
        }
        if (DocumentConversionUtil.isEnabled() && DocumentConversionUtil.isConvertBeforeCompare(extension)) {
            String sourceTempFileId = DLUtil.getTempFileId((long)fileEntryId, (String)sourceVersion);
            String targetTempFileId = DLUtil.getTempFileId((long)fileEntryId, (String)targetVersion);
            sourceIs = new FileInputStream(DocumentConversionUtil.convert(sourceTempFileId, sourceIs, extension, "txt"));
            targetIs = new FileInputStream(DocumentConversionUtil.convert(targetTempFileId, targetIs, extension, "txt"));
        }
        List[] diffResults = DiffUtil.diff((Reader)new InputStreamReader(sourceIs), (Reader)new InputStreamReader(targetIs));
        renderRequest.setAttribute("SOURCE_NAME", (Object)(String.valueOf(sourceTitle) + " " + sourceVersion));
        renderRequest.setAttribute("TARGET_NAME", (Object)(String.valueOf(targetTitle) + " " + targetVersion));
        renderRequest.setAttribute("DIFF_RESULTS", (Object)diffResults);
    }
}

