/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.util.comparator;

import com.liferay.portal.kernel.util.Time;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.util.CalUtil;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTimeComparator
implements Comparator<CalEvent> {
    private TimeZone _timeZone;
    private Locale _locale;

    public EventTimeComparator(TimeZone timeZone, Locale locale) {
        this._timeZone = timeZone;
        this._locale = locale;
    }

    @Override
    public int compare(CalEvent event1, CalEvent event2) {
        Date endDate2;
        Date startDate2;
        boolean allDay1 = CalUtil.isAllDay(event1, this._timeZone, this._locale);
        boolean allDay2 = CalUtil.isAllDay(event2, this._timeZone, this._locale);
        if (allDay1 && allDay2) {
            return this.compareTitle(event1, event2);
        }
        if (allDay1) {
            return -1;
        }
        if (allDay2) {
            return 1;
        }
        Date startDate1 = this.getStartDate(event1, this._timeZone);
        int value = startDate1.compareTo(startDate2 = this.getStartDate(event2, this._timeZone));
        if (value != 0) {
            return value;
        }
        Date endDate1 = this.getEndDate(event1, this._timeZone);
        value = endDate1.compareTo(endDate2 = this.getEndDate(event2, this._timeZone));
        if (value != 0) {
            return value;
        }
        return this.compareTitle(event1, event2);
    }

    protected int compareTitle(CalEvent event1, CalEvent event2) {
        return event1.getTitle().toLowerCase().compareTo(event2.getTitle().toLowerCase());
    }

    protected Date getEndDate(CalEvent event, TimeZone timeZone) {
        if (event.isTimeZoneSensitive()) {
            return Time.getDate((Date)CalUtil.getEndTime(event), (TimeZone)timeZone);
        }
        return CalUtil.getEndTime(event);
    }

    protected Date getStartDate(CalEvent event, TimeZone timeZone) {
        if (event.isTimeZoneSensitive()) {
            return Time.getDate((Date)event.getStartDate(), (TimeZone)timeZone);
        }
        return event.getStartDate();
    }
}

