/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.util;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class CalIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{CalEvent.class.getName()};
    public static final String PORTLET_ID = "8";
    private static final boolean _PERMISSION_AWARE = true;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean isPermissionAware() {
        return true;
    }

    protected void doDelete(Object obj) throws Exception {
        CalEvent event = (CalEvent)obj;
        this.deleteDocument(event.getCompanyId(), event.getEventId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        CalEvent event = (CalEvent)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)event);
        document.addText("description", HtmlUtil.extractText((String)event.getDescription()));
        document.addText("title", event.getTitle());
        document.addKeyword("type", event.getType());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("description"), (int)200);
        }
        String eventId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/calendar/view_event");
        portletURL.setParameter("eventId", eventId);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        CalEvent event = (CalEvent)obj;
        Document document = this.getDocument(event);
        SearchEngineUtil.updateDocument((long)event.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        CalEvent event = CalEventLocalServiceUtil.getEvent((long)classPK);
        this.doReindex(event);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexEvents(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEvents(long companyId) throws Exception {
        int count = CalEventLocalServiceUtil.getCompanyEventsCount((long)companyId);
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            this.reindexEvents(companyId, start, end);
            ++i;
        }
    }

    protected void reindexEvents(long companyId, int start, int end) throws Exception {
        List events = CalEventLocalServiceUtil.getCompanyEvents((long)companyId, (int)start, (int)end);
        if (events.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (CalEvent event : events) {
            Document document = this.getDocument(event);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }
}

