/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.service.impl;

import com.liferay.portal.im.AIMConnector;
import com.liferay.portal.im.ICQConnector;
import com.liferay.portal.im.MSNConnector;
import com.liferay.portal.im.YMConnector;
import com.liferay.portal.kernel.cal.DayAndPosition;
import com.liferay.portal.kernel.cal.Duration;
import com.liferay.portal.kernel.cal.TZSRecurrence;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.calendar.EventDurationException;
import com.liferay.portlet.calendar.EventEndDateException;
import com.liferay.portlet.calendar.EventStartDateException;
import com.liferay.portlet.calendar.EventTitleException;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.model.CalEventConstants;
import com.liferay.portlet.calendar.service.base.CalEventLocalServiceBaseImpl;
import com.liferay.portlet.calendar.service.impl.CalEventLocalUtil;
import com.liferay.portlet.calendar.util.CalUtil;
import com.liferay.util.TimeZoneSensitive;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.mail.internet.InternetAddress;
import javax.portlet.PortletPreferences;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Comment;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalEventLocalServiceImpl
extends CalEventLocalServiceBaseImpl {
    private long _CALENDAR_EVENT_CHECK_INTERVAL = (long)PropsValues.CALENDAR_EVENT_CHECK_INTERVAL * 60000L;
    private static Log _log = LogFactoryUtil.getLog(CalEventLocalServiceImpl.class);

    public CalEvent addEvent(long userId, String title, String description, String location, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int endDateMonth, int endDateDay, int endDateYear, int durationHour, int durationMinute, boolean allDay, boolean timeZoneSensitive, String type, boolean repeating, TZSRecurrence recurrence, int remindBy, int firstReminder, int secondReminder, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date now = new Date();
        Locale locale = null;
        TimeZone timeZone = null;
        if (timeZoneSensitive) {
            locale = user.getLocale();
            timeZone = user.getTimeZone();
        } else {
            locale = LocaleUtil.getDefault();
            timeZone = TimeZoneUtil.getDefault();
        }
        Calendar startDate = CalendarFactoryUtil.getCalendar((TimeZone)timeZone, (Locale)locale);
        startDate.set(2, startDateMonth);
        startDate.set(5, startDateDay);
        startDate.set(1, startDateYear);
        startDate.set(11, startDateHour);
        startDate.set(12, startDateMinute);
        startDate.set(13, 0);
        startDate.set(14, 0);
        Calendar endDate = CalendarFactoryUtil.getCalendar((TimeZone)timeZone, (Locale)locale);
        endDate.set(2, endDateMonth);
        endDate.set(5, endDateDay);
        endDate.set(1, endDateYear);
        endDate.set(11, 23);
        endDate.set(12, 59);
        endDate.set(13, 59);
        endDate.set(14, 990);
        if (allDay) {
            startDate.set(11, 0);
            startDate.set(12, 0);
            durationHour = 24;
            durationMinute = 0;
        }
        this.validate(title, startDateMonth, startDateDay, startDateYear, endDateMonth, endDateDay, endDateYear, durationHour, durationMinute, allDay, repeating, recurrence);
        long eventId = this.counterLocalService.increment();
        CalEvent event = this.calEventPersistence.create(eventId);
        event.setUuid(serviceContext.getUuid());
        event.setGroupId(groupId);
        event.setCompanyId(user.getCompanyId());
        event.setUserId(user.getUserId());
        event.setUserName(user.getFullName());
        event.setCreateDate(serviceContext.getCreateDate(now));
        event.setModifiedDate(serviceContext.getModifiedDate(now));
        event.setTitle(title);
        event.setDescription(description);
        event.setLocation(location);
        event.setStartDate(startDate.getTime());
        event.setEndDate(endDate.getTime());
        event.setDurationHour(durationHour);
        event.setDurationMinute(durationMinute);
        event.setAllDay(allDay);
        event.setTimeZoneSensitive(timeZoneSensitive);
        event.setType(type);
        event.setRepeating(repeating);
        event.setRecurrenceObj(recurrence);
        event.setRemindBy(remindBy);
        event.setFirstReminder(firstReminder);
        event.setSecondReminder(secondReminder);
        event.setExpandoBridgeAttributes(serviceContext);
        this.calEventPersistence.update((BaseModel)event, false);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addEventResources(event, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addEventResources(event, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        this.updateAsset(userId, event, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this.socialActivityLocalService.addActivity(userId, groupId, CalEvent.class.getName(), eventId, 1, "", 0L);
        Indexer indexer = IndexerRegistryUtil.getIndexer(CalEvent.class);
        indexer.reindex((Object)event);
        CalEventLocalUtil.clearEventsPool(event.getGroupId());
        return event;
    }

    public void addEventResources(CalEvent event, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(event.getCompanyId(), event.getGroupId(), event.getUserId(), CalEvent.class.getName(), event.getEventId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addEventResources(CalEvent event, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(event.getCompanyId(), event.getGroupId(), event.getUserId(), CalEvent.class.getName(), event.getEventId(), groupPermissions, guestPermissions);
    }

    public void addEventResources(long eventId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        CalEvent event = this.calEventPersistence.findByPrimaryKey(eventId);
        this.addEventResources(event, addGroupPermissions, addGuestPermissions);
    }

    public void addEventResources(long eventId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        CalEvent event = this.calEventPersistence.findByPrimaryKey(eventId);
        this.addEventResources(event, groupPermissions, guestPermissions);
    }

    public void checkEvents() throws PortalException, SystemException {
        List events = this.calEventFinder.findByFutureReminders();
        for (CalEvent event : events) {
            User user = this.userPersistence.fetchByPrimaryKey(event.getUserId());
            if (user == null) {
                this.deleteEvent(event);
                continue;
            }
            Calendar now = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone(), (Locale)user.getLocale());
            if (!event.isTimeZoneSensitive()) {
                Calendar temp = CalendarFactoryUtil.getCalendar();
                temp.setTime(Time.getDate((Calendar)now));
                now = temp;
            }
            Calendar startDate = null;
            startDate = event.isTimeZoneSensitive() ? CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone(), (Locale)user.getLocale()) : CalendarFactoryUtil.getCalendar();
            if (event.isRepeating()) {
                double daysToCheck = Math.ceil(CalEventConstants.REMINDERS[CalEventConstants.REMINDERS.length - 1] / 86400000L);
                Calendar cal = (Calendar)now.clone();
                int i = 0;
                while ((double)i <= daysToCheck) {
                    TZSRecurrence recurrence = event.getRecurrenceObj();
                    Calendar tzICal = CalendarFactoryUtil.getCalendar((TimeZone)TimeZoneUtil.getTimeZone((String)"UTC"));
                    tzICal.set(cal.get(1), cal.get(2), cal.get(5));
                    Calendar recurrenceCal = this.getRecurrenceCal(cal, tzICal, event);
                    if (recurrence.isInRecurrence(recurrenceCal)) {
                        this.remindUser(event, user, recurrenceCal, now);
                    }
                    cal.add(6, 1);
                    ++i;
                }
                continue;
            }
            startDate.setTime(event.getStartDate());
            this.remindUser(event, user, startDate, now);
        }
    }

    public void deleteEvent(CalEvent event) throws PortalException, SystemException {
        this.calEventPersistence.remove((BaseModel)event);
        this.resourceLocalService.deleteResource(event.getCompanyId(), CalEvent.class.getName(), 4, event.getEventId());
        this.assetEntryLocalService.deleteEntry(CalEvent.class.getName(), event.getEventId());
        this.expandoValueLocalService.deleteValues(CalEvent.class.getName(), event.getEventId());
        Indexer indexer = IndexerRegistryUtil.getIndexer(CalEvent.class);
        indexer.delete((Object)event);
        CalEventLocalUtil.clearEventsPool(event.getGroupId());
    }

    public void deleteEvent(long eventId) throws PortalException, SystemException {
        CalEvent event = this.calEventPersistence.findByPrimaryKey(eventId);
        this.deleteEvent(event);
    }

    public void deleteEvents(long groupId) throws PortalException, SystemException {
        for (CalEvent event : this.calEventPersistence.findByGroupId(groupId)) {
            this.deleteEvent(event);
        }
    }

    public File exportEvent(long userId, long eventId) throws PortalException, SystemException {
        ArrayList<CalEvent> events = new ArrayList<CalEvent>();
        CalEvent event = this.calEventPersistence.findByPrimaryKey(eventId);
        events.add(event);
        return this.exportICal4j(this.toICalCalendar(userId, events), null);
    }

    public File exportGroupEvents(long userId, long groupId, String fileName) throws PortalException, SystemException {
        List events = this.calEventPersistence.findByGroupId(groupId);
        return this.exportICal4j(this.toICalCalendar(userId, events), fileName);
    }

    public List<CalEvent> getCompanyEvents(long companyId, int start, int end) throws SystemException {
        return this.calEventPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyEventsCount(long companyId) throws SystemException {
        return this.calEventPersistence.countByCompanyId(companyId);
    }

    public CalEvent getEvent(long eventId) throws PortalException, SystemException {
        return this.calEventPersistence.findByPrimaryKey(eventId);
    }

    public List<CalEvent> getEvents(long groupId, Calendar cal) throws SystemException {
        return this.getEvents(groupId, cal, new String[0]);
    }

    public List<CalEvent> getEvents(long groupId, Calendar cal, String type) throws SystemException {
        return this.getEvents(groupId, cal, new String[]{type});
    }

    public List<CalEvent> getEvents(long groupId, Calendar cal, String[] types) throws SystemException {
        String key;
        Map<String, List<CalEvent>> eventsPool;
        UnmodifiableList events;
        if (types != null) {
            types = ArrayUtil.distinct((String[])types);
            Arrays.sort(types);
        }
        if ((events = (eventsPool = CalEventLocalUtil.getEventsPool(groupId)).get(key = CalUtil.toString(cal, types))) == null) {
            List events1 = this.calEventFinder.findByG_SD_T(groupId, CalendarUtil.getGTDate((Calendar)cal), CalendarUtil.getLTDate((Calendar)cal), true, types);
            Calendar tzICal = CalendarFactoryUtil.getCalendar((TimeZone)TimeZoneUtil.getTimeZone((String)"UTC"));
            tzICal.set(cal.get(1), cal.get(2), cal.get(5));
            List events2 = this.calEventFinder.findByG_SD_T(groupId, CalendarUtil.getGTDate((Calendar)tzICal), CalendarUtil.getLTDate((Calendar)tzICal), false, types);
            events = new ArrayList<CalEvent>();
            events.addAll(events1);
            events.addAll(events2);
            events.addAll(this.getRepeatingEvents(groupId, cal, types));
            events = new UnmodifiableList(events);
            eventsPool.put(key, (List<CalEvent>)events);
        }
        return events;
    }

    public List<CalEvent> getEvents(long groupId, String type, int start, int end) throws SystemException {
        return this.getEvents(groupId, new String[]{type}, start, end);
    }

    public List<CalEvent> getEvents(long groupId, String[] types, int start, int end) throws SystemException {
        if (types != null && types.length > 0 && (types.length > 1 || Validator.isNotNull((String)types[0]))) {
            return this.calEventPersistence.findByG_T(groupId, types, start, end);
        }
        return this.calEventPersistence.findByGroupId(groupId, start, end);
    }

    public int getEventsCount(long groupId, String type) throws SystemException {
        return this.getEventsCount(groupId, new String[]{type});
    }

    public int getEventsCount(long groupId, String[] types) throws SystemException {
        if (types != null && types.length > 0 && (types.length > 1 || Validator.isNotNull((String)types[0]))) {
            return this.calEventPersistence.countByG_T(groupId, types);
        }
        return this.calEventPersistence.countByGroupId(groupId);
    }

    public List<CalEvent> getNoAssetEvents() throws SystemException {
        return this.calEventFinder.findByNoAssets();
    }

    public List<CalEvent> getRepeatingEvents(long groupId) throws SystemException {
        return this.getRepeatingEvents(groupId, null, null);
    }

    public List<CalEvent> getRepeatingEvents(long groupId, Calendar cal, String[] types) throws SystemException {
        String key;
        Map<String, List<CalEvent>> eventsPool = CalEventLocalUtil.getEventsPool(groupId);
        List events = eventsPool.get(key = "recurrence".concat(CalUtil.toString(null, types)));
        if (events == null) {
            events = types != null && types.length > 0 && (types.length > 1 || Validator.isNotNull((String)types[0])) ? this.calEventPersistence.findByG_T_R(groupId, types, true) : this.calEventPersistence.findByG_R(groupId, true);
            events = new UnmodifiableList(events);
            eventsPool.put(key, events);
        }
        if (cal != null) {
            Calendar tzICal = CalendarFactoryUtil.getCalendar((TimeZone)TimeZoneUtil.getTimeZone((String)"UTC"));
            tzICal.set(cal.get(1), cal.get(2), cal.get(5));
            Iterator itr = events.iterator();
            ArrayList<CalEvent> repeatingEvents = new ArrayList<CalEvent>();
            while (itr.hasNext()) {
                CalEvent event = (CalEvent)itr.next();
                TZSRecurrence recurrence = event.getRecurrenceObj();
                try {
                    if (recurrence.getFrequency() != 7 && recurrence.getInterval() <= 0) {
                        recurrence.setInterval(1);
                        event.setRecurrenceObj(recurrence);
                        event = (CalEvent)this.calEventPersistence.update((BaseModel)event, false);
                        recurrence = event.getRecurrenceObj();
                    }
                    if (!recurrence.isInRecurrence(this.getRecurrenceCal(cal, tzICal, event))) continue;
                    repeatingEvents.add(event);
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
            events = new UnmodifiableList(repeatingEvents);
        }
        return events;
    }

    public boolean hasEvents(long groupId, Calendar cal) throws SystemException {
        return this.hasEvents(groupId, cal, new String[0]);
    }

    public boolean hasEvents(long groupId, Calendar cal, String type) throws SystemException {
        return this.hasEvents(groupId, cal, new String[]{type});
    }

    public boolean hasEvents(long groupId, Calendar cal, String[] types) throws SystemException {
        List<CalEvent> events = this.getEvents(groupId, cal, types);
        return !events.isEmpty();
    }

    public void importICal4j(long userId, long groupId, InputStream inputStream) throws PortalException, SystemException {
        try {
            CalendarBuilder builder = new CalendarBuilder();
            net.fortuna.ical4j.model.Calendar calendar = builder.build(inputStream);
            for (VEvent vEvent : calendar.getComponents("VEVENT")) {
                this.importICal4j(userId, groupId, vEvent);
            }
        }
        catch (IOException ioe) {
            throw new SystemException(ioe.getMessage(), (Throwable)ioe);
        }
        catch (ParserException pe) {
            throw new SystemException(pe.getMessage(), (Throwable)pe);
        }
    }

    public void updateAsset(long userId, CalEvent event, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, event.getGroupId(), CalEvent.class.getName(), event.getEventId(), event.getUuid(), 0L, assetCategoryIds, assetTagNames, true, null, null, null, null, "text/html", event.getTitle(), event.getDescription(), null, null, null, 0, 0, null, false);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    public CalEvent updateEvent(long userId, long eventId, String title, String description, String location, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int endDateMonth, int endDateDay, int endDateYear, int durationHour, int durationMinute, boolean allDay, boolean timeZoneSensitive, String type, boolean repeating, TZSRecurrence recurrence, int remindBy, int firstReminder, int secondReminder, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Locale locale = null;
        TimeZone timeZone = null;
        if (timeZoneSensitive) {
            locale = user.getLocale();
            timeZone = user.getTimeZone();
        } else {
            locale = LocaleUtil.getDefault();
            timeZone = TimeZoneUtil.getDefault();
        }
        Calendar startDate = CalendarFactoryUtil.getCalendar((TimeZone)timeZone, (Locale)locale);
        startDate.set(2, startDateMonth);
        startDate.set(5, startDateDay);
        startDate.set(1, startDateYear);
        startDate.set(11, startDateHour);
        startDate.set(12, startDateMinute);
        startDate.set(13, 0);
        startDate.set(14, 0);
        Calendar endDate = CalendarFactoryUtil.getCalendar((TimeZone)timeZone, (Locale)locale);
        endDate.set(2, endDateMonth);
        endDate.set(5, endDateDay);
        endDate.set(1, endDateYear);
        endDate.set(11, 23);
        endDate.set(12, 59);
        endDate.set(13, 59);
        endDate.set(14, 990);
        if (allDay) {
            startDate.set(11, 0);
            startDate.set(12, 0);
            durationHour = 24;
            durationMinute = 0;
        }
        this.validate(title, startDateMonth, startDateDay, startDateYear, endDateMonth, endDateDay, endDateYear, durationHour, durationMinute, allDay, repeating, recurrence);
        CalEvent event = this.calEventPersistence.findByPrimaryKey(eventId);
        event.setModifiedDate(serviceContext.getModifiedDate(null));
        event.setTitle(title);
        event.setDescription(description);
        event.setLocation(location);
        event.setStartDate(startDate.getTime());
        event.setEndDate(endDate.getTime());
        event.setDurationHour(durationHour);
        event.setDurationMinute(durationMinute);
        event.setAllDay(allDay);
        event.setTimeZoneSensitive(timeZoneSensitive);
        event.setType(type);
        event.setRepeating(repeating);
        event.setRecurrenceObj(recurrence);
        event.setRemindBy(remindBy);
        event.setFirstReminder(firstReminder);
        event.setSecondReminder(secondReminder);
        event.setExpandoBridgeAttributes(serviceContext);
        this.calEventPersistence.update((BaseModel)event, false);
        this.updateAsset(userId, event, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this.socialActivityLocalService.addActivity(userId, event.getGroupId(), CalEvent.class.getName(), eventId, 2, "", 0L);
        Indexer indexer = IndexerRegistryUtil.getIndexer(CalEvent.class);
        indexer.reindex((Object)event);
        CalEventLocalUtil.clearEventsPool(event.getGroupId());
        return event;
    }

    protected File exportICal4j(net.fortuna.ical4j.model.Calendar cal, String fileName) throws SystemException {
        File file;
        UnsyncBufferedOutputStream os = null;
        try {
            String extension = ".ics";
            if (Validator.isNull((String)fileName)) {
                fileName = "liferay.";
            } else {
                int pos = fileName.lastIndexOf(46);
                if (pos != -1) {
                    extension = fileName.substring(pos);
                    fileName = fileName.substring(0, pos);
                }
            }
            fileName = FileUtil.getShortFileName((String)fileName);
            File file2 = File.createTempFile(fileName, extension);
            os = new UnsyncBufferedOutputStream((OutputStream)new FileOutputStream(file2.getPath()));
            CalendarOutputter calOutput = new CalendarOutputter();
            if (cal.getComponents().isEmpty()) {
                calOutput.setValidating(false);
            }
            calOutput.output(cal, (OutputStream)os);
            file = file2;
        }
        catch (Exception e) {
            try {
                _log.error((Object)e, (Throwable)e);
                throw new SystemException((Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(os);
                throw throwable;
            }
        }
        StreamUtil.cleanUp((OutputStream)os);
        return file;
    }

    protected Calendar getRecurrenceCal(Calendar cal, Calendar tzICal, CalEvent event) {
        Calendar eventCal = CalendarFactoryUtil.getCalendar((TimeZone)TimeZoneUtil.getTimeZone((String)"UTC"));
        eventCal.setTime(event.getStartDate());
        Calendar recurrenceCal = (Calendar)tzICal.clone();
        recurrenceCal.set(11, eventCal.get(11));
        recurrenceCal.set(12, eventCal.get(12));
        recurrenceCal.set(13, 0);
        recurrenceCal.set(14, 0);
        if (event.isTimeZoneSensitive()) {
            int gmtDate = eventCal.get(5);
            long gmtMills = eventCal.getTimeInMillis();
            eventCal.setTimeZone(cal.getTimeZone());
            int tziDate = eventCal.get(5);
            long tziMills = Time.getDate((Calendar)eventCal).getTime();
            if (gmtDate != tziDate) {
                int diffDate = 0;
                diffDate = gmtMills > tziMills ? (int)Math.ceil((double)(gmtMills - tziMills) / 8.64E7) : (int)Math.floor((double)(gmtMills - tziMills) / 8.64E7);
                recurrenceCal.add(5, diffDate);
            }
        }
        return recurrenceCal;
    }

    protected void importICal4j(long userId, long groupId, VEvent event) throws PortalException, SystemException {
        Uid uid;
        User user = this.userPersistence.findByPrimaryKey(userId);
        TimeZone timeZone = user.getTimeZone();
        Property timeZoneXProperty = event.getProperty("X-LIFERAY-TIMEZONE-SENSITIVE");
        boolean timeZoneXPropertyValue = true;
        if (timeZoneXProperty != null && timeZoneXProperty.getValue().equals("FALSE")) {
            timeZoneXPropertyValue = false;
        }
        String title = "";
        if (event.getSummary() != null) {
            title = ModelHintsUtil.trimString((String)CalEvent.class.getName(), (String)"title", (String)event.getSummary().getValue());
        }
        String description = "";
        if (event.getDescription() != null) {
            description = event.getDescription().getValue();
        }
        String location = "";
        if (event.getLocation() != null) {
            location = event.getLocation().getValue();
        }
        DtStart dtStart = event.getStartDate();
        Calendar startDate = this.toCalendar((DateProperty)dtStart, timeZone, timeZoneXPropertyValue);
        startDate.setTime((Date)dtStart.getDate());
        Calendar endDate = null;
        DtEnd dtEnd = event.getEndDate(true);
        RRule rrule = (RRule)event.getProperty("RRULE");
        if (dtEnd != null) {
            endDate = this.toCalendar((DateProperty)dtEnd, timeZone, timeZoneXPropertyValue);
            endDate.setTime((Date)dtEnd.getDate());
        } else {
            endDate = (Calendar)startDate.clone();
            endDate.add(5, 1);
        }
        long diffMillis = 0L;
        long durationHours = 24L;
        long durationMins = 0L;
        boolean multiDayEvent = false;
        if (dtEnd != null) {
            diffMillis = dtEnd.getDate().getTime() - startDate.getTimeInMillis();
            durationHours = diffMillis / 3600000L;
            durationMins = diffMillis / 60000L - durationHours * 60L;
            if (durationHours > 24L || durationHours == 24L && durationMins > 0L) {
                durationHours = 24L;
                durationMins = 0L;
                multiDayEvent = true;
            }
        }
        boolean allDay = false;
        if (this.isICal4jDateOnly((DateProperty)event.getStartDate()) || multiDayEvent) {
            allDay = true;
        }
        boolean timeZoneSensitive = true;
        if (allDay || !timeZoneXPropertyValue) {
            timeZoneSensitive = false;
        }
        String type = "";
        Property comment = event.getProperty("COMMENT");
        if (comment != null && ArrayUtil.contains((Object[])CalEventConstants.TYPES, (Object)comment.getValue())) {
            type = comment.getValue();
        }
        boolean repeating = false;
        TZSRecurrence recurrence = null;
        if (multiDayEvent) {
            repeating = true;
            Calendar recStartCal = CalendarFactoryUtil.getCalendar((TimeZone)TimeZoneUtil.getTimeZone((String)"UTC"));
            recStartCal.setTime(startDate.getTime());
            Duration duration = new Duration(1, 0, 0, 0);
            recurrence = new TZSRecurrence(recStartCal, duration, 3);
            Calendar until = CalendarFactoryUtil.getCalendar((TimeZone)TimeZoneUtil.getTimeZone((String)"UTC"));
            until.setTimeInMillis(until.getTimeInMillis() + diffMillis);
            recurrence.setUntil(until);
            endDate.setTime(recurrence.getUntil().getTime());
        } else if (rrule != null) {
            repeating = true;
            recurrence = this.toRecurrence(rrule, startDate);
            if (recurrence.getUntil() != null) {
                endDate.setTime(recurrence.getUntil().getTime());
            }
        }
        int remindBy = 0;
        int firstReminder = 300000;
        int secondReminder = 300000;
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        String uuid = null;
        CalEvent existingEvent = null;
        if (event.getUid() != null && (existingEvent = this.calEventPersistence.fetchByUUID_G(uuid = (uid = event.getUid()).getValue(), groupId)) == null) {
            uuid = PortalUUIDUtil.generate((byte[])uid.getValue().getBytes());
            existingEvent = this.calEventPersistence.fetchByUUID_G(uuid, groupId);
        }
        int startDateMonth = startDate.get(2);
        int startDateDay = startDate.get(5);
        int startDateYear = startDate.get(1);
        int startDateHour = startDate.get(11);
        int startDateMinute = startDate.get(12);
        int endDateMonth = endDate.get(2);
        int endDateDay = endDate.get(5);
        int endDateYear = endDate.get(1);
        int durationHour = (int)durationHours;
        int durationMinute = (int)durationMins;
        if (existingEvent == null) {
            serviceContext.setUuid(uuid);
            this.addEvent(userId, title, description, location, startDateMonth, startDateDay, startDateYear, startDateHour, startDateMinute, endDateMonth, endDateDay, endDateYear, durationHour, durationMinute, allDay, timeZoneSensitive, type, repeating, recurrence, remindBy, firstReminder, secondReminder, serviceContext);
        } else {
            this.updateEvent(userId, existingEvent.getEventId(), title, description, location, startDateMonth, startDateDay, startDateYear, startDateHour, startDateMinute, endDateMonth, endDateDay, endDateYear, durationHour, durationMinute, allDay, timeZoneSensitive, type, repeating, recurrence, remindBy, firstReminder, secondReminder, serviceContext);
        }
    }

    protected boolean isICal4jDateOnly(DateProperty dateProperty) {
        Parameter valueParameter = dateProperty.getParameter("VALUE");
        return valueParameter != null && valueParameter.getValue().equals("DATE");
    }

    protected void remindUser(CalEvent event, User user, Calendar startDate) {
        int remindBy = event.getRemindBy();
        if (remindBy == 0) {
            return;
        }
        try {
            long ownerId = event.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "8";
            PortletPreferences preferences = this.portletPreferencesLocalService.getPreferences(event.getCompanyId(), ownerId, ownerType, plid, portletId);
            Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
            Contact contact = user.getContact();
            String portletName = PortalUtil.getPortletTitle((String)"8", (User)user);
            String fromName = CalUtil.getEmailFromName(preferences, event.getCompanyId());
            String fromAddress = CalUtil.getEmailFromAddress(preferences, event.getCompanyId());
            String toName = user.getFullName();
            String toAddress = user.getEmailAddress();
            if (remindBy == 2) {
                toAddress = contact.getSmsSn();
            }
            String subject = CalUtil.getEmailEventReminderSubject(preferences);
            String body = CalUtil.getEmailEventReminderBody(preferences);
            Format dateFormatDateTime = FastDateFormatFactoryUtil.getDateTime((Locale)user.getLocale(), (TimeZone)user.getTimeZone());
            subject = StringUtil.replace((String)subject, (String[])new String[]{"[$EVENT_LOCATION$]", "[$EVENT_START_DATE$]", "[$EVENT_TITLE$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]", "[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{event.getLocation(), dateFormatDateTime.format(startDate.getTime()), event.getTitle(), fromAddress, fromName, company.getPortalURL(event.getGroupId()), portletName, HtmlUtil.escape((String)toAddress), HtmlUtil.escape((String)toName)});
            body = StringUtil.replace((String)body, (String[])new String[]{"[$EVENT_LOCATION$]", "[$EVENT_START_DATE$]", "[$EVENT_TITLE$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]", "[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{event.getLocation(), dateFormatDateTime.format(startDate.getTime()), event.getTitle(), fromAddress, fromName, company.getPortalURL(event.getGroupId()), portletName, HtmlUtil.escape((String)toAddress), HtmlUtil.escape((String)toName)});
            if (remindBy == 1 || remindBy == 2) {
                InternetAddress from = new InternetAddress(fromAddress, fromName);
                InternetAddress to = new InternetAddress(toAddress, toName);
                MailMessage message = new MailMessage(from, to, subject, body, true);
                this.mailService.sendEmail(message);
            } else if (remindBy == 3 && Validator.isNotNull((String)contact.getAimSn())) {
                AIMConnector.send(contact.getAimSn(), body);
            } else if (remindBy == 4 && Validator.isNotNull((String)contact.getIcqSn())) {
                ICQConnector.send(contact.getIcqSn(), body);
            } else if (remindBy == 5 && Validator.isNotNull((String)contact.getMsnSn())) {
                MSNConnector.send(contact.getMsnSn(), body);
            } else if (remindBy == 6 && Validator.isNotNull((String)contact.getYmSn())) {
                YMConnector.send(contact.getYmSn(), body);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void remindUser(CalEvent event, User user, Calendar startDate, Calendar now) {
        long diff = (startDate.getTime().getTime() - now.getTime().getTime()) / this._CALENDAR_EVENT_CHECK_INTERVAL;
        if (diff == (long)event.getFirstReminder() / this._CALENDAR_EVENT_CHECK_INTERVAL || diff == (long)event.getSecondReminder() / this._CALENDAR_EVENT_CHECK_INTERVAL) {
            this.remindUser(event, user, startDate);
        }
    }

    protected Calendar toCalendar(DateProperty date, TimeZone timeZone, boolean timeZoneSensitive) {
        Calendar cal = null;
        cal = this.isICal4jDateOnly(date) ? Calendar.getInstance() : (!timeZoneSensitive ? Calendar.getInstance(TimeZoneUtil.getTimeZone((String)"UTC")) : Calendar.getInstance(timeZone));
        return cal;
    }

    protected int toCalendarWeekDay(WeekDay weekDay) {
        int dayOfWeeek = 0;
        if (weekDay.getDay().equals(WeekDay.SU.getDay())) {
            dayOfWeeek = 1;
        } else if (weekDay.getDay().equals(WeekDay.MO.getDay())) {
            dayOfWeeek = 2;
        } else if (weekDay.getDay().equals(WeekDay.TU.getDay())) {
            dayOfWeeek = 3;
        } else if (weekDay.getDay().equals(WeekDay.WE.getDay())) {
            dayOfWeeek = 4;
        } else if (weekDay.getDay().equals(WeekDay.TH.getDay())) {
            dayOfWeeek = 5;
        } else if (weekDay.getDay().equals(WeekDay.FR.getDay())) {
            dayOfWeeek = 6;
        } else if (weekDay.getDay().equals(WeekDay.SA.getDay())) {
            dayOfWeeek = 7;
        }
        return dayOfWeeek;
    }

    protected net.fortuna.ical4j.model.Calendar toICalCalendar(long userId, List<CalEvent> events) throws PortalException, SystemException {
        net.fortuna.ical4j.model.Calendar iCal = new net.fortuna.ical4j.model.Calendar();
        ProdId prodId = new ProdId("-//Liferay Inc//Liferay Portal " + ReleaseInfo.getVersion() + "//EN");
        PropertyList propertiesList = iCal.getProperties();
        propertiesList.add((Property)prodId);
        propertiesList.add((Property)Version.VERSION_2_0);
        propertiesList.add((Property)CalScale.GREGORIAN);
        propertiesList.add((Property)Method.PUBLISH);
        User user = this.userPersistence.findByPrimaryKey(userId);
        TimeZone timeZone = user.getTimeZone();
        ComponentList components = iCal.getComponents();
        for (CalEvent event : events) {
            components.add(this.toICalVEvent(event, timeZone));
        }
        return iCal;
    }

    protected Recur toICalRecurrence(TZSRecurrence recurrence) {
        Calendar until;
        DayAndPosition[] byDay;
        Recur recur = null;
        int recurrenceType = recurrence.getFrequency();
        int interval = recurrence.getInterval();
        if (recurrenceType == 3) {
            recur = new Recur("DAILY", -1);
            if (interval >= 1) {
                recur.setInterval(interval);
            }
            if ((byDay = recurrence.getByDay()) != null) {
                int i = 0;
                while (i < byDay.length) {
                    WeekDay weekDay = this.toICalWeekDay(byDay[i].getDayOfWeek());
                    recur.getDayList().add(weekDay);
                    ++i;
                }
            }
        } else if (recurrenceType == 4) {
            recur = new Recur("WEEKLY", -1);
            recur.setInterval(interval);
            byDay = recurrence.getByDay();
            if (byDay != null) {
                int i = 0;
                while (i < byDay.length) {
                    WeekDay weekDay = this.toICalWeekDay(byDay[i].getDayOfWeek());
                    recur.getDayList().add(weekDay);
                    ++i;
                }
            }
        } else if (recurrenceType == 5) {
            recur = new Recur("MONTHLY", -1);
            recur.setInterval(interval);
            int[] byMonthDay = recurrence.getByMonthDay();
            if (byMonthDay != null) {
                Integer monthDay = new Integer(byMonthDay[0]);
                recur.getMonthDayList().add(monthDay);
            } else if (recurrence.getByDay() != null) {
                DayAndPosition[] byDay2 = recurrence.getByDay();
                WeekDay weekDay = this.toICalWeekDay(byDay2[0].getDayOfWeek());
                recur.getDayList().add(weekDay);
                Integer position = new Integer(byDay2[0].getDayPosition());
                recur.getSetPosList().add(position);
            }
        } else if (recurrenceType == 6) {
            recur = new Recur("YEARLY", -1);
            recur.setInterval(interval);
        }
        if ((until = recurrence.getUntil()) != null) {
            DateTime dateTime = new DateTime(until.getTime());
            recur.setUntil((net.fortuna.ical4j.model.Date)dateTime);
        }
        return recur;
    }

    protected VEvent toICalVEvent(CalEvent event, TimeZone timeZone) {
        DtStart dtStart;
        VEvent vEvent = new VEvent();
        PropertyList eventProps = vEvent.getProperties();
        Uid uid = new Uid(event.getUuid());
        eventProps.add((Property)uid);
        if (event.isAllDay()) {
            dtStart = new DtStart(new net.fortuna.ical4j.model.Date(event.getStartDate()));
            eventProps.add((Property)dtStart);
        } else {
            dtStart = new DtStart((net.fortuna.ical4j.model.Date)new DateTime(event.getStartDate()));
            eventProps.add((Property)dtStart);
            Dur dur = new Dur(0, event.getDurationHour(), event.getDurationMinute(), 0);
            DtEnd dtEnd = new DtEnd((net.fortuna.ical4j.model.Date)new DateTime(dur.getTime(event.getStartDate())));
            eventProps.add((Property)dtEnd);
        }
        Summary summary = new Summary(event.getTitle());
        eventProps.add((Property)summary);
        Description description = new Description(event.getDescription());
        eventProps.add((Property)description);
        Location location = new Location(event.getLocation());
        eventProps.add((Property)location);
        Comment comment = new Comment(event.getType());
        eventProps.add((Property)comment);
        if (event.isRepeating()) {
            Recur recur = this.toICalRecurrence(event.getRecurrenceObj());
            RRule rRule = new RRule(recur);
            eventProps.add((Property)rRule);
        }
        if (!event.getTimeZoneSensitive()) {
            eventProps.add((Property)new TimeZoneSensitive("FALSE"));
        }
        return vEvent;
    }

    protected WeekDay toICalWeekDay(int dayOfWeek) {
        WeekDay weekDay = null;
        if (dayOfWeek == 1) {
            weekDay = WeekDay.SU;
        } else if (dayOfWeek == 2) {
            weekDay = WeekDay.MO;
        } else if (dayOfWeek == 3) {
            weekDay = WeekDay.TU;
        } else if (dayOfWeek == 4) {
            weekDay = WeekDay.WE;
        } else if (dayOfWeek == 5) {
            weekDay = WeekDay.TH;
        } else if (dayOfWeek == 6) {
            weekDay = WeekDay.FR;
        } else if (dayOfWeek == 7) {
            weekDay = WeekDay.SA;
        }
        return weekDay;
    }

    protected TZSRecurrence toRecurrence(RRule rRule, Calendar startDate) {
        Recur recur = rRule.getRecur();
        Calendar recStartCal = CalendarFactoryUtil.getCalendar((TimeZone)TimeZoneUtil.getTimeZone((String)"UTC"));
        recStartCal.setTime(startDate.getTime());
        TZSRecurrence recurrence = new TZSRecurrence(recStartCal, new Duration(1, 0, 0, 0));
        recurrence.setWeekStart(1);
        if (recur.getInterval() > 1) {
            recurrence.setInterval(recur.getInterval());
        }
        Calendar until = Calendar.getInstance(TimeZoneUtil.getTimeZone((String)"UTC"));
        String frequency = recur.getFrequency();
        if (recur.getUntil() != null) {
            until.setTime((Date)recur.getUntil());
            recurrence.setUntil(until);
        } else if (rRule.getValue().indexOf("COUNT") >= 0) {
            until.setTimeInMillis(startDate.getTimeInMillis());
            int addField = 0;
            if ("DAILY".equals(frequency)) {
                addField = 6;
            } else if ("WEEKLY".equals(frequency)) {
                addField = 3;
            } else if ("MONTHLY".equals(frequency)) {
                addField = 2;
            } else if ("YEARLY".equals(frequency)) {
                addField = 1;
            }
            int addAmount = recurrence.getInterval() * recur.getCount();
            until.add(addField, addAmount);
            until.add(6, -1);
            recurrence.setUntil(until);
        }
        if ("DAILY".equals(frequency)) {
            recurrence.setFrequency(3);
            ArrayList<DayAndPosition> dayPosList = new ArrayList<DayAndPosition>();
            for (WeekDay weekDay : recur.getDayList()) {
                dayPosList.add(new DayAndPosition(this.toCalendarWeekDay(weekDay), 0));
            }
            if (!dayPosList.isEmpty()) {
                recurrence.setByDay(dayPosList.toArray(new DayAndPosition[dayPosList.size()]));
            }
        } else if ("WEEKLY".equals(frequency)) {
            recurrence.setFrequency(4);
            ArrayList<DayAndPosition> dayPosList = new ArrayList<DayAndPosition>();
            for (WeekDay weekDay : recur.getDayList()) {
                dayPosList.add(new DayAndPosition(this.toCalendarWeekDay(weekDay), 0));
            }
            if (!dayPosList.isEmpty()) {
                recurrence.setByDay(dayPosList.toArray(new DayAndPosition[dayPosList.size()]));
            }
        } else if ("MONTHLY".equals(frequency)) {
            Iterator dayListItr;
            recurrence.setFrequency(5);
            Iterator monthDayListItr = recur.getMonthDayList().iterator();
            if (monthDayListItr.hasNext()) {
                Integer monthDay = (Integer)monthDayListItr.next();
                recurrence.setByMonthDay(new int[]{monthDay});
            }
            if ((dayListItr = recur.getDayList().iterator()).hasNext()) {
                WeekDay weekDay = (WeekDay)dayListItr.next();
                DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(this.toCalendarWeekDay(weekDay), weekDay.getOffset())};
                recurrence.setByDay(dayPos);
            }
        } else if ("YEARLY".equals(frequency)) {
            recurrence.setFrequency(6);
        }
        return recurrence;
    }

    protected void validate(String title, int startDateMonth, int startDateDay, int startDateYear, int endDateMonth, int endDateDay, int endDateYear, int durationHour, int durationMinute, boolean allDay, boolean repeating, TZSRecurrence recurrence) throws PortalException {
        Calendar until;
        if (Validator.isNull((String)title)) {
            throw new EventTitleException();
        }
        if (!Validator.isDate((int)startDateMonth, (int)startDateDay, (int)startDateYear)) {
            throw new EventStartDateException();
        }
        if (!Validator.isDate((int)endDateMonth, (int)endDateDay, (int)endDateYear)) {
            throw new EventEndDateException();
        }
        if (!allDay && durationHour <= 0 && durationMinute <= 0) {
            throw new EventDurationException();
        }
        Calendar startDate = CalendarFactoryUtil.getCalendar((int)startDateYear, (int)startDateMonth, (int)startDateDay);
        if (repeating && startDate.after(until = recurrence.getUntil())) {
            throw new EventEndDateException();
        }
    }
}

