/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.asset;

import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.permission.CalEventPermission;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public class CalEventAssetRenderer
extends BaseAssetRenderer {
    private CalEvent _event;

    public CalEventAssetRenderer(CalEvent event) {
        this._event = event;
    }

    public long getClassPK() {
        return this._event.getEventId();
    }

    public String getDiscussionPath() {
        if (PropsValues.CALENDAR_EVENT_COMMENTS_ENABLED) {
            return "edit_event_discussion";
        }
        return null;
    }

    public long getGroupId() {
        return this._event.getGroupId();
    }

    public String getSummary(Locale locale) {
        return HtmlUtil.extractText((String)this._event.getDescription());
    }

    public String getTitle(Locale locale) {
        return this._event.getTitle();
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "8", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/calendar/edit_event");
        portletURL.setParameter("eventId", String.valueOf(this._event.getEventId()));
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL("8", "RENDER_PHASE");
        portletURL.setWindowState(windowState);
        portletURL.setParameter("struts_action", "/calendar/view_event");
        portletURL.setParameter("eventId", String.valueOf(this._event.getEventId()));
        return portletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/calendar/find_event", "eventId", this._event.getEventId());
    }

    public long getUserId() {
        return this._event.getUserId();
    }

    public String getUuid() {
        return this._event.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        return CalEventPermission.contains(permissionChecker, this._event, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return CalEventPermission.contains(permissionChecker, this._event, "VIEW");
    }

    public boolean isPrintable() {
        return true;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("CALENDAR_EVENT", (Object)this._event);
            return "/html/portlet/calendar/asset/" + template + ".jsp";
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/date.png";
    }
}

