/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.action;

import com.liferay.portal.kernel.cal.DayAndPosition;
import com.liferay.portal.kernel.cal.Duration;
import com.liferay.portal.kernel.cal.TZSRecurrence;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.calendar.EventDurationException;
import com.liferay.portlet.calendar.EventEndDateException;
import com.liferay.portlet.calendar.EventStartDateException;
import com.liferay.portlet.calendar.EventTitleException;
import com.liferay.portlet.calendar.NoSuchEventException;
import com.liferay.portlet.calendar.action.ActionUtil;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventServiceUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditEventAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateEvent(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteEvent(actionRequest);
            }
            WindowState windowState = actionRequest.getWindowState();
            if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                this.sendRedirect(actionRequest, actionResponse);
            } else {
                String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                if (Validator.isNotNull((String)redirect)) {
                    actionResponse.sendRedirect(redirect);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchEventException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.calendar.error");
            }
            if (e instanceof EventDurationException || e instanceof EventEndDateException || e instanceof EventStartDateException || e instanceof EventTitleException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getEvent((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchEventException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.calendar.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.calendar.edit_event"));
    }

    protected void addWeeklyDayPos(ActionRequest actionRequest, List<DayAndPosition> list, int day) {
        if (ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("weeklyDayPos" + day))) {
            list.add(new DayAndPosition(day, 0));
        }
    }

    protected void deleteEvent(ActionRequest actionRequest) throws Exception {
        long eventId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"eventId");
        CalEventServiceUtil.deleteEvent((long)eventId);
    }

    protected void updateEvent(ActionRequest actionRequest) throws Exception {
        long eventId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"eventId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        String location = ParamUtil.getString((PortletRequest)actionRequest, (String)"location");
        int startDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateMonth");
        int startDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateDay");
        int startDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateYear");
        int startDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateHour");
        int startDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateMinute");
        int startDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateAmPm");
        if (startDateAmPm == 1) {
            startDateHour += 12;
        }
        int durationHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"durationHour");
        int durationMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"durationMinute");
        boolean allDay = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allDay");
        boolean timeZoneSensitive = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"timeZoneSensitive");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        int endDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateMonth");
        int endDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateDay");
        int endDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateYear");
        boolean repeating = false;
        int recurrenceType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"recurrenceType");
        if (recurrenceType != 7) {
            repeating = true;
        }
        Locale locale = null;
        TimeZone timeZone = null;
        if (timeZoneSensitive) {
            User user = PortalUtil.getUser((PortletRequest)actionRequest);
            locale = user.getLocale();
            timeZone = user.getTimeZone();
        } else {
            locale = LocaleUtil.getDefault();
            timeZone = TimeZoneUtil.getDefault();
        }
        Calendar startDate = CalendarFactoryUtil.getCalendar((TimeZone)timeZone, (Locale)locale);
        startDate.set(2, startDateMonth);
        startDate.set(5, startDateDay);
        startDate.set(1, startDateYear);
        startDate.set(11, startDateHour);
        startDate.set(12, startDateMinute);
        startDate.set(13, 0);
        startDate.set(14, 0);
        if (allDay) {
            startDate.set(11, 0);
            startDate.set(12, 0);
            startDate.set(13, 0);
            startDate.set(14, 0);
            durationHour = 24;
            durationMinute = 0;
        }
        TZSRecurrence recurrence = null;
        if (repeating) {
            Calendar recStartCal = null;
            if (timeZoneSensitive) {
                recStartCal = CalendarFactoryUtil.getCalendar((TimeZone)TimeZoneUtil.getTimeZone((String)"UTC"));
                recStartCal.setTime(startDate.getTime());
            } else {
                recStartCal = (Calendar)startDate.clone();
            }
            recurrence = new TZSRecurrence(recStartCal, new Duration(1, 0, 0, 0), recurrenceType);
            recurrence.setTimeZone(timeZone);
            recurrence.setWeekStart(1);
            if (recurrenceType == 3) {
                int dailyType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dailyType");
                if (dailyType == 0) {
                    int dailyInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dailyInterval", (int)1);
                    recurrence.setInterval(dailyInterval);
                } else {
                    DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(2, 0), new DayAndPosition(3, 0), new DayAndPosition(4, 0), new DayAndPosition(5, 0), new DayAndPosition(6, 0)};
                    recurrence.setByDay(dayPos);
                }
            } else if (recurrenceType == 4) {
                int weeklyInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"weeklyInterval", (int)1);
                recurrence.setInterval(weeklyInterval);
                ArrayList<DayAndPosition> dayPos = new ArrayList<DayAndPosition>();
                this.addWeeklyDayPos(actionRequest, dayPos, 1);
                this.addWeeklyDayPos(actionRequest, dayPos, 2);
                this.addWeeklyDayPos(actionRequest, dayPos, 3);
                this.addWeeklyDayPos(actionRequest, dayPos, 4);
                this.addWeeklyDayPos(actionRequest, dayPos, 5);
                this.addWeeklyDayPos(actionRequest, dayPos, 6);
                this.addWeeklyDayPos(actionRequest, dayPos, 7);
                if (dayPos.size() == 0) {
                    dayPos.add(new DayAndPosition(2, 0));
                }
                recurrence.setByDay(dayPos.toArray(new DayAndPosition[0]));
            } else if (recurrenceType == 5) {
                int monthlyType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"monthlyType");
                if (monthlyType == 0) {
                    int monthlyDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"monthlyDay0");
                    recurrence.setByMonthDay(new int[]{monthlyDay});
                    int monthlyInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"monthlyInterval0", (int)1);
                    recurrence.setInterval(monthlyInterval);
                } else {
                    int monthlyPos = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"monthlyPos");
                    int monthlyDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"monthlyDay1");
                    DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(monthlyDay, monthlyPos)};
                    recurrence.setByDay(dayPos);
                    int monthlyInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"monthlyInterval1", (int)1);
                    recurrence.setInterval(monthlyInterval);
                }
            } else if (recurrenceType == 6) {
                int yearlyDay;
                int yearlyType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyType");
                if (yearlyType == 0) {
                    int yearlyMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyMonth0");
                    yearlyDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyDay0");
                    recurrence.setByMonth(new int[]{yearlyMonth});
                    recurrence.setByMonthDay(new int[]{yearlyDay});
                    int yearlyInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyInterval0", (int)1);
                    recurrence.setInterval(yearlyInterval);
                } else {
                    int yearlyPos = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyPos");
                    yearlyDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyDay1");
                    int yearlyMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyMonth1");
                    DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(yearlyDay, yearlyPos)};
                    recurrence.setByDay(dayPos);
                    recurrence.setByMonth(new int[]{yearlyMonth});
                    int yearlyInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyInterval1", (int)1);
                    recurrence.setInterval(yearlyInterval);
                }
            }
            int endDateType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateType");
            if (endDateType == 1) {
                int endDateOccurrence = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateOccurrence");
                recurrence.setOccurrence(endDateOccurrence);
            } else if (endDateType == 2) {
                Calendar endDate = CalendarFactoryUtil.getCalendar((TimeZone)timeZone);
                endDate.set(2, endDateMonth);
                endDate.set(5, endDateDay);
                endDate.set(1, endDateYear);
                endDate.set(11, startDateHour);
                endDate.set(12, startDateMinute);
                endDate.set(13, 0);
                endDate.set(14, 0);
                Calendar recEndCal = null;
                if (timeZoneSensitive) {
                    recEndCal = CalendarFactoryUtil.getCalendar((TimeZone)TimeZoneUtil.getTimeZone((String)"UTC"));
                    recEndCal.setTime(endDate.getTime());
                } else {
                    recEndCal = (Calendar)endDate.clone();
                }
                recurrence.setUntil(recEndCal);
            }
        }
        int remindBy = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"remindBy");
        int firstReminder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"firstReminder");
        int secondReminder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"secondReminder");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)CalEvent.class.getName(), (PortletRequest)actionRequest);
        if (eventId <= 0L) {
            CalEvent event = CalEventServiceUtil.addEvent((String)title, (String)description, (String)location, (int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)durationHour, (int)durationMinute, (boolean)allDay, (boolean)timeZoneSensitive, (String)type, (boolean)repeating, (TZSRecurrence)recurrence, (int)remindBy, (int)firstReminder, (int)secondReminder, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, CalEvent.class.getName(), event.getEventId(), -1);
        } else {
            CalEventServiceUtil.updateEvent((long)eventId, (String)title, (String)description, (String)location, (int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)durationHour, (int)durationMinute, (boolean)allDay, (boolean)timeZoneSensitive, (String)type, (boolean)repeating, (TZSRecurrence)recurrence, (int)remindBy, (int)firstReminder, (int)secondReminder, (ServiceContext)serviceContext);
        }
    }
}

