/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.util;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class BookmarksIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{BookmarksEntry.class.getName()};
    public static final String PORTLET_ID = "28";
    private static final boolean _PERMISSION_AWARE = true;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean isPermissionAware() {
        return true;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] folderIds = searchContext.getFolderIds();
        if (folderIds != null && folderIds.length > 0) {
            if (folderIds[0] == 0L) {
                return;
            }
            BooleanQuery folderIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            long[] lArray = folderIds;
            int n = folderIds.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    long folderId = lArray[n2];
                    try {
                        BookmarksFolderServiceUtil.getFolder((long)folderId);
                    }
                    catch (Exception exception) {
                        break block5;
                    }
                    folderIdsQuery.addTerm("folderId", folderId);
                }
                ++n2;
            }
            contextQuery.add((Query)folderIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        this.deleteDocument(entry.getCompanyId(), entry.getEntryId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)entry);
        document.addText("description", entry.getDescription());
        document.addKeyword("folderId", entry.getFolderId());
        document.addText("title", entry.getName());
        document.addText("url", entry.getUrl());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String url = document.get("url");
        String entryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/bookmarks/view_entry");
        portletURL.setParameter("entryId", entryId);
        return new Summary(title, url, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        Document document = this.getDocument(entry);
        SearchEngineUtil.updateDocument((long)entry.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        this.doReindex(entry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
        this.reindexRoot(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEntries(long companyId, long groupId, long folderId, int entryStart, int entryEnd) throws Exception {
        List entries = BookmarksEntryLocalServiceUtil.getEntries((long)groupId, (long)folderId, (int)entryStart, (int)entryEnd);
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (BookmarksEntry entry : entries) {
            Document document = this.getDocument(entry);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }

    protected void reindexFolders(long companyId) throws Exception {
        int folderCount = BookmarksFolderLocalServiceUtil.getCompanyFoldersCount((long)companyId);
        int folderPages = folderCount / 1000;
        int i = 0;
        while (i <= folderPages) {
            int folderStart = i * 1000;
            int folderEnd = folderStart + 1000;
            this.reindexFolders(companyId, folderStart, folderEnd);
            ++i;
        }
    }

    protected void reindexFolders(long companyId, int folderStart, int folderEnd) throws Exception {
        List folders = BookmarksFolderLocalServiceUtil.getCompanyFolders((long)companyId, (int)folderStart, (int)folderEnd);
        for (BookmarksFolder folder : folders) {
            long groupId = folder.getGroupId();
            long folderId = folder.getFolderId();
            int entryCount = BookmarksEntryLocalServiceUtil.getEntriesCount((long)groupId, (long)folderId);
            int entryPages = entryCount / 1000;
            int i = 0;
            while (i <= entryPages) {
                int entryStart = i * 1000;
                int entryEnd = entryStart + 1000;
                this.reindexEntries(companyId, groupId, folderId, entryStart, entryEnd);
                ++i;
            }
        }
    }

    protected void reindexRoot(long companyId) throws Exception {
        int groupCount = GroupLocalServiceUtil.getCompanyGroupsCount((long)companyId);
        int groupPages = groupCount / 1000;
        int i = 0;
        while (i <= groupPages) {
            int groupStart = i * 1000;
            int groupEnd = groupStart + 1000;
            this.reindexRoot(companyId, groupStart, groupEnd);
            ++i;
        }
    }

    protected void reindexRoot(long companyId, int groupStart, int groupEnd) throws Exception {
        List groups = GroupLocalServiceUtil.getCompanyGroups((long)companyId, (int)groupStart, (int)groupEnd);
        for (Group group : groups) {
            long groupId = group.getGroupId();
            long folderId = 0L;
            int entryCount = BookmarksEntryLocalServiceUtil.getEntriesCount((long)groupId, (long)folderId);
            int entryPages = entryCount / 1000;
            int i = 0;
            while (i <= entryPages) {
                int entryStart = i * 1000;
                int entryEnd = entryStart + 1000;
                this.reindexEntries(companyId, groupId, folderId, entryStart, entryEnd);
                ++i;
            }
        }
    }
}

