/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.base.BookmarksEntryServiceBaseImpl;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;
import com.liferay.portlet.bookmarks.util.comparator.EntryModifiedDateComparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksEntryServiceImpl
extends BookmarksEntryServiceBaseImpl {
    public BookmarksEntry addEntry(long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_ENTRY");
        return this.bookmarksEntryLocalService.addEntry(this.getUserId(), groupId, folderId, name, url, description, serviceContext);
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.bookmarksEntryLocalService.deleteEntry(entryId);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int start, int end) throws SystemException {
        return this.bookmarksEntryPersistence.filterFindByG_F(groupId, folderId, start, end);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.bookmarksEntryPersistence.filterFindByG_F(groupId, folderId, start, end, orderByComparator);
    }

    public int getEntriesCount(long groupId, long folderId) throws SystemException {
        return this.bookmarksEntryPersistence.filterCountByG_F(groupId, folderId);
    }

    public BookmarksEntry getEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "VIEW");
        return this.bookmarksEntryLocalService.getEntry(entryId);
    }

    public int getFoldersEntriesCount(long groupId, List<Long> folderIds) throws SystemException {
        return this.bookmarksEntryPersistence.filterCountByG_F(groupId, ArrayUtil.toArray((Long[])folderIds.toArray(new Long[folderIds.size()])));
    }

    public List<BookmarksEntry> getGroupEntries(long groupId, int start, int end) throws SystemException {
        return this.bookmarksEntryPersistence.filterFindByGroupId(groupId, start, end, (OrderByComparator)new EntryModifiedDateComparator());
    }

    public List<BookmarksEntry> getGroupEntries(long groupId, long userId, int start, int end) throws SystemException {
        EntryModifiedDateComparator orderByComparator = new EntryModifiedDateComparator();
        if (userId <= 0L) {
            return this.bookmarksEntryPersistence.filterFindByGroupId(groupId, start, end, (OrderByComparator)orderByComparator);
        }
        return this.bookmarksEntryPersistence.filterFindByG_U(groupId, userId, start, end, (OrderByComparator)orderByComparator);
    }

    public int getGroupEntriesCount(long groupId) throws SystemException {
        return this.bookmarksEntryPersistence.filterCountByGroupId(groupId);
    }

    public int getGroupEntriesCount(long groupId, long userId) throws SystemException {
        if (userId <= 0L) {
            return this.bookmarksEntryPersistence.filterCountByGroupId(groupId);
        }
        return this.bookmarksEntryPersistence.filterCountByG_U(groupId, userId);
    }

    public BookmarksEntry openEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "VIEW");
        return this.bookmarksEntryLocalService.openEntry(this.getGuestOrUserId(), entryId);
    }

    public BookmarksEntry updateEntry(long entryId, long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        return this.bookmarksEntryLocalService.updateEntry(this.getUserId(), entryId, groupId, folderId, name, url, description, serviceContext);
    }
}

