/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.model.BookmarksFolderSoap;
import com.liferay.portlet.bookmarks.service.BookmarksFolderServiceUtil;
import java.rmi.RemoteException;
import java.util.List;

public class BookmarksFolderServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(BookmarksFolderServiceSoap.class);

    public static BookmarksFolderSoap addFolder(long parentFolderId, String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            BookmarksFolder returnValue = BookmarksFolderServiceUtil.addFolder((long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            return BookmarksFolderSoap.toSoapModel((BookmarksFolder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFolder(long folderId) throws RemoteException {
        try {
            BookmarksFolderServiceUtil.deleteFolder((long)folderId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static BookmarksFolderSoap getFolder(long folderId) throws RemoteException {
        try {
            BookmarksFolder returnValue = BookmarksFolderServiceUtil.getFolder((long)folderId);
            return BookmarksFolderSoap.toSoapModel((BookmarksFolder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static BookmarksFolderSoap[] getFolders(long groupId) throws RemoteException {
        try {
            List returnValue = BookmarksFolderServiceUtil.getFolders((long)groupId);
            return BookmarksFolderSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static BookmarksFolderSoap[] getFolders(long groupId, long parentFolderId) throws RemoteException {
        try {
            List returnValue = BookmarksFolderServiceUtil.getFolders((long)groupId, (long)parentFolderId);
            return BookmarksFolderSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static BookmarksFolderSoap[] getFolders(long groupId, long parentFolderId, int start, int end) throws RemoteException {
        try {
            List returnValue = BookmarksFolderServiceUtil.getFolders((long)groupId, (long)parentFolderId, (int)start, (int)end);
            return BookmarksFolderSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersCount(long groupId, long parentFolderId) throws RemoteException {
        try {
            int returnValue = BookmarksFolderServiceUtil.getFoldersCount((long)groupId, (long)parentFolderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void getSubfolderIds(Long[] folderIds, long groupId, long folderId) throws RemoteException {
        try {
            BookmarksFolderServiceUtil.getSubfolderIds((List)ListUtil.toList((Object[])folderIds), (long)groupId, (long)folderId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static BookmarksFolderSoap updateFolder(long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws RemoteException {
        try {
            BookmarksFolder returnValue = BookmarksFolderServiceUtil.updateFolder((long)folderId, (long)parentFolderId, (String)name, (String)description, (boolean)mergeWithParentFolder, (ServiceContext)serviceContext);
            return BookmarksFolderSoap.toSoapModel((BookmarksFolder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

