/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksFolderServiceUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksFolderServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(BookmarksFolderServiceHttp.class);
    private static final Class<?>[] _addFolderParameterTypes0 = new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteFolderParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getFolderParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getFoldersParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getFoldersParameterTypes4 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getFoldersParameterTypes5 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getFoldersCountParameterTypes6 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getSubfolderIdsParameterTypes7 = new Class[]{List.class, Long.TYPE, Long.TYPE};
    private static final Class<?>[] _updateFolderParameterTypes8 = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Boolean.TYPE, ServiceContext.class};

    public static BookmarksFolder addFolder(HttpPrincipal httpPrincipal, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksFolderServiceUtil.class.getName(), "addFolder", (Class[])_addFolderParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{parentFolderId, name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (BookmarksFolder)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteFolder(HttpPrincipal httpPrincipal, long folderId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksFolderServiceUtil.class.getName(), "deleteFolder", (Class[])_deleteFolderParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BookmarksFolder getFolder(HttpPrincipal httpPrincipal, long folderId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksFolderServiceUtil.class.getName(), "getFolder", (Class[])_getFolderParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (BookmarksFolder)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BookmarksFolder> getFolders(HttpPrincipal httpPrincipal, long groupId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksFolderServiceUtil.class.getName(), "getFolders", (Class[])_getFoldersParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BookmarksFolder> getFolders(HttpPrincipal httpPrincipal, long groupId, long parentFolderId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksFolderServiceUtil.class.getName(), "getFolders", (Class[])_getFoldersParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentFolderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BookmarksFolder> getFolders(HttpPrincipal httpPrincipal, long groupId, long parentFolderId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksFolderServiceUtil.class.getName(), "getFolders", (Class[])_getFoldersParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentFolderId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getFoldersCount(HttpPrincipal httpPrincipal, long groupId, long parentFolderId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksFolderServiceUtil.class.getName(), "getFoldersCount", (Class[])_getFoldersCountParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentFolderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void getSubfolderIds(HttpPrincipal httpPrincipal, List<Long> folderIds, long groupId, long folderId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksFolderServiceUtil.class.getName(), "getSubfolderIds", (Class[])_getSubfolderIdsParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderIds, groupId, folderId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BookmarksFolder updateFolder(HttpPrincipal httpPrincipal, long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksFolderServiceUtil.class.getName(), "updateFolder", (Class[])_updateFolderParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderId, parentFolderId, name, description, mergeWithParentFolder, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (BookmarksFolder)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

