/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryServiceUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksEntryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(BookmarksEntryServiceHttp.class);
    private static final Class<?>[] _addEntryParameterTypes0 = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteEntryParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getEntriesParameterTypes2 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getEntriesParameterTypes3 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getEntriesCountParameterTypes4 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getEntryParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getFoldersEntriesCountParameterTypes6 = new Class[]{Long.TYPE, List.class};
    private static final Class<?>[] _getGroupEntriesParameterTypes7 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getGroupEntriesParameterTypes8 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getGroupEntriesCountParameterTypes9 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupEntriesCountParameterTypes10 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _openEntryParameterTypes11 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateEntryParameterTypes12 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, String.class, String.class, String.class, ServiceContext.class};

    public static BookmarksEntry addEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class.getName(), "addEntry", (Class[])_addEntryParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name, url, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class.getName(), "deleteEntry", (Class[])_deleteEntryParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BookmarksEntry> getEntries(HttpPrincipal httpPrincipal, long groupId, long folderId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class.getName(), "getEntries", (Class[])_getEntriesParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BookmarksEntry> getEntries(HttpPrincipal httpPrincipal, long groupId, long folderId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class.getName(), "getEntries", (Class[])_getEntriesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getEntriesCount(HttpPrincipal httpPrincipal, long groupId, long folderId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class.getName(), "getEntriesCount", (Class[])_getEntriesCountParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BookmarksEntry getEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class.getName(), "getEntry", (Class[])_getEntryParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getFoldersEntriesCount(HttpPrincipal httpPrincipal, long groupId, List<Long> folderIds) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class.getName(), "getFoldersEntriesCount", (Class[])_getFoldersEntriesCountParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderIds});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BookmarksEntry> getGroupEntries(HttpPrincipal httpPrincipal, long groupId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class.getName(), "getGroupEntries", (Class[])_getGroupEntriesParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BookmarksEntry> getGroupEntries(HttpPrincipal httpPrincipal, long groupId, long userId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class.getName(), "getGroupEntries", (Class[])_getGroupEntriesParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getGroupEntriesCount(HttpPrincipal httpPrincipal, long groupId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class.getName(), "getGroupEntriesCount", (Class[])_getGroupEntriesCountParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getGroupEntriesCount(HttpPrincipal httpPrincipal, long groupId, long userId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class.getName(), "getGroupEntriesCount", (Class[])_getGroupEntriesCountParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BookmarksEntry openEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class.getName(), "openEntry", (Class[])_openEntryParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BookmarksEntry updateEntry(HttpPrincipal httpPrincipal, long entryId, long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BookmarksEntryServiceUtil.class.getName(), "updateEntry", (Class[])_updateEntryParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId, groupId, folderId, name, url, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (BookmarksEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

