/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.asset;

import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class BookmarksEntryAssetRenderer
extends BaseAssetRenderer {
    private BookmarksEntry _entry;

    public BookmarksEntryAssetRenderer(BookmarksEntry entry) {
        this._entry = entry;
    }

    public long getClassPK() {
        return this._entry.getEntryId();
    }

    public long getGroupId() {
        return this._entry.getGroupId();
    }

    public String getSummary(Locale locale) {
        return HtmlUtil.stripHtml((String)this._entry.getDescription());
    }

    public String getTitle(Locale locale) {
        return this._entry.getName();
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "28", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/bookmarks/edit_entry");
        portletURL.setParameter("folderId", String.valueOf(this._entry.getFolderId()));
        portletURL.setParameter("entryId", String.valueOf(this._entry.getEntryId()));
        return portletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/bookmarks/find_entry", "entryId", this._entry.getEntryId());
    }

    public long getUserId() {
        return this._entry.getUserId();
    }

    public String getUuid() {
        return this._entry.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        try {
            return BookmarksEntryPermission.contains(permissionChecker, this._entry, "UPDATE");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        try {
            return BookmarksEntryPermission.contains(permissionChecker, this._entry, "VIEW");
        }
        catch (Exception exception) {
            return true;
        }
    }

    public boolean isPrintable() {
        return true;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("full_content")) {
            renderRequest.setAttribute("BOOKMARKS_ENTRY", (Object)this._entry);
            return "/html/portlet/bookmarks/asset/" + template + ".jsp";
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/ratings/star_hover.png";
    }
}

