/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xmlrpc.Method;
import com.liferay.portal.kernel.xmlrpc.Response;
import com.liferay.portal.kernel.xmlrpc.XmlRpcUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageDisplay;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.TextExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingbackMethodImpl
implements Method {
    public static int ACCESS_DENIED = 49;
    public static int GENERIC_FAULT = 0;
    public static int PINGBACK_ALREADY_REGISTERED = 48;
    public static int SERVER_ERROR = 50;
    public static int SOURCE_URI_DOES_NOT_EXIST = 16;
    public static int SOURCE_URI_INVALID = 17;
    public static int TARGET_URI_DOES_NOT_EXIST = 32;
    public static int TARGET_URI_INVALID = 33;
    private static Log _log = LogFactoryUtil.getLog(PingbackMethodImpl.class);
    private String _sourceUri;
    private String _targetUri;

    public Response execute(long companyId) {
        if (!PropsValues.BLOGS_PINGBACK_ENABLED) {
            return XmlRpcUtil.createFault((int)-32601, (String)"Pingbacks are disabled");
        }
        Response response = this.validateSource();
        if (response != null) {
            return response;
        }
        try {
            BlogsEntry entry = this.getBlogsEntry(companyId);
            if (!entry.isAllowPingbacks()) {
                return XmlRpcUtil.createFault((int)-32601, (String)"Pingbacks are disabled");
            }
            long userId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
            long groupId = entry.getGroupId();
            String className = BlogsEntry.class.getName();
            long classPK = entry.getEntryId();
            MBMessageDisplay messageDisplay = MBMessageLocalServiceUtil.getDiscussionMessageDisplay((long)userId, (long)groupId, (String)className, (long)classPK, (int)0);
            MBThread thread = messageDisplay.getThread();
            long threadId = thread.getThreadId();
            long parentMessageId = thread.getRootMessageId();
            String body = "[...] " + this.getExcerpt() + " [...] [url=" + this._sourceUri + "]" + LanguageUtil.get((Locale)LocaleUtil.getDefault(), (String)"read-more") + "[/url]";
            List messages = MBMessageLocalServiceUtil.getThreadMessages((long)threadId, (int)0);
            for (MBMessage message : messages) {
                if (!message.getBody().equals(body)) continue;
                return XmlRpcUtil.createFault((int)PINGBACK_ALREADY_REGISTERED, (String)"Pingback previously registered");
            }
            ServiceContext serviceContext = new ServiceContext();
            String pingbackUserName = LanguageUtil.get((Locale)LocaleUtil.getDefault(), (String)"pingback");
            serviceContext.setAttribute("pingbackUserName", (Serializable)((Object)pingbackUserName));
            StringBundler sb = new StringBundler(5);
            String layoutFullURL = PortalUtil.getLayoutFullURL((long)groupId, (String)"33");
            sb.append(layoutFullURL);
            sb.append("/-/");
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)"33");
            sb.append(portlet.getFriendlyURLMapping());
            sb.append("/");
            sb.append(entry.getUrlTitle());
            serviceContext.setAttribute("redirect", (Serializable)((Object)sb.toString()));
            serviceContext.setLayoutFullURL(layoutFullURL);
            MBMessageLocalServiceUtil.addDiscussionMessage((long)userId, (String)"", (long)groupId, (String)className, (long)classPK, (long)threadId, (long)parentMessageId, (String)"", (String)body, (ServiceContext)serviceContext);
            return XmlRpcUtil.createSuccess((String)"Pingback accepted");
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return XmlRpcUtil.createFault((int)TARGET_URI_INVALID, (String)"Error parsing target URI");
        }
    }

    public String getMethodName() {
        return "pingback.ping";
    }

    public String getToken() {
        return "pingback";
    }

    public boolean setArguments(Object[] arguments) {
        try {
            this._sourceUri = (String)arguments[0];
            this._targetUri = (String)arguments[1];
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected BlogsEntry getBlogsEntry(long companyId) throws Exception {
        BlogsEntry entry = null;
        URL url = new URL(this._targetUri);
        String friendlyURL = url.getPath();
        int end = friendlyURL.indexOf("/-/");
        if (end != -1) {
            friendlyURL = friendlyURL.substring(0, end);
        }
        long plid = PortalUtil.getPlidFromFriendlyURL((long)companyId, (String)friendlyURL);
        long groupId = PortalUtil.getScopeGroupId((long)plid);
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        FriendlyURLMapperThreadLocal.setPRPIdentifiers(new HashMap());
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)"33");
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        friendlyURL = url.getPath();
        end = friendlyURL.indexOf("/-/");
        if (end != -1) {
            friendlyURL = friendlyURL.substring(end + "/-/".length() - 1);
        }
        HashMap requestContext = new HashMap();
        friendlyURLMapper.populateParams(friendlyURL, params, requestContext);
        String param = this.getParam(params, "entryId");
        if (Validator.isNotNull((String)param)) {
            long entryId = GetterUtil.getLong((String)param);
            entry = BlogsEntryLocalServiceUtil.getEntry((long)entryId);
        } else {
            String urlTitle = this.getParam(params, "urlTitle");
            entry = BlogsEntryLocalServiceUtil.getEntry((long)groupId, (String)urlTitle);
        }
        return entry;
    }

    protected String getExcerpt() throws IOException {
        String html = HttpUtil.URLtoString((String)this._sourceUri);
        Source source = new Source((CharSequence)html);
        source.fullSequentialParse();
        List elements = source.getAllElements("a");
        for (Element element : elements) {
            String href = GetterUtil.getString((String)element.getAttributeValue("href"));
            if (!href.equals(this._targetUri)) continue;
            TextExtractor textExtractor = new TextExtractor((Segment)(element = element.getParentElement()));
            String body = textExtractor.toString();
            if (body.length() < PropsValues.BLOGS_LINKBACK_EXCERPT_LENGTH && (element = element.getParentElement()) != null) {
                textExtractor = new TextExtractor((Segment)element);
                body = textExtractor.toString();
            }
            return StringUtil.shorten((String)body, (int)PropsValues.BLOGS_LINKBACK_EXCERPT_LENGTH);
        }
        return "";
    }

    protected String getParam(Map<String, String[]> params, String name) {
        String[] paramArray = params.get(name);
        if (paramArray == null) {
            String namespace = PortalUtil.getPortletNamespace((String)"33");
            paramArray = params.get(String.valueOf(namespace) + name);
        }
        if (paramArray != null && paramArray.length > 0) {
            return paramArray[0];
        }
        return null;
    }

    protected Response validateSource() {
        Source source = null;
        try {
            String html = HttpUtil.URLtoString((String)this._sourceUri);
            source = new Source((CharSequence)html);
        }
        catch (Exception exception) {
            return XmlRpcUtil.createFault((int)SOURCE_URI_DOES_NOT_EXIST, (String)"Error accessing source URI");
        }
        List startTags = source.getAllStartTags("a");
        for (StartTag startTag : startTags) {
            String href = GetterUtil.getString((String)startTag.getAttributeValue("href"));
            if (!href.equals(this._targetUri)) continue;
            return null;
        }
        return XmlRpcUtil.createFault((int)SOURCE_URI_INVALID, (String)"Could not find target URI in source");
    }
}

