/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LinkbackConsumerUtil {
    private static Log _log = LogFactoryUtil.getLog(LinkbackConsumerUtil.class);
    private static List<Tuple> _trackbacks = Collections.synchronizedList(new ArrayList());

    public static void addNewTrackback(long messageId, String url, String entryUrl) {
        _trackbacks.add(new Tuple(new Object[]{messageId, url, entryUrl}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyNewTrackbacks() {
        Tuple tuple = null;
        while (!_trackbacks.isEmpty()) {
            List<Tuple> list = _trackbacks;
            synchronized (list) {
                tuple = _trackbacks.remove(0);
            }
            long messageId = (Long)tuple.getObject(0);
            String url = (String)tuple.getObject(1);
            String entryUrl = (String)tuple.getObject(2);
            LinkbackConsumerUtil._verifyTrackback(messageId, url, entryUrl);
        }
    }

    public static void verifyPost(BlogsEntry entry, MBMessage message) throws Exception {
        int end;
        long messageId = message.getMessageId();
        String entryURL = "/-/blogs/" + entry.getUrlTitle();
        String body = message.getBody();
        String url = null;
        int start = body.indexOf("[url=");
        if (start > -1 && (end = body.indexOf("]", start += "[url=".length())) > -1) {
            url = body.substring(start, end);
        }
        if (Validator.isNotNull(url)) {
            long defaultUserId;
            long companyId = message.getCompanyId();
            long userId = message.getUserId();
            if (userId == (defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId))) {
                LinkbackConsumerUtil._verifyTrackback(messageId, url, entryURL);
            }
        }
    }

    private static void _verifyTrackback(long messageId, String url, String entryURL) {
        try {
            String result = HttpUtil.URLtoString((String)url);
            if (result.contains(entryURL)) {
                return;
            }
        }
        catch (Exception exception) {}
        try {
            MBMessageLocalServiceUtil.deleteDiscussionMessage((long)messageId);
        }
        catch (Exception e) {
            _log.error((Object)("Error trying to delete trackback message " + messageId), (Throwable)e);
        }
    }
}

