/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class BlogsIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{BlogsEntry.class.getName()};
    public static final String PORTLET_ID = "33";
    private static final boolean _FILTER_SEARCH = true;
    private static final boolean _PERMISSION_AWARE = true;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean isPermissionAware() {
        return true;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long entryClassPK, String actionId) throws Exception {
        return BlogsEntryPermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public boolean isFilterSearch() {
        return true;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)-1);
        if (status != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        BlogsEntry entry = (BlogsEntry)obj;
        this.deleteDocument(entry.getCompanyId(), entry.getEntryId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        BlogsEntry entry = (BlogsEntry)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)entry);
        document.addText("content", HtmlUtil.extractText((String)entry.getContent()));
        document.addDate("modified", entry.getDisplayDate());
        document.addText("title", entry.getTitle());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        String entryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/blogs/view_entry");
        portletURL.setParameter("entryId", entryId);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        BlogsEntry entry = (BlogsEntry)obj;
        if (!entry.isApproved()) {
            return;
        }
        Document document = this.getDocument(entry);
        SearchEngineUtil.updateDocument((long)entry.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)classPK);
        this.doReindex(entry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexEntries(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEntries(long companyId) throws Exception {
        int count = BlogsEntryLocalServiceUtil.getCompanyEntriesCount((long)companyId, (Date)new Date(), (int)0);
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            this.reindexEntries(companyId, start, end);
            ++i;
        }
    }

    protected void reindexEntries(long companyId, int start, int end) throws Exception {
        List entries = BlogsEntryLocalServiceUtil.getCompanyEntries((long)companyId, (Date)new Date(), (int)0, (int)start, (int)end);
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (BlogsEntry entry : entries) {
            Document document = this.getDocument(entry);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }
}

