/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.social;

import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;

public class BlogsActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{BlogsEntry.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected SocialActivityFeedEntry doInterpret(SocialActivity activity, ThemeDisplay themeDisplay) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!BlogsEntryPermission.contains(permissionChecker, activity.getClassPK(), "VIEW")) {
            return null;
        }
        String groupName = "";
        if (activity.getGroupId() != themeDisplay.getScopeGroupId()) {
            groupName = this.getGroupName(activity.getGroupId(), themeDisplay);
        }
        String creatorUserName = this.getUserName(activity.getUserId(), themeDisplay);
        String receiverUserName = this.getUserName(activity.getReceiverUserId(), themeDisplay);
        int activityType = activity.getType();
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)activity.getClassPK());
        String link = String.valueOf(themeDisplay.getPortalURL()) + themeDisplay.getPathMain() + "/blogs/find_entry?entryId=" + activity.getClassPK();
        String titlePattern = null;
        if (activityType == 1 || activityType == 10005) {
            titlePattern = "activity-blogs-add-comment";
        } else if (activityType == 2) {
            titlePattern = "activity-blogs-add-entry";
        }
        if (Validator.isNotNull((String)groupName)) {
            titlePattern = String.valueOf(titlePattern) + "-in";
        }
        String entryTitle = this.wrapLink(link, HtmlUtil.escape((String)this.cleanContent(entry.getTitle())));
        Object[] titleArguments = new Object[]{groupName, creatorUserName, receiverUserName, entryTitle};
        String title = themeDisplay.translate(titlePattern, titleArguments);
        String body = "";
        return new SocialActivityFeedEntry(link, title, body);
    }
}

