/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.model.impl.BlogsEntryImpl;
import com.liferay.portlet.blogs.service.persistence.BlogsEntryFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogsEntryFinderImpl
extends BasePersistenceImpl<BlogsEntry>
implements BlogsEntryFinder {
    public static String COUNT_BY_ORGANIZATION_IDS = String.valueOf(BlogsEntryFinder.class.getName()) + ".countByOrganizationIds";
    public static String FIND_BY_GROUP_IDS = String.valueOf(BlogsEntryFinder.class.getName()) + ".findByGroupIds";
    public static String FIND_BY_ORGANIZATION_IDS = String.valueOf(BlogsEntryFinder.class.getName()) + ".findByOrganizationIds";
    public static String FIND_BY_NO_ASSETS = String.valueOf(BlogsEntryFinder.class.getName()) + ".findByNoAssets";

    public int countByOrganizationId(long organizationId, Date displayDate, int status) throws SystemException {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.countByOrganizationIds(organizationIds, displayDate, status);
    }

    public int countByOrganizationIds(List<Long> organizationIds, Date displayDate, int status) throws SystemException {
        Timestamp displayDate_TS = CalendarUtil.getTimestamp((Date)displayDate);
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_ORGANIZATION_IDS);
            if (status != -1) {
                sql = CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status = ?)");
            }
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            int i = 0;
            while (i < organizationIds.size()) {
                Long organizationId = organizationIds.get(i);
                qPos.add(organizationId);
                ++i;
            }
            qPos.add(displayDate_TS);
            if (status != -1) {
                qPos.add(status);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsEntry> findByGroupIds(long companyId, long groupId, Date displayDate, int status, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_GROUP_IDS);
            if (status != -1) {
                sql = CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status = ?)");
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("BlogsEntry", BlogsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(groupId);
            qPos.add(groupId);
            qPos.add(groupId);
            qPos.add((Object)displayDate);
            if (status != -1) {
                qPos.add(status);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsEntry> findByOrganizationId(long organizationId, Date displayDate, int status, int start, int end, OrderByComparator obc) throws SystemException {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.findByOrganizationIds(organizationIds, displayDate, status, start, end, obc);
    }

    public List<BlogsEntry> findByOrganizationIds(List<Long> organizationIds, Date displayDate, int status, int start, int end, OrderByComparator obc) throws SystemException {
        Timestamp displayDate_TS = CalendarUtil.getTimestamp((Date)displayDate);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ORGANIZATION_IDS);
            if (status != -1) {
                sql = CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status = ?)");
            }
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("BlogsEntry", BlogsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            int i = 0;
            while (i < organizationIds.size()) {
                Long organizationId = organizationIds.get(i);
                qPos.add(organizationId);
                ++i;
            }
            qPos.add(displayDate_TS);
            if (status != -1) {
                qPos.add(status);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsEntry> findByNoAssets() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("BlogsEntry", BlogsEntryImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getOrganizationIds(List<Long> organizationIds) {
        if (organizationIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(organizationIds.size() * 2 - 1);
        int i = 0;
        while (i < organizationIds.size()) {
            sb.append("Users_Orgs.organizationId = ? ");
            if (i + 1 != organizationIds.size()) {
                sb.append("OR ");
            }
            ++i;
        }
        return sb.toString();
    }
}

